/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ConnectQuotaExceededException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.QueuedIMAPProtocol;
import com.sun.mail.imap.QueuedIMAPProtocolWatcher;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.util.MailLogger;
import com.sun.mail.util.PropUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuingIMAPStore
extends IMAPStore {
    static final Logger LOG = LoggerFactory.getLogger(QueuingIMAPStore.class);
    private static volatile ScheduledThreadPoolExecutor executor;
    private static QueuedIMAPProtocolWatcher watcher;
    static final ConcurrentMap<URLName, CountingQueue> queues;
    private final boolean enableSASL;
    private transient Subject kerberosSubject;
    protected String[] saslMechanisms;
    protected String m_saslRealm;
    private String m_authorizationID;
    private String m_proxyAuthUser;

    public static Logger getLog() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledThreadPoolExecutor executor() {
        ScheduledThreadPoolExecutor exec = executor;
        if (null != exec) return exec;
        Class<QueuingIMAPStore> clazz = QueuingIMAPStore.class;
        synchronized (QueuingIMAPStore.class) {
            exec = executor;
            if (null != exec) return exec;
            SecurityManager s = System.getSecurityManager();
            final ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            final AtomicInteger threadNumber = new AtomicInteger(1);
            String namePrefix = "com.sun.mail.imap.PeriodicRunner-";
            ThreadFactory factory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(group, r, "com.sun.mail.imap.PeriodicRunner-" + threadNumber.getAndIncrement(), 0L);
                    if (t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            exec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() + 1, factory);
            exec.prestartCoreThread();
            final ScheduledThreadPoolExecutor texec = exec;
            exec.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    texec.purge();
                }
            }, 60000L, 60000L, TimeUnit.MILLISECONDS);
            executor = exec;
            QueuingIMAPStore.initWatcher(exec);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return exec;
        }
    }

    public static void shutdown() {
        ScheduledThreadPoolExecutor exec;
        QueuedIMAPProtocolWatcher tmp = watcher;
        if (null != tmp) {
            tmp.shutdown();
            watcher = null;
        }
        if (null != (exec = executor)) {
            exec.shutdown();
            executor = null;
        }
    }

    private static void initWatcher(ScheduledThreadPoolExecutor executor) {
        QueuedIMAPProtocolWatcher tmp = new QueuedIMAPProtocolWatcher();
        tmp.initWatcher(queues, executor);
        watcher = tmp;
    }

    private static CountingQueue initQueue(final URLName url, int permits, final MailLogger logger) {
        CountingQueue ns;
        CountingQueue q = (CountingQueue)queues.get(url);
        if (null == q && null == (q = queues.putIfAbsent(url, ns = new CountingQueue(permits, logger, QueuedIMAPProtocolWatcher.isEnabled())))) {
            q = ns;
            final boolean debug = logger.isLoggable(Level.FINE) || LOG.isDebugEnabled();
            final CountingQueue tq = q;
            final ConcurrentMap<URLName, CountingQueue> tqueues = queues;
            final AtomicInteger noneCount = new AtomicInteger();
            final AtomicReference futureRef = new AtomicReference();
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (debug) {
                        String msg = "Cleaner run. Elements in queue " + tq.hashCode() + ": " + tq.size();
                        logger.fine(msg);
                        LOG.debug(msg);
                    }
                    long minStamp = System.currentTimeMillis() - 4000L;
                    ReentrantLock lock = tq.lock;
                    lock.lock();
                    try {
                        boolean notInUse = tq.closeElapsed0(minStamp);
                        if (notInUse) {
                            if (noneCount.incrementAndGet() >= 3 && tqueues.remove(url, tq)) {
                                tq.deprecated = true;
                                ScheduledFuture future = futureRef.getAndSet(null);
                                if (null != future) {
                                    future.cancel(false);
                                }
                            }
                        } else {
                            noneCount.set(0);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            };
            ScheduledFuture<?> future = QueuingIMAPStore.executor().scheduleWithFixedDelay(t, 3L, 3L, TimeUnit.SECONDS);
            futureRef.set(future);
            if (debug) {
                String msg = "QueueingIMAPStore.initQueue(): New queue for \"" + url + "\": BlockingQueue@" + q.hashCode() + " " + q.toString();
                logger.fine(msg);
                LOG.debug(msg);
            }
        }
        return q;
    }

    public QueuingIMAPStore(Session session, URLName url, String name, boolean isSSL) {
        super(session, url, name, isSSL);
        this.enableSASL = PropUtil.getBooleanSessionProperty(session, "mail.imap.sasl.enable", false);
        if (this.enableSASL) {
            this.kerberosSubject = (Subject)session.getProperties().get("mail.imap.sasl.kerberosSubject");
            String s = session.getProperty("mail.imap.sasl.mechanisms");
            if (s != null && s.length() > 0) {
                ArrayList<String> v = new ArrayList<String>(5);
                StringTokenizer st = new StringTokenizer(s, " ,");
                while (st.hasMoreTokens()) {
                    String m = st.nextToken();
                    if (m.length() <= 0) continue;
                    v.add(m);
                }
                this.saslMechanisms = v.toArray(new String[0]);
            }
            if ((s = session.getProperty("mail.imap.sasl.realm")) != null) {
                this.m_saslRealm = s;
            }
            if ((s = session.getProperty("mail." + name + ".sasl.authorizationid")) != null) {
                this.m_authorizationID = s;
            }
            if ((s = session.getProperty("mail." + name + ".proxyauth.user")) != null) {
                this.m_proxyAuthUser = s;
            }
        }
    }

    public QueuingIMAPStore(Session session, URLName url) {
        this(session, url, "imap", false);
    }

    @Override
    protected IMAPProtocol newIMAPProtocol(String host, int port, String user, String password) throws IOException, ProtocolException {
        try {
            if (PropUtil.getBooleanSessionProperty(this.session, "mail.imap.forceAuthenticated", false)) {
                return super.newIMAPProtocol(host, port, user, password);
            }
            while (true) {
                try {
                    QueuedIMAPProtocol protocol;
                    boolean debug;
                    CountingQueue q = QueuingIMAPStore.initQueue(new URLName("imap", host, port, null, user, password), PropUtil.getIntSessionProperty(this.session, "mail.imap.maxNumAuthenticated", 0), this.logger);
                    boolean bl = debug = this.logger.isLoggable(Level.FINE) || LOG.isDebugEnabled();
                    if (debug) {
                        String msg = "QueueingIMAPStore.newIMAPProtocol(): " + Thread.currentThread().getName() + " is trying to create/fetch for user '" + user + "@" + host + "'. Pending threads " + q.trackedThreads();
                        this.logger.fine(msg);
                        LOG.debug(msg);
                    }
                    if (null != (protocol = q.takeOrIncrement(this))) {
                        if (debug) {
                            String msg = "QueueingIMAPStore.newIMAPProtocol(): Fetched from queue " + protocol.toString();
                            this.logger.fine(msg);
                            LOG.debug(msg);
                        }
                        q.addTrackingInfo(protocol.setStore(this));
                        return protocol;
                    }
                    protocol = new QueuedIMAPProtocol(this.name, host, port, this.session.getProperties(), this.isSSL, this.logger, q, this);
                    if (debug) {
                        String msg = "\nQueueingIMAPStore.newIMAPProtocol(): Created new protocol instance " + protocol.toString() + "\n\t(total=" + q.getNewCount() + ")";
                        this.logger.fine(msg);
                        LOG.debug(msg);
                    }
                    q.addTrackingInfo(protocol);
                    return protocol;
                }
                catch (DeprecatedQueueException e) {
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ProtocolException("Interrupted.", (Throwable)e);
        }
    }

    @Override
    protected void login(final IMAPProtocol p, final String u, final String pw) throws ProtocolException {
        if (p.isAuthenticated()) {
            super.login(p, u, pw);
            return;
        }
        if (!this.enableSASL || null == this.kerberosSubject) {
            super.login(p, u, pw);
            return;
        }
        final String authzid = this.m_authorizationID != null ? this.m_authorizationID : (this.m_proxyAuthUser != null ? this.m_proxyAuthUser : null);
        try {
            Subject.doAs(this.kerberosSubject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    p.sasllogin(QueuingIMAPStore.this.saslMechanisms, QueuingIMAPStore.this.m_saslRealm, authzid, u, pw);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            QueuingIMAPStore.handlePrivilegedActionException(e);
        }
    }

    private static void handlePrivilegedActionException(PrivilegedActionException e) throws ProtocolException {
        if (null == e) {
            return;
        }
        Exception cause = e.getException();
        if (null == cause) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (cause instanceof ProtocolException) {
            throw (ProtocolException)cause;
        }
        if (cause instanceof MessagingException) {
            MessagingException me = (MessagingException)cause;
            Exception nextException = me.getNextException();
            if (nextException instanceof ProtocolException) {
                throw (ProtocolException)nextException;
            }
            throw new ProtocolException(me.getMessage(), (Throwable)me);
        }
        throw new ProtocolException(e.getMessage(), (Throwable)cause);
    }

    static {
        queues = new ConcurrentHashMap<URLName, CountingQueue>(16);
    }

    static class DeprecatedQueueException
    extends RuntimeException {
        static final long serialVersionUID = -1848914673093228596L;

        DeprecatedQueueException() {
        }

        DeprecatedQueueException(String s) {
            super(s);
        }

        DeprecatedQueueException(String message, Throwable cause) {
            super(message, cause);
        }

        DeprecatedQueueException(Throwable cause) {
            super(cause);
        }
    }

    static final class ThreadTrace {
        final QueuedIMAPProtocol protocol;
        final long stamp;

        ThreadTrace(QueuedIMAPProtocol protocol, long stamp) {
            this.protocol = protocol;
            this.stamp = stamp;
        }
    }

    static final class CountingQueue
    extends AbstractQueue<QueuedIMAPProtocol>
    implements BlockingQueue<QueuedIMAPProtocol>,
    Serializable {
        private static final long serialVersionUID = 5595510919245408276L;
        final PriorityQueue<QueuedIMAPProtocol> q;
        final ReentrantLock lock = new ReentrantLock(true);
        boolean deprecated = false;
        private final MailLogger logger;
        private final Condition notEmpty = this.lock.newCondition();
        private final int max;
        private int newCount = 0;
        private final ConcurrentMap<QueuingIMAPStore, QueuingIMAPStore> stores;
        private final ConcurrentMap<Thread, ThreadTrace> threads;

        public CountingQueue(int max, MailLogger logger, boolean trackThreads) {
            this.logger = logger;
            this.q = new PriorityQueue(max < 1 ? 11 : max);
            this.max = max <= 0 ? Integer.MAX_VALUE : max;
            this.stores = new ConcurrentHashMap<QueuingIMAPStore, QueuingIMAPStore>(max < 1 ? 11 : max);
            this.threads = trackThreads ? new ConcurrentHashMap(max < 1 ? 11 : max) : null;
        }

        public MailLogger getLogger() {
            return this.logger;
        }

        public ConcurrentMap<Thread, ThreadTrace> trackedThreads() {
            return this.threads;
        }

        public void addTrackingInfo(QueuedIMAPProtocol protocol) {
            QueuingIMAPStore store = protocol.store;
            this.stores.putIfAbsent(store, store);
            ConcurrentMap<Thread, ThreadTrace> threads = this.threads;
            if (null != threads) {
                threads.putIfAbsent(Thread.currentThread(), new ThreadTrace(protocol, System.currentTimeMillis()));
            }
        }

        public void removeTrackingInfo(QueuedIMAPProtocol protocol) {
            ConcurrentMap<Thread, ThreadTrace> threads;
            if (null != protocol) {
                this.stores.remove(protocol.store);
            }
            if (null != (threads = this.threads)) {
                threads.remove(Thread.currentThread());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNewCount() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int n = this.newCount;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean closeElapsed(long minStamp) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean bl = this.closeElapsed0(minStamp);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        boolean closeElapsed0(long minStamp) {
            QueuedIMAPProtocol x;
            if (this.q.isEmpty() && this.newCount <= 0) {
                return true;
            }
            while ((x = this.q.peek()) != null && x.getAuthenticatedStamp() < minStamp) {
                x = this.q.poll();
                assert (x != null);
                this.safeLogout(x);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void safeLogout(QueuedIMAPProtocol x) {
            boolean loggedOut = false;
            try {
                x.realLogout();
                loggedOut = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (!loggedOut) {
                    this.decrementNewCount();
                }
            }
        }

        public QueuedIMAPProtocol takeOrIncrement(QueuingIMAPStore store) throws InterruptedException, ProtocolException {
            return this.takeOrIncrement(store, 20L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedIMAPProtocol takeOrIncrement(QueuingIMAPStore store, long timeout, TimeUnit unit) throws InterruptedException, ProtocolException {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                QueuedIMAPProtocol x;
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                long nanos = unit.toNanos(timeout);
                try {
                    while ((x = this.q.poll()) == null && this.newCount >= this.max && nanos > 0L) {
                        if (this.stores.containsKey(store)) {
                            throw new ConnectQuotaExceededException("No connection available and not allowed to open further ones");
                        }
                        nanos = this.notEmpty.awaitNanos(nanos);
                    }
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ie;
                }
                if (null != x) {
                    QueuedIMAPProtocol queuedIMAPProtocol = x;
                    return queuedIMAPProtocol;
                }
                if (nanos <= 0L || this.newCount >= this.max) {
                    throw new ConnectQuotaExceededException("No connection available and not allowed to open more than " + this.max + " connections. Waited " + unit.toSeconds(timeout) + " seconds");
                }
                ++this.newCount;
                QueuedIMAPProtocol queuedIMAPProtocol = null;
                return queuedIMAPProtocol;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementNewCount() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.newCount > 0) {
                    --this.newCount;
                }
                this.notEmpty.signal();
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean add(QueuedIMAPProtocol e) {
            return this.offer(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(QueuedIMAPProtocol e) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                boolean ok = this.q.offer(e);
                assert (ok);
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offerIfAbsent(QueuedIMAPProtocol e) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                if (this.q.contains(e)) {
                    boolean bl = true;
                    return bl;
                }
                boolean ok = this.q.offer(e);
                assert (ok);
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void put(QueuedIMAPProtocol e) {
            this.offer(e);
        }

        @Override
        public boolean offer(QueuedIMAPProtocol e, long timeout, TimeUnit unit) {
            return this.offer(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueuedIMAPProtocol poll() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                QueuedIMAPProtocol queuedIMAPProtocol = this.q.poll();
                return queuedIMAPProtocol;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueuedIMAPProtocol take() throws InterruptedException {
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                try {
                    while (this.q.size() == 0) {
                        this.notEmpty.await();
                    }
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ie;
                }
                QueuedIMAPProtocol x = this.q.poll();
                assert (x != null);
                QueuedIMAPProtocol queuedIMAPProtocol = x;
                return queuedIMAPProtocol;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public QueuedIMAPProtocol poll(long timeout, TimeUnit unit) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueuedIMAPProtocol peek() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                QueuedIMAPProtocol queuedIMAPProtocol = this.q.peek();
                return queuedIMAPProtocol;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int n = this.q.size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.deprecated) {
                    throw new DeprecatedQueueException("Queue is deprecated");
                }
                boolean bl = this.q.remove(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean bl = this.q.contains(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object[] objectArray = this.q.toArray();
                return objectArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                String string = this.q.toString();
                return string;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super QueuedIMAPProtocol> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                QueuedIMAPProtocol e;
                int n = 0;
                while ((e = this.q.poll()) != null) {
                    c.add(e);
                    ++n;
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super QueuedIMAPProtocol> c, int maxElements) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            if (maxElements <= 0) {
                return 0;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                QueuedIMAPProtocol e;
                int n;
                for (n = 0; n < maxElements && (e = this.q.poll()) != null; ++n) {
                    c.add(e);
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.q.clear();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                T[] TArray = this.q.toArray(a);
                return TArray;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Iterator<QueuedIMAPProtocol> iterator() {
            return new Itr(this.toArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            this.lock.lock();
            try {
                s.defaultWriteObject();
            }
            finally {
                this.lock.unlock();
            }
        }

        private class Itr
        implements Iterator<QueuedIMAPProtocol> {
            final Object[] array;
            int cursor;
            int lastRet = -1;

            Itr(Object[] array) {
                this.array = array;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            @Override
            public QueuedIMAPProtocol next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return (QueuedIMAPProtocol)this.array[this.cursor++];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                Object x = this.array[this.lastRet];
                this.lastRet = -1;
                CountingQueue.this.lock.lock();
                try {
                    Iterator<QueuedIMAPProtocol> it = CountingQueue.this.q.iterator();
                    while (it.hasNext()) {
                        if (it.next() != x) continue;
                        it.remove();
                        return;
                    }
                }
                finally {
                    CountingQueue.this.lock.unlock();
                }
            }
        }
    }
}

