/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet.idn;

import javax.mail.internet.AddressException;
import javax.mail.internet.idn.IDNA;
import org.junit.Assert;
import org.junit.Test;

public class IDNATest {
    @Test
    public void testToACE_ParamNull_ReturnNull() throws AddressException {
        String aceText = IDNA.toACE(null);
        Assert.assertNull((Object)aceText);
    }

    @Test
    public void testToACE_ParamIsEmptyString_ReturnEmptyString() throws AddressException {
        String aceText = IDNA.toACE((String)"");
        Assert.assertNotNull((Object)aceText);
        Assert.assertEquals((long)0L, (long)aceText.length());
    }

    @Test
    public void testToACE_OnlyMailAdressWithUmlaute_ConvertToAscii() throws AddressException {
        String testString = "someone@m\u00fcller.de";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)"someone@xn--mller-kva.de", (Object)aceText);
    }

    @Test
    public void testToACE_MailAdressWithUmlauteAndContent_ReturnParamString() throws AddressException {
        String testString = "\"Sch\u00f6nmackers Umweltdienste - Abrechnung \" <zentrale.abrechnung@schoenmackers.de>";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)testString, (Object)aceText);
    }

    @Test
    public void testToACE_MailAdressWithUmlauteAndUtfPrefix_ReturnParamString() throws AddressException {
        String testString = "=?UTF-8?B?w5xiZXJ3ZWlzdW5n? =\" <\u00fcberweisung@aftrapp.com>";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)testString, (Object)aceText);
    }

    @Test
    public void testToACE_WithoutUmlaute_ReturnParamString() throws AddressException {
        String testString = "martin.schneider@open-xchange.com";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)testString, (Object)aceText);
    }

    @Test
    public void testToACE_WithoutUmlauteButLessAndGreaterSigns_ReturnParamString() throws AddressException {
        String testString = "<martin.schneider@open-xchange.com>";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)testString, (Object)aceText);
    }

    @Test
    public void testToACE_WithUmlauteAndLessAndGreaterSigns_ConvertToAscii() throws AddressException {
        String testString = "<martin.schneider@\u00f6pen-xch\u00e4nge.com>";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)"<martin.schneider@xn--pen-xchnge-w5a2s.com>", (Object)aceText);
    }

    @Test
    public void testToACE_WithUmlauteWithoutLessAndGreaterSigns_ConvertToAscii() throws AddressException {
        String testString = "martin.schneider@\u00f6pen-xch\u00e4nge.com";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)"martin.schneider@xn--pen-xchnge-w5a2s.com", (Object)aceText);
    }

    @Test
    public void testToACE_NotValidEmail_ReturnParamString() throws AddressException {
        String testString = "<m\u00e4rtin.schneider";
        String aceText = IDNA.toACE((String)testString);
        Assert.assertEquals((Object)testString, (Object)aceText);
    }
}

