/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.anonymizer;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Anonymizers;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.share.ShareService;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.user.json.osgi.Services;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UserAnonymizerService
implements AnonymizerService<User> {
    public Module getModule() {
        return Module.USER;
    }

    public User anonymize(User entity, Session session) throws OXException {
        Set userIds;
        if (null == entity) {
            return null;
        }
        if (session.getUserId() == entity.getId()) {
            return entity;
        }
        if (entity.getId() == ServerSessionAdapter.valueOf((Session)session).getUser().getCreatedBy()) {
            return entity;
        }
        ShareService shareService = Services.getService(ShareService.class);
        if (null != shareService && (userIds = shareService.getSharingUsersFor(session.getContextId(), session.getUserId())).contains(entity.getId())) {
            return entity;
        }
        return new AnonymizingUser(entity, session);
    }

    private static final class AnonymizingUser
    implements User {
        private static final long serialVersionUID = -3389011471434047151L;
        private final User delegate;
        private final String displayName;
        private final String i18n;

        AnonymizingUser(User delegate, Session session) throws OXException {
            this.delegate = delegate;
            this.i18n = Anonymizers.getUserI18nFor((Session)session);
            this.displayName = this.i18n + ' ' + delegate.getId();
        }

        public String getUserPassword() {
            return null;
        }

        public String getPasswordMech() {
            return null;
        }

        public int getId() {
            return this.delegate.getId();
        }

        public int getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        public boolean isGuest() {
            return this.delegate.isGuest();
        }

        public boolean isMailEnabled() {
            return this.delegate.isMailEnabled();
        }

        public int getShadowLastChange() {
            return this.delegate.getShadowLastChange();
        }

        public String getImapServer() {
            return this.delegate.getImapServer();
        }

        public String getImapLogin() {
            return this.delegate.getImapLogin();
        }

        public String getSmtpServer() {
            return this.delegate.getSmtpServer();
        }

        public String getMailDomain() {
            return this.delegate.getMailDomain();
        }

        public String getGivenName() {
            return Integer.toString(this.delegate.getId());
        }

        public String getSurname() {
            return this.i18n;
        }

        public String getMail() {
            return null;
        }

        public String[] getAliases() {
            return new String[0];
        }

        public Map<String, Set<String>> getAttributes() {
            return new HashMap<String, Set<String>>(0);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTimeZone() {
            return this.delegate.getTimeZone();
        }

        public String getPreferredLanguage() {
            return this.delegate.getPreferredLanguage();
        }

        public Locale getLocale() {
            return this.delegate.getLocale();
        }

        public int[] getGroups() {
            return this.delegate.getGroups();
        }

        public int getContactId() {
            return this.delegate.getContactId();
        }

        public String getLoginInfo() {
            return this.delegate.getLoginInfo();
        }

        public String[] getFileStorageAuth() {
            return this.delegate.getFileStorageAuth();
        }

        public long getFileStorageQuota() {
            return this.delegate.getFileStorageQuota();
        }

        public int getFilestoreId() {
            return this.delegate.getFilestoreId();
        }

        public String getFilestoreName() {
            return this.delegate.getFilestoreName();
        }

        public int getFileStorageOwner() {
            return this.delegate.getFileStorageOwner();
        }
    }
}

