/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.annotations.OAuthModule;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.user.json.actions.MeAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Module(name="user/me", description="Provides access to user information.")
@OAuthModule
public final class UserMeActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions;
    private final ServiceLookup services;

    public UserMeActionFactory(ServiceLookup services) {
        this.services = services;
        this.actions = this.initActions();
    }

    public AJAXActionService createActionService(String action) throws OXException {
        if (null == action) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(new Object[]{action});
        }
        AJAXActionService retval = this.actions.get(action);
        if (null == retval) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(new Object[]{action});
        }
        return retval;
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    private Map<String, AJAXActionService> initActions() {
        HashMap<String, MeAction> tmp = new HashMap<String, MeAction>(2);
        tmp.put("GET", new MeAction(this.services));
        return Collections.unmodifiableMap(tmp);
    }
}

