/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utility {
    private static final ConcurrentMap<String, Future<TimeZone>> ZONE_CACHE = new ConcurrentHashMap<String, Future<TimeZone>>();
    private static final Pattern PAT = Pattern.compile(" *, *");
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    private Utility() {
    }

    public static TimeZone getTimeZone(final String ID) {
        FutureTask<TimeZone> ft;
        FutureTask<TimeZone> f = (FutureTask<TimeZone>)ZONE_CACHE.get(ID);
        if (f == null && null == (f = (Future)ZONE_CACHE.putIfAbsent(ID, ft = new FutureTask<TimeZone>(new Callable<TimeZone>(){

            @Override
            public TimeZone call() throws Exception {
                return TimeZone.getTimeZone(ID);
            }
        })))) {
            ft.run();
            f = ft;
        }
        try {
            return (TimeZone)f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Logger LOG = LoggerFactory.getLogger(Utility.class);
            LOG.error("", (Throwable)e);
        }
        return TimeZone.getTimeZone(ID);
    }

    public static long addTimeZoneOffset(long date, String timeZone) {
        return date + (long)Utility.getTimeZone(timeZone).getOffset(date);
    }

    public static long addTimeZoneOffset(long date, TimeZone timeZone) {
        return date + (long)timeZone.getOffset(date);
    }

    public static int[] checkForRequiredField(int[] fields, int requiredField) {
        for (int field : fields) {
            if (requiredField != field) continue;
            return fields;
        }
        int[] checkedCols = new int[fields.length + 1];
        System.arraycopy(fields, 0, checkedCols, 0, fields.length);
        checkedCols[fields.length] = requiredField;
        return checkedCols;
    }

    public static int[] parseOptionalIntArrayParameter(String parameterName, AJAXRequestData request) {
        String tmp = request.getParameter(parameterName);
        if (null == tmp) {
            return new int[0];
        }
        String[] sa = PAT.split(tmp, 0);
        int[] columns = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            columns[i] = Integer.parseInt(sa[i]);
        }
        return columns;
    }

    public static Map<String, List<String>> getAttributeParameters(Set<String> expectedParameterNames, AJAXRequestData request) throws OXException {
        Iterator nonMatchingParameters = request.getNonMatchingParameters(expectedParameterNames);
        if (!nonMatchingParameters.hasNext()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<String>> attributeParameters = new LinkedHashMap<String, List<String>>();
        do {
            String value;
            int pos;
            Map.Entry entry;
            String key;
            ArrayList<String> list;
            if (null == (list = (ArrayList<String>)attributeParameters.get(key = (String)(entry = (Map.Entry)nonMatchingParameters.next()).getKey()))) {
                list = new ArrayList<String>(4);
                attributeParameters.put(key, list);
            }
            if ((pos = (value = (String)entry.getValue()).indexOf(42)) < 0) {
                String[] strings;
                for (String string : strings = SPLIT.split(value, 0)) {
                    list.add(string);
                }
            } else {
                if (value.length() > 1) {
                    throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(new Object[]{key, value});
                }
                list.add("*");
            }
        } while (nonMatchingParameters.hasNext());
        return attributeParameters;
    }
}

