/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.filter;

import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.filter.NoGlobalAdressBookUserCensorship;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;

public class NoGlobalAddressBookUserCensorshipTest
extends TestCase {
    private static final Map<Class, Object> DEFAULT_VALUES = new HashMap<Class, Object>(){
        {
            this.put(String.class, "Some String");
            this.put(Date.class, new Date());
            this.put(Integer.class, 12);
            this.put(Integer.TYPE, 12);
            this.put(byte[].class, new byte[0]);
            this.put(Boolean.class, true);
            this.put(Boolean.TYPE, true);
            this.put(Locale.class, Locale.getDefault());
            this.put(String[].class, new String[0]);
        }
    };

    public void testCensorsData() throws Exception {
        User user = this.getFilledUser();
        NoGlobalAdressBookUserCensorship censorship = new NoGlobalAdressBookUserCensorship();
        user = censorship.censor(user);
        for (UserField field : UserField.ALL_FIELDS) {
            if (!UserField.isUserOnlyField((int)field.getColumn())) continue;
            Object value = this.get(field, user);
            if (UserField.UNPROTECTED_FIELDS.contains(field)) {
                NoGlobalAddressBookUserCensorshipTest.assertFalse((String)("Should have remained untouched: " + field), (value != null ? 1 : 0) != 0);
                continue;
            }
            NoGlobalAddressBookUserCensorshipTest.assertTrue((String)("Should have been hidden: " + field), (value == null || -1 == (Integer)value ? 1 : 0) != 0);
        }
    }

    private Object get(UserField field, User user) {
        switch (field) {
            case ALIASES: {
                return user.getAliases();
            }
            case TIME_ZONE: {
                return user.getTimeZone();
            }
            case LOCALE: {
                return user.getLocale();
            }
            case GROUPS: {
                return user.getGroups();
            }
            case CONTACT_ID: {
                return user.getContactId();
            }
            case LOGIN_INFO: {
                return user.getLoginInfo();
            }
        }
        return null;
    }

    private User getFilledUser() throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptors;
        UserImpl user = new UserImpl();
        BeanInfo beanInfo = Introspector.getBeanInfo(UserImpl.class);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null) continue;
            Object value = DEFAULT_VALUES.get(writeMethod.getParameterTypes()[0]);
            if (value != null) {
                writeMethod.invoke((Object)user, value);
                continue;
            }
            System.err.println("No value found for setter: " + writeMethod);
        }
        return user;
    }
}

