/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.timer.internal;

import com.openexchange.threadpool.DelayedQueueProvider;
import com.openexchange.threadpool.internal.CustomThreadPoolExecutor;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.WrappingScheduledTimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class CustomThreadPoolExecutorTimerService
implements TimerService,
DelayedQueueProvider {
    private final CustomThreadPoolExecutor executorService;

    public CustomThreadPoolExecutorTimerService(CustomThreadPoolExecutor executorService) {
        this.executorService = executorService;
        final class PurgeRunnable
        implements Runnable {
            private final CustomThreadPoolExecutor exec;

            public PurgeRunnable(CustomThreadPoolExecutor exec) {
                this.exec = exec;
            }

            @Override
            public void run() {
                this.exec.purge();
            }
        }
        executorService.scheduleWithFixedDelay(new PurgeRunnable(executorService), 30L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public BlockingQueue<Runnable> getDelayedWorkQueue() {
        return this.executorService.getDelayedWorkQueue();
    }

    @Override
    public ScheduledTimerTask schedule(Runnable command, long delay, TimeUnit unit) {
        return new WrappingScheduledTimerTask(this.executorService.schedule(command, delay, unit));
    }

    @Override
    public ScheduledTimerTask schedule(Runnable command, long delay) {
        return this.schedule(command, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTimerTask scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return new WrappingScheduledTimerTask(this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit));
    }

    @Override
    public ScheduledTimerTask scheduleAtFixedRate(Runnable command, long initialDelay, long period) {
        return this.scheduleAtFixedRate(command, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTimerTask scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return new WrappingScheduledTimerTask(this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit));
    }

    @Override
    public ScheduledTimerTask scheduleWithFixedDelay(Runnable command, long initialDelay, long delay) {
        return this.scheduleWithFixedDelay(command, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void purge() {
        this.executorService.purge();
    }

    @Override
    public Executor getExecutor() {
        return this.executorService;
    }
}

