/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.sql;

import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.sql.builder.StatementBuilder;
import com.openexchange.sql.grammar.Command;
import com.openexchange.sql.grammar.Constant;
import com.openexchange.sql.grammar.EQUALS;
import com.openexchange.sql.grammar.Predicate;
import com.openexchange.sql.grammar.SELECT;
import com.openexchange.sql.schema.Tables;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.sql.AbstractSubscriptionSQLStorageTest;
import java.sql.SQLException;
import java.util.List;

public class SubscriptionSQLStorageTest
extends AbstractSubscriptionSQLStorageTest {
    public void testRemember() throws Exception {
        this.storage.rememberSubscription(this.subscription2);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription2.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription2.getId()));
        SELECT select = new SELECT(Constant.ASTERISK).FROM(Tables.subscriptions).WHERE(new EQUALS("id", (Object)Autoboxing.I((int)this.subscription2.getId())).AND((Predicate)new EQUALS("cid", (Object)Autoboxing.I((int)this.ctx.getContextId()))).AND((Predicate)new EQUALS("user_id", (Object)Autoboxing.I((int)this.userId))).AND((Predicate)new EQUALS("source_id", (Object)"com.openexchange.subscribe.test.basic2")).AND((Predicate)new EQUALS("folder_id", (Object)this.folderId)).AND((Predicate)new EQUALS("last_update", (Object)Autoboxing.L((long)this.lastUpdate))).AND((Predicate)new EQUALS("enabled", (Object)false)));
        this.assertResult(new StatementBuilder().buildCommand((Command)select));
    }

    public void testForget() throws Exception {
        this.storage.rememberSubscription(this.subscription2);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription2.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription2.getId()));
        this.storage.forgetSubscription(this.subscription2);
        SELECT select = new SELECT(Constant.ASTERISK).FROM(Tables.subscriptions).WHERE(new EQUALS("id", (Object)Autoboxing.I((int)this.subscription2.getId())).AND((Predicate)new EQUALS("cid", (Object)Autoboxing.I((int)this.ctx.getContextId()))).AND((Predicate)new EQUALS("user_id", (Object)Autoboxing.I((int)this.userId))).AND((Predicate)new EQUALS("source_id", (Object)"com.openexchange.subscribe.test.basic2")).AND((Predicate)new EQUALS("folder_id", (Object)this.folderId)).AND((Predicate)new EQUALS("last_update", (Object)Autoboxing.L((long)this.lastUpdate))));
        this.assertNoResult(new StatementBuilder().buildCommand((Command)select));
    }

    public void testListGet() throws Exception {
        this.clearFolder(this.folderId);
        this.storage.rememberSubscription(this.subscription);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription.getId()));
        this.storage.rememberSubscription(this.subscription2);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription2.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription2.getId()));
        List list = this.storage.getSubscriptions(this.ctx, this.folderId);
        SubscriptionSQLStorageTest.assertEquals((String)"Number of Subscriptions does not match", (int)2, (int)list.size());
        for (Subscription loadedSubscription : list) {
            if (loadedSubscription.getId() == this.subscription.getId()) {
                this.assertEquals(this.subscription, loadedSubscription);
                continue;
            }
            if (loadedSubscription.getId() == this.subscription2.getId()) {
                this.assertEquals(this.subscription2, loadedSubscription);
                continue;
            }
            SubscriptionSQLStorageTest.fail((String)"Unexpected subscription loaded");
        }
    }

    public void testUpdate() throws Exception {
        this.storage.rememberSubscription(this.subscription);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription.getId()));
        this.subscription2.setId(this.subscription.getId());
        this.storage.updateSubscription(this.subscription2);
        SubscriptionSQLStorageTest.assertEquals((String)"Id should not changed", (int)this.subscription.getId(), (int)this.subscription2.getId());
        SELECT select = new SELECT(Constant.ASTERISK).FROM(Tables.subscriptions).WHERE(new EQUALS("id", (Object)Autoboxing.I((int)this.subscription.getId())).AND((Predicate)new EQUALS("cid", (Object)Autoboxing.I((int)this.ctx.getContextId()))).AND((Predicate)new EQUALS("user_id", (Object)Autoboxing.I((int)this.userId))).AND((Predicate)new EQUALS("source_id", (Object)"com.openexchange.subscribe.test.basic2")).AND((Predicate)new EQUALS("folder_id", (Object)this.subscription2.getFolderId())).AND((Predicate)new EQUALS("last_update", (Object)Autoboxing.L((long)this.subscription2.getLastUpdate()))).AND((Predicate)new EQUALS("enabled", (Object)false)));
        this.assertResult(new StatementBuilder().buildCommand((Command)select));
    }

    public void testIDCheckDuringRemember() throws Exception {
        this.subscription.setId(123);
        try {
            this.storage.rememberSubscription(this.subscription);
            this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription.getId()));
            SubscriptionSQLStorageTest.fail((String)"Exception expected");
        }
        catch (OXException e) {
            SubscriptionSQLStorageTest.assertTrue((String)"Wrong error code", (boolean)SubscriptionErrorMessage.IDGiven.equals(e));
        }
    }

    public void testGet() throws Exception {
        this.storage.rememberSubscription(this.subscription2);
        SubscriptionSQLStorageTest.assertTrue((String)"Id should be greater 0", (this.subscription2.getId() > 0 ? 1 : 0) != 0);
        this.subscriptionsToDelete.add(Autoboxing.I((int)this.subscription2.getId()));
        Subscription loadedSubscription = this.storage.getSubscription(this.ctx, this.subscription2.getId());
        this.assertEquals(this.subscription2, loadedSubscription);
    }

    public void testDeleteAllSubscriptionsOfAUser() throws OXException, SQLException {
        this.storage.rememberSubscription(this.subscription);
        this.storage.deleteAllSubscriptionsForUser(this.userId, this.ctx);
        SELECT select = new SELECT(Constant.ASTERISK).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Object)Autoboxing.I((int)this.ctx.getContextId())).AND((Predicate)new EQUALS("user_id", (Object)Autoboxing.I((int)this.userId))));
        this.assertNoResult(new StatementBuilder().buildCommand((Command)select));
    }

    public void testDeleteAllSubscriptionsOfAContext() throws OXException, SQLException {
        this.storage.rememberSubscription(this.subscription);
        this.storage.deleteAllSubscriptionsInContext(this.ctx.getContextId(), this.ctx);
        SELECT select = new SELECT(Constant.ASTERISK).FROM(Tables.subscriptions).WHERE((Predicate)new EQUALS("cid", (Object)Autoboxing.I((int)this.ctx.getContextId())));
        this.assertNoResult(new StatementBuilder().buildCommand((Command)select));
    }

    public void testGetAllSubscriptionsOfAUser() throws OXException {
        this.storage.rememberSubscription(this.subscription);
        List subscriptionsOfUser = this.storage.getSubscriptionsOfUser(this.ctx, this.userId);
        SubscriptionSQLStorageTest.assertEquals((String)"should find one subscription", (int)1, (int)subscriptionsOfUser.size());
        this.storage.rememberSubscription(this.subscription2);
        subscriptionsOfUser = this.storage.getSubscriptionsOfUser(this.ctx, this.userId);
        SubscriptionSQLStorageTest.assertEquals((String)"should find two subscriptions", (int)2, (int)subscriptionsOfUser.size());
    }
}

