/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.sql;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.datatypes.genericonf.storage.SimConfigurationStorageService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.SimContext;
import com.openexchange.java.Autoboxing;
import com.openexchange.sql.builder.StatementBuilder;
import com.openexchange.sql.grammar.Command;
import com.openexchange.sql.grammar.Constant;
import com.openexchange.sql.grammar.DELETE;
import com.openexchange.sql.grammar.EQUALS;
import com.openexchange.sql.grammar.Expression;
import com.openexchange.sql.grammar.IN;
import com.openexchange.sql.grammar.Predicate;
import com.openexchange.sql.schema.Tables;
import com.openexchange.sql.tools.SQLTools;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionStorage;
import com.openexchange.subscribe.sql.SubscriptionSQLStorage;
import com.openexchange.tools.sql.SQLTestCase;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AbstractSubscriptionSQLStorageTest
extends SQLTestCase {
    protected SubscriptionStorage storage = null;
    protected Subscription subscription = null;
    protected Subscription subscription2 = null;
    protected List<Integer> subscriptionsToDelete = new ArrayList<Integer>();
    protected Context ctx = new SimContext(1);
    protected String folderId = "eins";
    protected int userId = 44;
    protected long lastUpdate;

    public void setUp() throws Exception {
        this.loadProperties();
        super.setUp();
        FormElement formElementLogin = new FormElement();
        formElementLogin.setName("login");
        formElementLogin.setDisplayName("Login");
        formElementLogin.setMandatory(true);
        formElementLogin.setWidget(FormElement.Widget.INPUT);
        formElementLogin.setDefaultValue((Object)"default login");
        FormElement formElementPassword = new FormElement();
        formElementPassword.setName("password");
        formElementPassword.setDisplayName("Password");
        formElementPassword.setMandatory(true);
        formElementPassword.setWidget(FormElement.Widget.PASSWORD);
        DynamicFormDescription formDescription = new DynamicFormDescription();
        formDescription.addFormElement(formElementLogin);
        formDescription.addFormElement(formElementPassword);
        SubscriptionSource subscriptionSource = new SubscriptionSource();
        subscriptionSource.setId("com.openexchange.subscribe.test.basic");
        subscriptionSource.setDisplayName("Basic Subscription for Tests");
        subscriptionSource.setIcon("http://path/to/icon");
        subscriptionSource.setFormDescription(formDescription);
        subscriptionSource.setFolderModule(3);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("login", "user_a");
        configuration.put("password", "password_a");
        this.subscription = new Subscription();
        this.subscription.setContext(this.ctx);
        this.subscription.setFolderId(this.folderId);
        this.lastUpdate = new Date().getTime();
        this.subscription.setLastUpdate(this.lastUpdate);
        this.subscription.setUserId(this.userId);
        this.subscription.setSource(subscriptionSource);
        this.subscription.setConfiguration(configuration);
        this.subscription.setEnabled(true);
        FormElement formElementLogin2 = new FormElement();
        formElementLogin2.setName("login2");
        formElementLogin2.setDisplayName("Login2");
        formElementLogin2.setMandatory(true);
        formElementLogin2.setWidget(FormElement.Widget.INPUT);
        formElementLogin2.setDefaultValue((Object)"default login2");
        FormElement formElementPassword2 = new FormElement();
        formElementPassword2.setName("password2");
        formElementPassword2.setDisplayName("Password2");
        formElementPassword2.setMandatory(true);
        formElementPassword2.setWidget(FormElement.Widget.PASSWORD);
        DynamicFormDescription formDescription2 = new DynamicFormDescription();
        formDescription2.addFormElement(formElementLogin2);
        formDescription2.addFormElement(formElementPassword2);
        SubscriptionSource subscriptionSource2 = new SubscriptionSource();
        subscriptionSource2.setId("com.openexchange.subscribe.test.basic2");
        subscriptionSource2.setDisplayName("Basic Subscription for Tests2");
        subscriptionSource2.setIcon("http://path/to/icon2");
        subscriptionSource2.setFormDescription(formDescription2);
        subscriptionSource2.setFolderModule(3);
        HashMap<String, String> configuration2 = new HashMap<String, String>();
        configuration2.put("login", "user_a2");
        configuration2.put("password", "password_a2");
        this.subscription2 = new Subscription();
        this.subscription2.setContext(this.ctx);
        this.subscription2.setFolderId(this.folderId);
        this.lastUpdate = new Date().getTime();
        this.subscription2.setLastUpdate(this.lastUpdate);
        this.subscription2.setUserId(this.userId);
        this.subscription2.setSource(subscriptionSource2);
        this.subscription2.setConfiguration(configuration2);
        this.subscription2.setEnabled(false);
        SimSubscriptionSourceDiscoveryService discoveryService = new SimSubscriptionSourceDiscoveryService();
        discoveryService.addSource(subscriptionSource);
        discoveryService.addSource(subscriptionSource2);
        this.storage = new SubscriptionSQLStorage(this.getDBProvider(), (GenericConfigurationStorageService)new SimConfigurationStorageService(), (SubscriptionSourceDiscoveryService)discoveryService);
    }

    public void tearDown() throws Exception {
        if (this.subscriptionsToDelete.size() > 0) {
            for (int delId : this.subscriptionsToDelete) {
                Subscription subscriptionToDelete = new Subscription();
                subscriptionToDelete.setId(delId);
                subscriptionToDelete.setContext(this.ctx);
                this.storage.forgetSubscription(subscriptionToDelete);
            }
            DELETE delete = new DELETE().FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new IN("id", SQLTools.createLIST((int)this.subscriptionsToDelete.size(), (Expression)Constant.PLACEHOLDER))));
            Connection writeConnection = this.getDBProvider().getWriteConnection(this.ctx);
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)this.ctx.getContextId()));
            values.addAll(this.subscriptionsToDelete);
            new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
            this.getDBProvider().releaseWriteConnection(this.ctx, writeConnection);
        }
        this.storage = null;
        super.tearDown();
    }

    protected void clearFolder(String folderId) throws Exception {
        Connection writeConnection = this.getDBProvider().getWriteConnection(this.ctx);
        DELETE delete = new DELETE().FROM(Tables.subscriptions).WHERE((Predicate)new EQUALS("folder_id", (Expression)Constant.PLACEHOLDER));
        ArrayList<String> values = new ArrayList<String>();
        values.add(folderId);
        new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
        this.getDBProvider().releaseWriteConnection(this.ctx, writeConnection);
    }

    protected void assertEquals(Subscription expected, Subscription actual) {
        if (expected != null) {
            AbstractSubscriptionSQLStorageTest.assertNotNull((Object)actual);
        }
        if (expected == null) {
            AbstractSubscriptionSQLStorageTest.assertTrue((String)"Expected null", (actual == null ? 1 : 0) != 0);
            return;
        }
        AbstractSubscriptionSQLStorageTest.assertEquals((int)expected.getContext().getContextId(), (int)actual.getContext().getContextId());
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getFolderId(), (String)actual.getFolderId());
        AbstractSubscriptionSQLStorageTest.assertEquals((int)expected.getId(), (int)actual.getId());
        AbstractSubscriptionSQLStorageTest.assertEquals((long)expected.getLastUpdate(), (long)actual.getLastUpdate());
        AbstractSubscriptionSQLStorageTest.assertEquals((int)expected.getUserId(), (int)actual.getUserId());
        this.assertEquals(expected.getSource(), actual.getSource());
        this.assertEquals(expected.getDescription(), actual.getDescription());
        AbstractSubscriptionSQLStorageTest.assertEquals((boolean)expected.isEnabled(), (boolean)actual.isEnabled());
    }

    protected void assertEquals(SubscriptionSource expected, SubscriptionSource actual) {
        if (expected != null) {
            AbstractSubscriptionSQLStorageTest.assertNotNull((Object)actual);
        }
        if (expected == null) {
            AbstractSubscriptionSQLStorageTest.assertTrue((String)"Expected null", (actual == null ? 1 : 0) != 0);
            return;
        }
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getDisplayName(), (String)actual.getDisplayName());
        AbstractSubscriptionSQLStorageTest.assertEquals((int)expected.getFolderModule(), (int)actual.getFolderModule());
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getIcon(), (String)actual.getIcon());
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getId(), (String)actual.getId());
        this.assertEquals(expected.getFormDescription(), actual.getFormDescription());
    }

    protected void assertEquals(DynamicFormDescription expected, DynamicFormDescription actual) {
        AbstractSubscriptionSQLStorageTest.assertEquals((String)"Form Element size does notg match", (int)expected.getFormElements().size(), (int)actual.getFormElements().size());
        for (FormElement formElementExpected : expected.getFormElements()) {
            boolean found = false;
            for (FormElement formElementActual : actual.getFormElements()) {
                if (!formElementExpected.getName().equals(formElementActual.getName())) continue;
                found = true;
                this.assertEquals(formElementExpected, formElementActual);
            }
            if (found) continue;
            AbstractSubscriptionSQLStorageTest.fail((String)"Missing FormElement");
        }
    }

    protected void assertEquals(FormElement expected, FormElement actual) {
        if (expected != null) {
            AbstractSubscriptionSQLStorageTest.assertNotNull((Object)actual);
        }
        if (expected == null) {
            AbstractSubscriptionSQLStorageTest.assertTrue((String)"Expected null", (actual == null ? 1 : 0) != 0);
            return;
        }
        AbstractSubscriptionSQLStorageTest.assertEquals((Object)expected.getDefaultValue(), (Object)actual.getDefaultValue());
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getDisplayName(), (String)actual.getDisplayName());
        AbstractSubscriptionSQLStorageTest.assertEquals((String)expected.getName(), (String)actual.getName());
        AbstractSubscriptionSQLStorageTest.assertEquals((Object)expected.getWidget(), (Object)actual.getWidget());
    }
}

