/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.smtp.config.SMTPProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmtpReloadable
implements Reloadable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpReloadable.class);
    private static final SmtpReloadable INSTANCE = new SmtpReloadable();
    private static final String CONFIGFILE = "smtp.properties";
    private static final String[] PROPERTIES = new String[]{"all properties in file"};
    private final List<Reloadable> reloadables = new CopyOnWriteArrayList<Reloadable>();

    public static SmtpReloadable getInstance() {
        return INSTANCE;
    }

    private SmtpReloadable() {
    }

    public void addReloadable(Reloadable reloadable) {
        this.reloadables.add(reloadable);
    }

    public void reloadConfiguration(ConfigurationService configService) {
        try {
            SMTPProperties smtpProperties = SMTPProperties.getInstance();
            if (null != smtpProperties) {
                smtpProperties.resetProperties();
                smtpProperties.loadProperties();
            }
        }
        catch (OXException e) {
            LOGGER.warn("Failed to reload SMTP properties", (Throwable)e);
        }
        for (Reloadable reloadable : this.reloadables) {
            reloadable.reloadConfiguration(configService);
        }
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put(CONFIGFILE, PROPERTIES);
        return map;
    }
}

