/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.config.ConfigurationService;
import com.openexchange.java.Strings;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.services.Services;
import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SMTPCapabilityCache {
    static final Logger LOG = LoggerFactory.getLogger(SMTPCapabilityCache.class);
    private static volatile Integer capabiltiesCacheIdleTime;
    private static volatile ConcurrentMap<InetSocketAddress, Future<Capabilities>> MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int capabiltiesCacheIdleTime() {
        Integer tmp = capabiltiesCacheIdleTime;
        if (null != tmp) return tmp;
        Class<SMTPCapabilityCache> clazz = SMTPCapabilityCache.class;
        synchronized (SMTPCapabilityCache.class) {
            tmp = capabiltiesCacheIdleTime;
            if (null != tmp) return tmp;
            int defaultValue = 0;
            ConfigurationService service = Services.getService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultValue;
            }
            capabiltiesCacheIdleTime = tmp = Integer.valueOf(service.getIntProperty("com.openexchange.smtp.capabiltiesCacheIdleTime", defaultValue));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private SMTPCapabilityCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (MAP != null) return;
        Class<SMTPCapabilityCache> clazz = SMTPCapabilityCache.class;
        synchronized (SMTPCapabilityCache.class) {
            if (MAP != null) return;
            MAP = new ConcurrentHashMap<InetSocketAddress, Future<Capabilities>>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tearDown() {
        if (MAP == null) return;
        Class<SMTPCapabilityCache> clazz = SMTPCapabilityCache.class;
        synchronized (SMTPCapabilityCache.class) {
            if (MAP == null) return;
            SMTPCapabilityCache.clear();
            MAP = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clear() {
        ConcurrentMap<InetSocketAddress, Future<Capabilities>> map = MAP;
        if (null != map) {
            map.clear();
        }
    }

    public static Map<String, String> getCapabilities(InetSocketAddress address, boolean isSecure, ISMTPProperties smtpProperties, String domain) throws IOException {
        return SMTPCapabilityCache.getCapabilities0(address, isSecure, smtpProperties, domain).getCapabilities();
    }

    private static Capabilities getCapabilities0(InetSocketAddress address, boolean isSecure, ISMTPProperties smtpProperties, String domain) throws IOException {
        Capabilities caps;
        FutureTask<Capabilities> ft;
        int idleTime = SMTPCapabilityCache.capabiltiesCacheIdleTime();
        if (idleTime < 0) {
            FutureTask<Capabilities> ft2 = new FutureTask<Capabilities>(new CapabilityAndGreetingCallable(address, isSecure, smtpProperties, domain));
            ft2.run();
            return SMTPCapabilityCache.getFrom(ft2);
        }
        ConcurrentMap<InetSocketAddress, Future<Capabilities>> map = MAP;
        Future<Capabilities> f = (FutureTask<Capabilities>)map.get(address);
        if (null == f && null == (f = (Future)map.putIfAbsent(address, ft = new FutureTask<Capabilities>(new CapabilityAndGreetingCallable(address, isSecure, smtpProperties, domain))))) {
            f = ft;
            ft.run();
        }
        if (SMTPCapabilityCache.isElapsed(caps = SMTPCapabilityCache.getFrom(f), idleTime)) {
            FutureTask<Capabilities> ft3 = new FutureTask<Capabilities>(new CapabilityAndGreetingCallable(address, isSecure, smtpProperties, domain));
            if (map.replace(address, f, ft3)) {
                f = ft3;
                ft3.run();
            } else {
                f = (Future)map.get(address);
            }
            caps = SMTPCapabilityCache.getFrom(f);
        }
        return caps;
    }

    private static boolean isElapsed(Capabilities caps, int idleTime) {
        if (idleTime == 0) {
            return false;
        }
        return System.currentTimeMillis() - caps.getStamp() > (long)idleTime;
    }

    private static Capabilities getFrom(Future<Capabilities> f) throws IOException, Error {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException(e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw new IOException(e.getMessage());
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Not unchecked", cause);
        }
    }

    private static final class Capabilities {
        private final Map<String, String> capabilities;
        private final long stamp;

        public Capabilities(String sCapabilities) {
            String[] strings;
            HashMap<String, String> capabilities = new HashMap<String, String>(8);
            for (String cap : strings = Strings.splitByCRLF((String)sCapabilities)) {
                if (!cap.startsWith("250")) continue;
                cap = cap.substring(4);
                capabilities.put(cap.toUpperCase(Locale.US), cap);
            }
            this.capabilities = Collections.unmodifiableMap(capabilities);
            this.stamp = System.currentTimeMillis();
        }

        long getStamp() {
            return this.stamp;
        }

        Map<String, String> getCapabilities() {
            return this.capabilities;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Capabilities other = (Capabilities)obj;
            return !(this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities));
        }
    }

    private static final class CapabilityAndGreetingCallable
    implements Callable<Capabilities> {
        private final InetSocketAddress key;
        private final boolean isSecure;
        private final ISMTPProperties smtpProperties;
        private final String domain;

        public CapabilityAndGreetingCallable(InetSocketAddress key, boolean isSecure, ISMTPProperties smtpProperties, String domain) {
            this.domain = domain;
            this.key = key;
            this.isSecure = isSecure;
            this.smtpProperties = smtpProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Capabilities call() throws IOException {
            Socket s = null;
            try {
                s = this.isSecure ? TrustAllSSLSocketFactory.getDefault().createSocket() : new Socket();
                int connectionTimeout = this.smtpProperties.getSmtpConnectionTimeout();
                if (connectionTimeout > 0) {
                    s.connect(this.key, connectionTimeout);
                } else {
                    s.connect(this.key);
                }
                int timeout = this.smtpProperties.getSmtpTimeout();
                if (timeout > 0) {
                    s.setSoTimeout(timeout);
                }
                InputStream in = s.getInputStream();
                OutputStream out = s.getOutputStream();
                StringBuilder sb = new StringBuilder(512);
                boolean skipLF = false;
                boolean eol = false;
                int i = -1;
                while (!eol && (i = in.read()) != -1) {
                    char c = (char)i;
                    if (c == '\r') {
                        eol = true;
                        skipLF = true;
                        continue;
                    }
                    if (c == '\n') {
                        eol = true;
                        skipLF = false;
                        continue;
                    }
                    sb.append(c);
                }
                if (sb.length() > 0) {
                    sb.setLength(0);
                }
                if (skipLF) {
                    i = in.read();
                    skipLF = false;
                }
                String command = "EHLO " + this.domain;
                while (sb.length() == 0) {
                    int available;
                    out.write((command + "\r\n").getBytes());
                    out.flush();
                    sb.append((char)in.read());
                    while ((available = in.available()) > 0) {
                        byte[] chunk = new byte[available];
                        int read = in.read(chunk, 0, available);
                        char[] chars = new char[read];
                        for (int j = 0; j < chars.length; ++j) {
                            chars[j] = (char)(chunk[j] & 0xFF);
                        }
                        sb.append(chars, 0, read);
                    }
                    if (0 != sb.length()) continue;
                    LOG.warn("Empty EHLO response for: {}", (Object)command);
                }
                String capabilities = sb.toString();
                out.write("QUIT\r\n".getBytes());
                out.flush();
                i = in.read();
                while (i != -1) {
                    i = in.read();
                }
                Capabilities capabilities2 = new Capabilities(capabilities);
                return capabilities2;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {
                        LOG.error("", (Throwable)e);
                    }
                }
            }
        }
    }
}

