/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.TextProcessing;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.session.Session;
import com.openexchange.smtp.AbstractSMTPTransport;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.config.MailAccountSMTPProperties;
import com.openexchange.smtp.config.SMTPConfig;
import com.openexchange.smtp.filler.SMTPMessageFiller;
import com.openexchange.smtp.services.Services;
import com.openexchange.user.UserService;
import com.sun.mail.smtp.SMTPMessage;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSMTPTransport
extends AbstractSMTPTransport {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSMTPTransport.class);
    private static final String ACK_TEXT = "Reporting-UA: OPEN-XCHANGE - WebMail\r\nFinal-Recipient: rfc822; #FROM#\r\nOriginal-Message-ID: #MSG ID#\r\nDisposition: manual-action/MDN-sent-manually; displayed\r\n";
    private static final String CT_TEXT_PLAIN = "text/plain; charset=#CS#";
    private static final String CT_READ_ACK = "message/disposition-notification; name=MDNPart1.txt; charset=UTF-8";
    private static final String CD_READ_ACK = "attachment; filename=MDNPart1.txt";
    private static final String MULTI_SUBTYPE_REPORT = "report; report-type=disposition-notification";
    private static final String KERBEROS_SESSION_SUBJECT = "kerberosSubject";
    private final UserSettingMail usm;

    protected DefaultSMTPTransport() {
        this.usm = null;
    }

    public DefaultSMTPTransport(Session session) throws OXException {
        this(session, 0);
    }

    public DefaultSMTPTransport(Session session, int accountId) throws OXException {
        super(session, accountId);
        this.usm = UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), this.ctx);
        this.setUser(Services.getService(UserService.class).getUser(session.getUserId(), this.ctx));
        this.setKerberosSubject((Subject)session.getParameter(KERBEROS_SESSION_SUBJECT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setReplyHeaders(MimeMessage mimeMessage, MailPath msgref) throws OXException, MessagingException {
        MailAccess access = null;
        try {
            access = MailAccess.getInstance((Session)this.session, (int)msgref.getAccountId());
            access.connect();
            MimeMessageFiller.setReplyHeaders((MailMessage)access.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false), (MimeMessage)mimeMessage);
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    @Override
    protected SMTPMessageFiller createSMTPMessageFiller(UserSettingMail optMailSettings) throws OXException {
        return new SMTPMessageFiller(this.getTransportConfig().getSMTPProperties(), this.session, this.ctx, null == optMailSettings ? this.usm : optMailSettings);
    }

    @Override
    protected SMTPConfig createSMTPConfig() throws OXException {
        SMTPConfig tmp = (SMTPConfig)TransportConfig.getTransportConfig((TransportConfig)new SMTPConfig(), (Session)this.session, (int)this.accountId);
        tmp.setTransportProperties(this.createNewMailProperties());
        tmp.setSession(this.session);
        return tmp;
    }

    @Override
    protected OXException handleMessagingException(MessagingException e, MailConfig config) throws OXException {
        return MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)config, (Session)this.session);
    }

    @Override
    protected void logMessageTransport(MimeMessage smtpMessage, SMTPConfig smtpConfig) throws OXException, MessagingException {
        if (this.getTransportConfig().getSMTPProperties().isLogTransport()) {
            LogProperties.putSessionProperties((Session)this.session);
            LOG.info("Sent \"{}\" for login \"{}\" using SMTP server \"{}\" on port {}.", new Object[]{smtpMessage.getMessageID(), smtpConfig.getLogin(), smtpConfig.getServer(), smtpConfig.getPort()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReceiptAck(MailMessage srcMail, String fromAddr) throws OXException {
        if (null == srcMail) {
            return;
        }
        SMTPConfig smtpConfig = null;
        try {
            MailDateFormat mdf;
            String from;
            InternetAddress dispNotification = srcMail.getDispositionNotification();
            if (dispNotification == null) {
                InternetAddress[] from2 = srcMail.getFrom();
                if (from2 != null && from2.length > 0) {
                    dispNotification = from2[0];
                }
                if (null == dispNotification) {
                    throw SMTPExceptionCode.MISSING_NOTIFICATION_HEADER.create(MessageHeaders.HDR_DISP_TO, Long.valueOf(srcMail.getMailId()));
                }
            }
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
            String userMail = UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getMail();
            if (fromAddr == null) {
                if (this.usm.getSendAddr() == null && userMail == null) {
                    throw SMTPExceptionCode.NO_SEND_ADDRESS_FOUND.create();
                }
                from = this.usm.getSendAddr() == null ? userMail : this.usm.getSendAddr();
            } else {
                from = fromAddr;
            }
            smtpMessage.addFrom((Address[])MimeMessageUtility.parseAddressList((String)from, (boolean)false));
            Address[] recipients = new Address[]{dispNotification};
            this.processAddressHeader((MimeMessage)smtpMessage);
            this.checkRecipients(recipients);
            smtpMessage.addRecipients(Message.RecipientType.TO, recipients);
            smtpMessage.setHeader(MessageHeaders.HDR_X_PRIORITY, "3 (normal)");
            smtpMessage.setHeader(MessageHeaders.HDR_IMPORTANCE, "Medium");
            Locale locale = UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getLocale();
            StringHelper strHelper = StringHelper.valueOf((Locale)locale);
            smtpMessage.setSubject(strHelper.getString("Read acknowledgement"));
            MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat((Session)this.session);
            synchronized (mailDateFormat) {
                smtpMessage.setHeader("Date", mdf.format(new Date()));
            }
            smtpConfig = this.getTransportConfig();
            new SMTPMessageFiller(smtpConfig.getSMTPProperties(), this.session, this.ctx, this.usm).setAccountId(this.accountId).setCommonHeaders((MimeMessage)smtpMessage);
            String defaultMimeCS = MailProperties.getInstance().getDefaultMimeCharset();
            ContentType ct = new ContentType(CT_TEXT_PLAIN.replaceFirst("#CS#", defaultMimeCS));
            MimeMultipart mixedMultipart = new MimeMultipart(MULTI_SUBTYPE_REPORT);
            Date sentDate = srcMail.getSentDate();
            MimeBodyPart text = new MimeBodyPart();
            String txt = TextProcessing.performLineFolding((String)strHelper.getString("This is a delivery receipt for the mail that you sent on #DATE# to #RECIPIENT# with subject \"#SUBJECT#\".\n\nNote: This delivery receipt only acknowledges that the message was displayed on the recipients computer. There is no guarantee that the recipient has read or understood the message contents.").replaceFirst("#DATE#", sentDate == null ? "" : DefaultSMTPTransport.quoteReplacement(DateFormat.getDateInstance(1, locale).format(sentDate))).replaceFirst("#RECIPIENT#", DefaultSMTPTransport.quoteReplacement(from)).replaceFirst("#SUBJECT#", DefaultSMTPTransport.quoteReplacement(srcMail.getSubject())), (int)this.usm.getAutoLinebreak());
            MessageUtility.setText((String)txt, (String)defaultMimeCS, (Part)text);
            text.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
            text.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType((String)ct.toString()));
            mixedMultipart.addBodyPart((BodyPart)text);
            ct.setContentType(CT_READ_ACK);
            MimeBodyPart ack = new MimeBodyPart();
            String msgId = srcMail.getFirstHeader(MessageHeaders.HDR_MESSAGE_ID);
            String txt2 = strHelper.getString(ACK_TEXT).replaceFirst("#FROM#", DefaultSMTPTransport.quoteReplacement(from)).replaceFirst("#MSG ID#", DefaultSMTPTransport.quoteReplacement(msgId));
            MessageUtility.setText((String)txt2, (String)defaultMimeCS, (Part)ack);
            ack.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
            ack.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType((String)ct.toString()));
            ack.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, CD_READ_ACK);
            mixedMultipart.addBodyPart((BodyPart)ack);
            MessageUtility.setContent((Multipart)mixedMultipart, (Part)smtpMessage);
            long start = System.currentTimeMillis();
            try (Transport transport = this.getSMTPSession().getTransport(SMTP);){
                this.connectTransport(transport, smtpConfig);
                this.saveChangesSafe((MimeMessage)smtpMessage, true);
                this.transport((MimeMessage)smtpMessage, smtpMessage.getAllRecipients(), transport, smtpConfig);
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
            }
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, smtpConfig, (Session)this.session);
        }
    }

    protected ITransportProperties createNewMailProperties() throws OXException {
        MailAccountStorageService storageService = Services.getService(MailAccountStorageService.class);
        return new MailAccountSMTPProperties(storageService.getMailAccount(this.accountId, this.session.getUserId(), this.session.getContextId()));
    }

    private static String quoteReplacement(String str) {
        return Strings.isEmpty((String)str) ? "" : DefaultSMTPTransport.quoteReplacement0(str);
    }

    private static String quoteReplacement0(String s) {
        if (s.indexOf(92) < 0 && s.indexOf(36) < 0) {
            return s;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

