/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Filter;
import com.openexchange.config.cascade.ComposedConfigProperty;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.java.util.MsisdnCheck;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAware;
import com.openexchange.mail.mime.MimeHeaderNameChecker;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.MimeMessageDataSource;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.transport.MimeSupport;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.transport.listener.Reply;
import com.openexchange.mail.transport.listener.Result;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.session.Session;
import com.openexchange.smtp.ListenerChain;
import com.openexchange.smtp.SMTPCapabilityCache;
import com.openexchange.smtp.SMTPExceptionCode;
import com.openexchange.smtp.SMTPProvider;
import com.openexchange.smtp.config.ISMTPProperties;
import com.openexchange.smtp.config.SMTPConfig;
import com.openexchange.smtp.config.SMTPSessionProperties;
import com.openexchange.smtp.filler.SMTPMessageFiller;
import com.openexchange.smtp.services.Services;
import com.openexchange.tools.ssl.TrustAllSSLSocketFactory;
import com.sun.mail.smtp.JavaSMTPTransport;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPTransport;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Provider;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.idn.IDNA;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSMTPTransport
extends MailTransport
implements MimeSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSMTPTransport.class);
    protected static final String SMTP = SMTPProvider.PROTOCOL_SMTP.getName();
    private static volatile String staticHostName;
    private static volatile UnknownHostException warnSpam;
    protected final int accountId;
    protected final Context ctx;
    protected final Session session;
    private final Queue<Runnable> pendingInvocations;
    private volatile javax.mail.Session smtpSession;
    private volatile SMTPConfig cachedSmtpConfig;
    private User user;
    private transient Subject kerberosSubject;

    protected AbstractSMTPTransport() {
        this.accountId = 0;
        this.ctx = null;
        this.session = null;
        this.pendingInvocations = new ConcurrentLinkedQueue<Runnable>();
    }

    protected AbstractSMTPTransport(int contextId) throws OXException {
        this.session = null;
        this.ctx = Services.getService(ContextService.class).getContext(contextId);
        this.accountId = 0;
        this.pendingInvocations = new ConcurrentLinkedQueue<Runnable>();
    }

    protected AbstractSMTPTransport(Session session, int accountId) throws OXException {
        this.session = session;
        this.ctx = Services.getService(ContextService.class).getContext(session.getContextId());
        this.accountId = accountId;
        this.pendingInvocations = new ConcurrentLinkedQueue<Runnable>();
    }

    protected abstract void setReplyHeaders(MimeMessage var1, MailPath var2) throws OXException, MessagingException;

    protected abstract SMTPMessageFiller createSMTPMessageFiller(UserSettingMail var1) throws OXException;

    protected abstract SMTPConfig createSMTPConfig() throws OXException;

    protected OXException handleMessagingException(MessagingException e, MailConfig config) throws OXException {
        return MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)config, null);
    }

    protected void logMessageTransport(MimeMessage smtpMessage, SMTPConfig smtpConfig) throws OXException, MessagingException {
        if (this.getTransportConfig().getSMTPProperties().isLogTransport()) {
            LOG.info("Sent \"{}\" for login \"{}\" using SMTP server \"{}\" on port {}.", new Object[]{smtpMessage.getMessageID(), smtpConfig.getLogin(), smtpConfig.getServer(), smtpConfig.getPort()});
        }
    }

    protected javax.mail.Session getSMTPSession() throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig();
        return this.getSMTPSession(smtpConfig, this.accountId > 0 && (smtpConfig.isRequireTls() || smtpConfig.getTransportProperties().isEnforceSecureConnection()));
    }

    protected void processAddressHeader(MimeMessage mimeMessage) throws OXException, MessagingException {
        InternetAddress[] addresses;
        String str = mimeMessage.getHeader("From", null);
        if (!Strings.isEmpty((String)str)) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setFrom((Address)addresses[0]);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("Sender", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setSender((Address)addresses[0]);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("To", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("Cc", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])addresses);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("Bcc", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])addresses);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("Reply-To", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setReplyTo((Address[])addresses);
        }
        if (!Strings.isEmpty((String)(str = mimeMessage.getHeader("Disposition-Notification-To", null)))) {
            addresses = QuotedInternetAddress.parse((String)str, (boolean)false);
            this.checkRecipients((Address[])addresses);
            mimeMessage.setHeader("Disposition-Notification-To", addresses[0].toString());
        }
    }

    protected boolean checkRecipients(Address[] recipients) throws OXException {
        Filter filter;
        if (recipients == null || recipients.length == 0) {
            throw SMTPExceptionCode.MISSING_RECIPIENTS.create();
        }
        Boolean poisoned = null;
        ConfigurationService service = Services.getService(ConfigurationService.class);
        if (null != service && null != (filter = service.getFilterFromProperty("com.openexchange.mail.transport.redirectWhitelist"))) {
            for (Address address : recipients) {
                if (MimeMessageUtility.POISON_ADDRESS == address) {
                    poisoned = Boolean.TRUE;
                    continue;
                }
                InternetAddress internetAddress = (InternetAddress)address;
                if (filter.accepts(internetAddress.getAddress())) continue;
                throw SMTPExceptionCode.RECIPIENT_NOT_ALLOWED.create(internetAddress.toUnicodeString());
            }
        }
        if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
            for (Address address : recipients) {
                if (MimeMessageUtility.POISON_ADDRESS == address) {
                    poisoned = Boolean.TRUE;
                    continue;
                }
                InternetAddress internetAddress = (InternetAddress)address;
                String sAddress = internetAddress.getAddress();
                if (!MsisdnCheck.checkMsisdn((String)sAddress)) continue;
                if (sAddress.indexOf(47) < 0) {
                    internetAddress.setAddress(sAddress + "/TYPE=PLMN");
                }
                try {
                    internetAddress.setPersonal("", "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return null == poisoned ? AbstractSMTPTransport.isPoisoned(recipients) : poisoned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected javax.mail.Session getSMTPSession(SMTPConfig smtpConfig, boolean forceSecure) throws OXException {
        if (null == this.smtpSession) {
            AbstractSMTPTransport abstractSMTPTransport = this;
            synchronized (abstractSMTPTransport) {
                if (null == this.smtpSession) {
                    Properties smtpProps = SMTPSessionProperties.getDefaultSessionProperties();
                    smtpProps.put("mail.smtp.class", JavaSMTPTransport.class.getName());
                    smtpProps.put("com.openexchange.mail.maxMailSize", Long.toString(this.getMaxMailSize()));
                    ISMTPProperties smtpProperties = smtpConfig.getSMTPProperties();
                    boolean kerberosAuth = this.isKerberosAuth();
                    if (this.isKerberosAuth()) {
                        smtpProps.put("mail.smtp.auth", "true");
                        smtpProps.put("mail.smtp.sasl.enable", "true");
                        smtpProps.put("mail.smtp.sasl.authorizationid", smtpConfig.getLogin());
                        smtpProps.put("mail.smtp.sasl.mechanisms", kerberosAuth ? "GSSAPI" : "PLAIN");
                    } else {
                        smtpProps.put("mail.smtp.auth", smtpProperties.isSmtpAuth() ? "true" : "false");
                    }
                    String smtpLocalhost = smtpProperties.getSmtpLocalhost();
                    if (smtpLocalhost != null) {
                        smtpProps.put("mail.smtp.localhost", smtpLocalhost);
                    }
                    if (smtpProperties.getSmtpTimeout() > 0) {
                        smtpProps.put("mail.smtp.timeout", Integer.toString(smtpProperties.getSmtpTimeout()));
                    }
                    if (smtpProperties.getSmtpConnectionTimeout() > 0) {
                        smtpProps.put("mail.smtp.connectiontimeout", Integer.toString(smtpProperties.getSmtpConnectionTimeout()));
                    }
                    if (smtpProperties.isSendPartial()) {
                        smtpProps.put("mail.smtp.sendpartial", "true");
                    }
                    String sPort = String.valueOf(smtpConfig.getPort());
                    String socketFactoryClass = TrustAllSSLSocketFactory.class.getName();
                    if (smtpConfig.isSecure()) {
                        smtpProps.put("mail.smtp.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                        smtpProps.put("mail.smtp.ssl.protocols", smtpConfig.getSMTPProperties().getSSLProtocols());
                        String cipherSuites = smtpConfig.getSMTPProperties().getSSLCipherSuites();
                        if (!Strings.isEmpty((String)cipherSuites)) {
                            smtpProps.put("mail.smtp.ssl.ciphersuites", cipherSuites);
                        }
                    } else {
                        String hostName = this.getHostName();
                        try {
                            InetSocketAddress address = new InetSocketAddress(IDNA.toASCII((String)smtpConfig.getServer()), smtpConfig.getPort());
                            Map<String, String> capabilities = SMTPCapabilityCache.getCapabilities(address, smtpConfig.isSecure(), smtpProperties, hostName);
                            if (capabilities.containsKey("STARTTLS")) {
                                smtpProps.put("mail.smtp.starttls.enable", "true");
                            } else if (forceSecure) {
                                throw MailExceptionCode.NON_SECURE_DENIED.create(new Object[]{smtpConfig.getServer()});
                            }
                        }
                        catch (IOException e) {
                            smtpProps.put("mail.smtp.starttls.enable", "true");
                        }
                        smtpProps.put("mail.smtp.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.ssl.socketFactory.class", socketFactoryClass);
                        smtpProps.put("mail.smtp.ssl.socketFactory.port", sPort);
                        smtpProps.put("mail.smtp.socketFactory.fallback", "false");
                        smtpProps.put("mail.smtp.ssl.protocols", smtpConfig.getSMTPProperties().getSSLProtocols());
                        String cipherSuites = smtpConfig.getSMTPProperties().getSSLCipherSuites();
                        if (!Strings.isEmpty((String)cipherSuites)) {
                            smtpProps.put("mail.smtp.ssl.ciphersuites", cipherSuites);
                        }
                    }
                    this.smtpSession = javax.mail.Session.getInstance((Properties)smtpProps, null);
                    this.smtpSession.addProvider(new Provider(Provider.Type.TRANSPORT, "smtp", JavaSMTPTransport.class.getName(), "Open-Xchange, Inc.", "7.2.2"));
                }
            }
        }
        return this.smtpSession;
    }

    protected void setUser(User user) {
        this.user = user;
    }

    protected void setKerberosSubject(Subject kerberosSubject) {
        this.kerberosSubject = kerberosSubject;
    }

    protected SMTPTransport getSmtpTransport() throws OXException, MessagingException {
        SMTPTransport transport = (SMTPTransport)this.getSMTPSession().getTransport(SMTP);
        this.connectTransport((Transport)transport, this.getTransportConfig());
        return transport;
    }

    protected void connectTransport(Transport transport, SMTPConfig smtpConfig) throws OXException, MessagingException {
        String server = IDNA.toASCII((String)smtpConfig.getServer());
        int port = smtpConfig.getPort();
        try {
            if (smtpConfig.getSMTPProperties().isSmtpAuth()) {
                String encodedPassword = this.encodePassword(smtpConfig.getPassword());
                if (this.isKerberosAuth()) {
                    try {
                        Subject.doAs(this.kerberosSubject, new SaslSmtpLoginAction(transport, server, port, smtpConfig.getLogin(), encodedPassword));
                    }
                    catch (PrivilegedActionException e) {
                        AbstractSMTPTransport.handlePrivilegedActionException(e);
                    }
                } else {
                    String login = smtpConfig.getLogin();
                    transport.connect(server, port, null == login ? "" : login, null == encodedPassword ? "" : encodedPassword);
                }
            } else {
                transport.connect(server, port, null, null);
            }
        }
        catch (MessagingException e) {
            if (e.getNextException() instanceof SSLHandshakeException) {
                throw SMTPExceptionCode.SECURE_CONNECTION_NOT_POSSIBLE.create(e.getNextException(), server, smtpConfig.getLogin());
            }
            throw e;
        }
    }

    protected void saveChangesSafe(MimeMessage mimeMessage, boolean keepMessageIdIfPresent) throws OXException {
        String hostName = this.getHostName();
        MimeMessageUtility.saveChanges((MimeMessage)mimeMessage, (String)hostName, (boolean)keepMessageIdIfPresent);
        if (TransportProperties.getInstance().isRemoveMimeVersionInSubParts()) {
            try {
                this.checkMimeVersionHeader(mimeMessage);
            }
            catch (Exception e) {
                LOG.warn("Could not check for proper usage of \"MIME-Version\" header according to RFC2045.", (Throwable)e);
            }
        }
    }

    protected MimeMessage transport(MimeMessage smtpMessage, Address[] recipients, Transport transport, SMTPConfig smtpConfig) throws OXException {
        return this.transport(smtpMessage, recipients, transport, smtpConfig, null);
    }

    protected MimeMessage transport(MimeMessage smtpMessage, Address[] recipients, Transport transport, SMTPConfig smtpConfig, MtaStatusInfo mtaInfo) throws OXException {
        this.prepareAddresses(recipients);
        if (null != mtaInfo) {
            transport.addTransportListener((TransportListener)new AddressAddingTransportListener(mtaInfo));
        }
        ListenerChain listenerChain = ListenerChain.getInstance();
        MimeMessage messageToSend = smtpMessage;
        Throwable exception = null;
        try {
            Result result = listenerChain.onBeforeMessageTransport(messageToSend, this.session);
            if (Reply.DENY == result.getReply()) {
                throw MailExceptionCode.SEND_DENIED.create();
            }
            MimeMessage resultingMimeMessage = result.getMimeMessage();
            if (null != resultingMimeMessage) {
                messageToSend = resultingMimeMessage;
            }
            transport.sendMessage((Message)messageToSend, recipients);
            this.logMessageTransport(messageToSend, smtpConfig);
        }
        catch (OXException e) {
            exception = e;
            throw e;
        }
        catch (SMTPSendFailedException sendFailed) {
            Address[] validSentAddresses;
            exception = sendFailed;
            OXException oxe = this.handleMessagingException((MessagingException)((Object)sendFailed), (MailConfig)smtpConfig);
            if (null != mtaInfo) {
                mtaInfo.setReturnCode(sendFailed.getReturnCode());
                oxe.setArgument("mta_info", (Object)mtaInfo);
            }
            if ((validSentAddresses = sendFailed.getValidSentAddresses()) != null && validSentAddresses.length > 0) {
                try {
                    oxe.setArgument("sent_message", (Object)MimeMessageConverter.convertMessage((MimeMessage)messageToSend));
                }
                catch (Exception e) {
                    LOG.debug("Failed to convert message after a message was partially sent", (Throwable)e);
                }
            }
            throw oxe;
        }
        catch (MessagingException e) {
            exception = e;
            if (e.getNextException() instanceof UnsupportedDataTypeException) {
                String message = e.getNextException().getMessage();
                if (message.toLowerCase().indexOf("no object dch") >= 0) {
                    LOG.warn(message.replaceFirst("[dD][cC][hH]", Matcher.quoteReplacement("javax.activation.DataContentHandler")));
                    MimeMessage mimeMessage = this.transportAlt(messageToSend, recipients, transport, smtpConfig);
                    return mimeMessage;
                }
            } else if (e.getNextException() instanceof IOException && e.getNextException().getMessage().equals("Maximum message size is exceeded.")) {
                throw MailExceptionCode.MAX_MESSAGE_SIZE_EXCEEDED.create(new Object[]{MailExceptionCode.getSize((long)this.getMaxMailSize(), (int)2, (boolean)false, (boolean)true)});
            }
            throw this.handleMessagingException(e, (MailConfig)smtpConfig);
        }
        catch (RuntimeException e) {
            exception = e;
            throw MailExceptionCode.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            listenerChain.onAfterMessageTransport(messageToSend, (Exception)exception, this.session);
        }
        return messageToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMTPConfig getTransportConfig() throws OXException {
        SMTPConfig tmp = this.cachedSmtpConfig;
        if (tmp == null) {
            AbstractSMTPTransport abstractSMTPTransport = this;
            synchronized (abstractSMTPTransport) {
                tmp = this.cachedSmtpConfig;
                if (tmp == null) {
                    this.cachedSmtpConfig = tmp = this.createSMTPConfig();
                }
            }
        }
        return tmp;
    }

    public void ping() throws OXException {
        Transport transport;
        try {
            SMTPConfig smtpConfig = this.getTransportConfig();
            transport = this.getSMTPSession(smtpConfig, smtpConfig.isRequireTls() || smtpConfig.getTransportProperties().isEnforceSecureConnection()).getTransport(SMTP);
        }
        catch (NoSuchProviderException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        boolean close = false;
        SMTPConfig config = this.getTransportConfig();
        try {
            this.connectTransport(transport, config);
            close = true;
        }
        catch (AuthenticationFailedException e) {
            throw MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.create((Throwable)e, new Object[]{config.getServer(), e.getMessage()});
        }
        catch (MessagingException e) {
            throw this.handleMessagingException(e, (MailConfig)config);
        }
        finally {
            if (close) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    LOG.error("Closing SMTP transport failed.", (Throwable)e);
                }
            }
        }
    }

    public MailMessage sendMailMessage(ComposedMailMessage composedMail, ComposeType sendType, Address[] allRecipients) throws OXException {
        return this.sendMailMessage(composedMail, sendType, allRecipients, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailMessage sendMailMessage(ComposedMailMessage composedMail, ComposeType sendType, Address[] allRecipients, MtaStatusInfo mtaStatusInfo) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig();
        try {
            MimeMessage mimeMessage = null;
            if (composedMail instanceof ContentAware) {
                try {
                    Object content = composedMail.getContent();
                    if (content instanceof MimeMessage) {
                        mimeMessage = (MimeMessage)content;
                        mimeMessage.removeHeader("x-original-headers");
                        MailPath msgref = composedMail.getMsgref();
                        if (ComposeType.REPLY.equals((Object)sendType) && msgref != null) {
                            this.setReplyHeaders(mimeMessage, msgref);
                        }
                        SMTPMessageFiller smtpFiller = this.createSMTPMessageFiller(null);
                        smtpFiller.setAccountId(this.accountId);
                        smtpFiller.setCommonHeaders(mimeMessage);
                    }
                }
                catch (Exception e) {
                    mimeMessage = null;
                }
            }
            if (mimeMessage == null) {
                SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession());
                SMTPMessageFiller smtpFiller = this.createSMTPMessageFiller(composedMail.getMailSettings());
                smtpFiller.setAccountId(this.accountId);
                composedMail.setFiller((MimeMessageFiller)smtpFiller);
                try {
                    MailPath msgref = composedMail.getMsgref();
                    if (ComposeType.REPLY.equals((Object)sendType) && msgref != null) {
                        this.setReplyHeaders((MimeMessage)smtpMessage, msgref);
                    }
                    smtpFiller.fillMail(composedMail, smtpMessage, sendType);
                    if (allRecipients == null) {
                        allRecipients = composedMail.hasRecipients() ? composedMail.getRecipients() : smtpMessage.getAllRecipients();
                    }
                    smtpFiller.setSendHeaders(composedMail, (MimeMessage)smtpMessage);
                    smtpMessage.removeHeader("x-original-headers");
                    mimeMessage = smtpMessage;
                }
                finally {
                    this.invokeLater(new MailCleanerTask(composedMail));
                }
            }
            MimeMessage sentMimeMessage = this.sendMimeMessage(mimeMessage, (Address[])allRecipients, mtaStatusInfo);
            return MimeMessageConverter.convertMessage((MimeMessage)sentMimeMessage);
        }
        catch (MessagingException e) {
            throw this.handleMessagingException(e, (MailConfig)smtpConfig);
        }
        catch (IOException e) {
            throw SMTPExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public MailMessage sendRawMessage(byte[] asciiBytes, MailTransport.SendRawProperties properties) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig();
        try {
            boolean poisoned;
            InternetAddress[] recipients;
            InputStream rfc822IS = properties.isSanitizeHeaders() ? MimeHeaderNameChecker.sanitizeHeaderNames((byte[])asciiBytes) : new UnsynchronizedByteArrayInputStream(asciiBytes);
            SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession(), rfc822IS);
            InternetAddress sender = properties.getSender();
            if (sender != null) {
                smtpMessage.setEnvelopeFrom(sender.getAddress());
            }
            if ((recipients = properties.getRecipients()) == null) {
                recipients = smtpMessage.getAllRecipients();
            }
            if (properties.isValidateAddressHeaders()) {
                this.processAddressHeader((MimeMessage)smtpMessage);
            }
            if (poisoned = this.checkRecipients((Address[])recipients)) {
                this.saveChangesSafe((MimeMessage)smtpMessage, true);
            } else {
                try {
                    long start = System.currentTimeMillis();
                    try (Transport transport = this.getSMTPSession().getTransport(SMTP);){
                        this.connectTransport(transport, smtpConfig);
                        this.saveChangesSafe((MimeMessage)smtpMessage, true);
                        this.transport((MimeMessage)smtpMessage, (Address[])recipients, transport, smtpConfig);
                        MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                    }
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
                }
            }
            return MimeMessageConverter.convertMessage((MimeMessage)smtpMessage);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
        }
    }

    public void sendRawMessage(InputStream stream, MailTransport.SendRawProperties properties) throws OXException {
        block19: {
            if (properties.isSanitizeHeaders()) {
                try {
                    this.sendRawMessage(Streams.stream2bytes((InputStream)stream), properties);
                }
                catch (IOException e) {
                    throw MailExceptionCode.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                return;
            }
            SMTPConfig smtpConfig = this.getTransportConfig();
            try {
                boolean poisoned;
                InternetAddress[] recipients;
                SMTPMessage smtpMessage = new SMTPMessage(this.getSMTPSession(), stream);
                InternetAddress sender = properties.getSender();
                if (sender != null) {
                    smtpMessage.setEnvelopeFrom(sender.getAddress());
                }
                if ((recipients = properties.getRecipients()) == null) {
                    recipients = smtpMessage.getAllRecipients();
                }
                if (properties.isValidateAddressHeaders()) {
                    this.processAddressHeader((MimeMessage)smtpMessage);
                }
                if (poisoned = this.checkRecipients((Address[])recipients)) {
                    this.saveChangesSafe((MimeMessage)smtpMessage, true);
                    break block19;
                }
                try {
                    long start = System.currentTimeMillis();
                    try (Transport transport = this.getSMTPSession().getTransport(SMTP);){
                        this.connectTransport(transport, smtpConfig);
                        this.saveChangesSafe((MimeMessage)smtpMessage, true);
                        this.transport((MimeMessage)smtpMessage, (Address[])recipients, transport, smtpConfig);
                        MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                    }
                }
                catch (MessagingException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
                }
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException((MessagingException)e, (MailConfig)smtpConfig, (Session)this.session);
            }
            finally {
                Streams.close((Closeable)stream);
            }
        }
    }

    public MailMessage sendRawMessage(byte[] asciiBytes, Address[] allRecipients) throws OXException {
        SMTPMessage smtpMessage;
        SMTPConfig smtpConfig = this.getTransportConfig();
        try {
            smtpMessage = new SMTPMessage(this.getSMTPSession(), MimeHeaderNameChecker.sanitizeHeaderNames((byte[])asciiBytes));
            smtpMessage.removeHeader("x-original-headers");
        }
        catch (MessagingException e) {
            throw this.handleMessagingException(e, (MailConfig)smtpConfig);
        }
        MimeMessage sentMimeMessage = this.sendMimeMessage((MimeMessage)smtpMessage, allRecipients, null);
        return MimeMessageConverter.convertMessage((MimeMessage)sentMimeMessage);
    }

    public void sendRawMessage(InputStream stream, Address[] allRecipients) throws OXException {
        SMTPMessage smtpMessage;
        SMTPConfig smtpConfig = this.getTransportConfig();
        try {
            smtpMessage = new SMTPMessage(this.getSMTPSession(), stream);
            smtpMessage.removeHeader("x-original-headers");
        }
        catch (MessagingException e) {
            throw this.handleMessagingException(e, (MailConfig)smtpConfig);
        }
        this.sendMimeMessage((MimeMessage)smtpMessage, allRecipients, null);
    }

    public void sendMimeMessage(MimeMessage mimeMessage, Address[] allRecipients) throws OXException {
        this.sendMimeMessage(mimeMessage, allRecipients, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MimeMessage sendMimeMessage(MimeMessage mimeMessage, Address[] allRecipients, MtaStatusInfo mtaStatusInfo) throws OXException {
        SMTPConfig smtpConfig = this.getTransportConfig();
        try {
            Address[] recipients = allRecipients == null ? mimeMessage.getAllRecipients() : allRecipients;
            this.processAddressHeader(mimeMessage);
            boolean poisoned = this.checkRecipients(recipients);
            if (poisoned) {
                this.saveChangesSafe(mimeMessage, true);
                return mimeMessage;
            }
            try (Transport transport = this.getSMTPSession().getTransport(SMTP);){
                long start = System.currentTimeMillis();
                this.connectTransport(transport, smtpConfig);
                this.saveChangesSafe(mimeMessage, true);
                MimeMessage sentMimeMessage = this.transport(mimeMessage, recipients, transport, smtpConfig, mtaStatusInfo);
                MailServletInterface.mailInterfaceMonitor.addUseTime(System.currentTimeMillis() - start);
                MimeMessage mimeMessage2 = sentMimeMessage;
                return mimeMessage2;
            }
        }
        catch (MessagingException e) {
            throw this.handleMessagingException(e, (MailConfig)smtpConfig);
        }
    }

    public void close() {
        this.clearUp();
    }

    private void clearUp() {
        this.doInvocations();
    }

    private void doInvocations() {
        Runnable task = this.pendingInvocations.poll();
        while (task != null) {
            task.run();
            task = this.pendingInvocations.poll();
        }
    }

    private void invokeLater(Runnable task) {
        this.pendingInvocations.offer(task);
    }

    private boolean isKerberosAuth() {
        return 0 == this.accountId && null != this.kerberosSubject;
    }

    private long getMaxMailSize() throws OXException {
        ConfigView view;
        ComposedConfigProperty property;
        ConfigViewFactory factory = Services.getService(ConfigViewFactory.class);
        if (factory != null && (property = (view = factory.getView(this.getUserId(), this.ctx.getContextId())).property("com.openexchange.mail.maxMailSize", Long.class)).isDefined()) {
            long maxMailSize;
            Long l = (Long)property.get();
            long l2 = maxMailSize = null == l ? -1L : l;
            if (maxMailSize > 0L) {
                return maxMailSize;
            }
        }
        return -1L;
    }

    private int getUserId() {
        int userId = this.user == null ? -1 : this.user.getId();
        return userId;
    }

    private MimeMessage transportAlt(MimeMessage smtpMessage, Address[] recipients, Transport transport, SMTPConfig smtpConfig) throws OXException {
        try {
            final MimeMessageDataSource dataSource = new MimeMessageDataSource(smtpMessage, (MailConfig)smtpConfig, smtpConfig.getSession());
            smtpMessage.setDataHandler(new DataHandler((DataSource)dataSource));
            if (!transport.isConnected()) {
                this.connectTransport(transport, smtpConfig);
            }
            transport.sendMessage((Message)smtpMessage, recipients);
            this.logMessageTransport(smtpMessage, smtpConfig);
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        dataSource.cleanUp();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return smtpMessage;
        }
        catch (MessagingException me) {
            throw this.handleMessagingException(me, (MailConfig)smtpConfig);
        }
    }

    private String encodePassword(String password) throws OXException {
        String tmpPass = password;
        if (tmpPass != null) {
            try {
                tmpPass = new String(password.getBytes(Charsets.forName((String)this.getTransportConfig().getSMTPProperties().getSmtpAuthEnc())), Charsets.ISO_8859_1);
            }
            catch (UnsupportedCharsetException e) {
                LOG.error("Unsupported encoding in a message detected and monitored", (Throwable)e);
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(e.getMessage());
            }
        }
        return tmpPass;
    }

    private void prepareAddresses(Address[] addresses) {
        int length = addresses.length;
        StringBuilder tmp = new StringBuilder(32);
        for (int i = 0; i < length; ++i) {
            int pos;
            InternetAddress address = (InternetAddress)addresses[i];
            String sAddress = address.getAddress();
            if (!MsisdnCheck.checkMsisdn((String)sAddress) || (pos = sAddress.indexOf(47)) >= 0) continue;
            tmp.setLength(0);
            address.setAddress(tmp.append(sAddress).append("/TYPE=PLMN").toString());
        }
    }

    private String getHostName() {
        HostnameService hostnameService = Services.getService(HostnameService.class);
        String hostName = null == hostnameService ? this.getFallbackHostname() : (null != this.user && this.user.isGuest() ? hostnameService.getGuestHostname(this.getUserId(), this.ctx.getContextId()) : hostnameService.getHostname(this.getUserId(), this.ctx.getContextId()));
        if (null == hostName) {
            hostName = this.getFallbackHostname();
        }
        return hostName;
    }

    private void checkMimeVersionHeader(MimeMessage mimeMessage) throws MessagingException, IOException {
        String header = mimeMessage.getHeader("Content-Type", null);
        if (null != header && header.toLowerCase().startsWith("multipart/")) {
            Multipart multipart = (Multipart)mimeMessage.getContent();
            int count = multipart.getCount();
            for (int i = 0; i < count; ++i) {
                this.checkMimeVersionHeader((Part)multipart.getBodyPart(i));
            }
        }
    }

    private void checkMimeVersionHeader(Part part) throws MessagingException, IOException {
        String[] header = part.getHeader("Content-Type");
        if (null != header && header.length > 0 && null != header[0]) {
            String cts = header[0].toLowerCase();
            if (cts.startsWith("multipart/")) {
                Multipart multipart = (Multipart)part.getContent();
                int count = multipart.getCount();
                for (int i = 0; i < count; ++i) {
                    this.checkMimeVersionHeader((Part)multipart.getBodyPart(i));
                }
            } else if (cts.startsWith("message/rfc822") || cts.startsWith("message/partial")) {
                Object content;
                part.setHeader("MIME-Version", "1.0");
                try {
                    content = part.getContent();
                }
                catch (Exception e) {
                    content = null;
                }
                if (content instanceof MimeMessage) {
                    this.checkMimeVersionHeader((MimeMessage)content);
                }
            } else {
                part.removeHeader("MIME-Version");
            }
        } else {
            part.removeHeader("MIME-Version");
        }
    }

    private String getFallbackHostname() {
        String serverName = LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.GRIZZLY_SERVER_NAME);
        if (null == serverName) {
            return AbstractSMTPTransport.getStaticHostName();
        }
        return serverName;
    }

    private static String getStaticHostName() {
        UnknownHostException warning = warnSpam;
        if (warning != null) {
            LOG.error("Can't resolve my own hostname, using 'localhost' instead, which is certainly not what you want!", (Throwable)warning);
        }
        return staticHostName;
    }

    private static final boolean isPoisoned(Address[] recipients) {
        if (recipients == null || recipients.length == 0) {
            return false;
        }
        for (Address address : recipients) {
            if (MimeMessageUtility.POISON_ADDRESS != address) continue;
            return true;
        }
        return false;
    }

    private static void handlePrivilegedActionException(PrivilegedActionException e) throws MessagingException, OXException {
        if (null == e) {
            return;
        }
        Exception cause = e.getException();
        if (null == cause) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e.getCause(), new Object[]{e.getMessage()});
        }
        if (cause instanceof MessagingException) {
            throw (MessagingException)((Object)cause);
        }
        if (cause instanceof OXException) {
            throw (OXException)((Object)cause);
        }
        throw MailExceptionCode.UNEXPECTED_ERROR.create((Throwable)cause, new Object[]{cause.getMessage()});
    }

    static {
        try {
            staticHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            staticHostName = "localhost";
            warnSpam = e;
        }
    }

    private static final class SaslSmtpLoginAction
    implements PrivilegedExceptionAction<Object> {
        private final Transport transport;
        private final String server;
        private final int port;
        private final String login;
        private final String pw;

        SaslSmtpLoginAction(Transport transport, String server, int port, String login, String pw) {
            this.transport = transport;
            this.server = server;
            this.port = port;
            this.login = login;
            this.pw = pw;
        }

        @Override
        public Object run() throws MessagingException {
            this.transport.connect(this.server, this.port, this.login, this.pw);
            return null;
        }
    }

    private static final class MailCleanerTask
    implements Runnable {
        private final ComposedMailMessage composedMail;

        MailCleanerTask(ComposedMailMessage composedMail) {
            this.composedMail = composedMail;
        }

        @Override
        public void run() {
            this.composedMail.cleanUp();
        }
    }

    private static final class AddressAddingTransportListener
    implements TransportListener {
        private final MtaStatusInfo statusInfo;

        AddressAddingTransportListener(MtaStatusInfo statusInfo) {
            this.statusInfo = statusInfo;
        }

        public void messagePartiallyDelivered(TransportEvent e) {
            this.fillAddressesFromEvent(e);
        }

        public void messageNotDelivered(TransportEvent e) {
            this.fillAddressesFromEvent(e);
        }

        public void messageDelivered(TransportEvent e) {
            this.fillAddressesFromEvent(e);
        }

        private void fillAddressesFromEvent(TransportEvent e) {
            Address[] arr = e.getInvalidAddresses();
            if (null != arr) {
                this.statusInfo.getInvalidAddresses().addAll(Arrays.asList(arr));
            }
            if (null != (arr = e.getValidUnsentAddresses())) {
                this.statusInfo.getUnsentAddresses().addAll(Arrays.asList(arr));
            }
            if (null != (arr = e.getValidSentAddresses())) {
                this.statusInfo.getSentAddresses().addAll(Arrays.asList(arr));
            }
        }
    }
}

