/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.share;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ShareExceptionCodes implements DisplayableOXExceptionCode
{
    DB_ERROR("Unexpected database error: \"%1$s\"", "Error while reading/writing data from/to the database.", Category.CATEGORY_WARNING, 1),
    UNKNOWN_SHARE("A share with token \"%1$s\" does not exist.", "The requested share does not exist.", Category.CATEGORY_USER_INPUT, 2),
    INVALID_LINK("A share with token \"%1$s\" does not exist.", "The link \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 3),
    UNEXPECTED_ERROR("An unexpected error occurred: %1$s", null, Category.CATEGORY_ERROR, 4),
    INVALID_MAIL_ADDRESS("\"%1$s\" is not a valid email address.", "\"%1$s\" is not a valid email address.", Category.CATEGORY_USER_INPUT, 5),
    CONCURRENT_MODIFICATION("The share \"%1$s\" has been modified in the meantime.", "The share has been modified in the meantime. Please refresh or synchronize and try again.", Category.CATEGORY_CONFLICT, 6),
    NO_DELETE_PERMISSIONS("User %1$d has no delete permissions for share \"%2$s\" in context %3$d.", "You don't have sufficient permissions to delete the share.", Category.CATEGORY_PERMISSION_DENIED, 7),
    NO_EDIT_PERMISSIONS("User %1$d has no delete permissions for share \"%2$s\" in context %3$d.", "You don't have sufficient permissions to edit the share.", Category.CATEGORY_PERMISSION_DENIED, 8),
    NO_SHARE_PERMISSIONS(" User %1$d has no share permissions for folder or item \"%2$s\" in context %3$d.", "You don't have sufficient permissions to share folder or item \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 9),
    IO_ERROR("An I/O error occurred: %1$s", null, Category.CATEGORY_ERROR, 10),
    SQL_ERROR("An SQL error occurred: %1$s", null, Category.CATEGORY_ERROR, 11),
    SHARING_NOT_SUPPORTED("Module %1$s does not support sharing.", "Module %1$s does not support sharing.", Category.CATEGORY_USER_INPUT, 12),
    SHARING_ITEMS_NOT_SUPPORTED("Module %1$s does not support sharing of items.", "Module %1$s does not support sharing of items.", Category.CATEGORY_USER_INPUT, 13),
    SHARING_FOLDERS_NOT_SUPPORTED("Module %1$s does not support sharing of folders.", "Module %1$s does not support sharing of folders.", Category.CATEGORY_USER_INPUT, 14),
    UNKNOWN_GUEST("User %1$d is not a guest user.", null, CATEGORY_ERROR, 15),
    INVALID_TOKEN("The token \"%1$s\" is invalid.", "The token \"%1$s\" is invalid.", Category.CATEGORY_USER_INPUT, 16),
    NO_SHARING_WITH_YOURSELF("You can't share with yourself.", "You can't share with yourself.", Category.CATEGORY_USER_INPUT, 17),
    NO_SHARE_LINK_PERMISSION("You don't have sufficient permissions to share a link.", "You don't have sufficient permissions to share a link.", Category.CATEGORY_PERMISSION_DENIED, 18),
    NO_INVITE_GUEST_PERMISSION("You don't have sufficient permissions to invite guests.", "You don't have sufficient permissions to invite guests.", Category.CATEGORY_PERMISSION_DENIED, 19),
    NO_INVITE_ANONYMOUS("Anonymous guests cannot be created via invite!", null, Category.CATEGORY_ERROR, 20),
    NO_MULTIPLE_TARGETS_LINK("You can't create links for multiple targets.", "You can't create links for multiple targets.", Category.CATEGORY_PERMISSION_DENIED, 21),
    LINK_ALREADY_EXISTS("You cannot create more than one link per folder or item.", "You cannot create more than one link per folder or item.", Category.CATEGORY_PERMISSION_DENIED, 22),
    INVALID_LINK_TARGET("A link for target [%1$s - %2$s - %2$s] does not exist.", null, Category.CATEGORY_ERROR, 23);

    private static final String PREFIX = "SHR";
    private final Category category;
    private final int number;
    private final String message;
    private final String displayMessage;

    private ShareExceptionCodes(String message, String displayMessage, Category category, int detailNumber) {
        this.message = message;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
        this.number = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return null != this.displayMessage ? this.displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public int getNumber() {
        return this.number;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

