/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav;

import com.openexchange.api2.TasksSQLInterface;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.login.Interface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.session.Session;
import com.openexchange.webdav.LastModifiedCache;
import com.openexchange.webdav.PendingInvocations;
import com.openexchange.webdav.QueuedAction;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.TaskParser;
import com.openexchange.webdav.xml.TaskWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class tasks
extends XmlServlet<TasksSQLInterface> {
    private static final long serialVersionUID = 1750720959626156342L;
    static final Logger LOG = LoggerFactory.getLogger(tasks.class);

    @Override
    protected Interface getInterface() {
        return Interface.WEBDAV_ICAL;
    }

    @Override
    protected boolean isServletDisabled() {
        return true;
    }

    @Override
    protected void parsePropChilds(HttpServletRequest req, HttpServletResponse resp, XmlPullParser parser, PendingInvocations<TasksSQLInterface> pendingInvocations) throws OXException, XmlPullParserException, IOException {
        Session session = tasks.getSession(req);
        if (this.isTag(parser, "prop", "DAV:")) {
            parser.nextTag();
            Task task = new Task();
            TaskParser taskparser = new TaskParser(session);
            taskparser.parse(parser, task);
            int method = taskparser.getMethod();
            Date lastModified = task.getLastModified();
            task.removeLastModified();
            int inFolder = taskparser.getFolder();
            switch (method) {
                case 1: {
                    if (task.containsObjectID()) {
                        if (!task.getAlarmFlag()) {
                            task.setAlarm(null);
                        }
                        pendingInvocations.add(new QueuedTask(task, taskparser.getClientID(), 1, lastModified, inFolder));
                        break;
                    }
                    if (!task.getAlarmFlag()) {
                        task.removeAlarm();
                    }
                    task.setParentFolderID(inFolder);
                    pendingInvocations.add(new QueuedTask(task, taskparser.getClientID(), 1, lastModified, inFolder));
                    break;
                }
                case 2: {
                    pendingInvocations.add(new QueuedTask(task, taskparser.getClientID(), 2, lastModified, inFolder));
                    break;
                }
                case 3: {
                    pendingInvocations.add(new QueuedTask(task, taskparser.getClientID(), 3, lastModified, inFolder));
                    break;
                }
                default: {
                    LOG.debug("invalid method: {}", (Object)method);
                    break;
                }
            }
        } else {
            parser.next();
        }
    }

    @Override
    protected void performActions(OutputStream os, Session session, PendingInvocations<TasksSQLInterface> pendingInvocations) throws IOException {
        TasksSQLImpl tasksql = new TasksSQLImpl(session);
        while (!pendingInvocations.isEmpty()) {
            QueuedTask qtask = (QueuedTask)pendingInvocations.poll();
            if (null == qtask) continue;
            qtask.setLastModifiedCache(pendingInvocations.getLastModifiedCache());
            qtask.actionPerformed(tasksql, os, session.getUserId());
        }
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int objectId, int folderId, OutputStream os) throws Exception {
        User userObj = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
        TaskWriter taskwriter = new TaskWriter(userObj, ctx, sessionObj);
        taskwriter.startWriter(objectId, folderId, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, Date lastsync, OutputStream os) throws Exception {
        this.startWriter(sessionObj, ctx, folderId, bModified, bDelete, false, lastsync, os);
    }

    @Override
    protected void startWriter(Session sessionObj, Context ctx, int folderId, boolean bModified, boolean bDelete, boolean bList, Date lastsync, OutputStream os) throws Exception {
        User userObj = UserStorage.getInstance().getUser(sessionObj.getUserId(), ctx);
        TaskWriter taskwriter = new TaskWriter(userObj, ctx, sessionObj);
        taskwriter.startWriter(bModified, bDelete, bList, folderId, lastsync, os);
    }

    @Override
    protected boolean hasModulePermission(Session sessionObj, Context ctx) {
        UserConfiguration uc = UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx);
        return uc.hasWebDAVXML() && uc.hasTask();
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)2);
    }

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)2);
    }

    public final class QueuedTask
    implements QueuedAction<TasksSQLInterface> {
        private final Task task;
        private final String clientId;
        private final int action;
        private final Date lastModified;
        private final int inFolder;
        private LastModifiedCache lastModifiedCache;

        public QueuedTask(Task task, String clientId, int action, Date lastModified, int inFolder) {
            this.task = task;
            this.clientId = clientId;
            this.action = action;
            this.lastModified = lastModified;
            this.inFolder = inFolder;
            this.lastModifiedCache = new LastModifiedCache();
        }

        @Override
        public void actionPerformed(TasksSQLInterface tasksSQL, OutputStream os, int user) throws IOException {
            XMLOutputter xo = new XMLOutputter();
            try {
                if (this.action == 1) {
                    if (this.task.containsObjectID()) {
                        if (this.lastModified == null) {
                            throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                        }
                        Date currentLastModified = this.lastModifiedCache.getLastModified(this.task.getObjectID(), this.lastModified);
                        this.lastModifiedCache.update(this.task.getObjectID(), 0, this.lastModified);
                        tasksSQL.updateTaskObject(this.task, this.inFolder, currentLastModified);
                        this.lastModifiedCache.update(this.task.getObjectID(), 0, this.task.getLastModified());
                    } else {
                        tasksSQL.insertTaskObject(this.task);
                        this.lastModifiedCache.update(this.task.getObjectID(), 0, this.task.getLastModified());
                    }
                } else if (this.action == 2) {
                    if (this.lastModified == null) {
                        throw WebdavExceptionCode.MISSING_FIELD.create("last_modified");
                    }
                    tasksSQL.deleteTaskObject(this.task.getObjectID(), this.inFolder, this.lastModified);
                } else if (this.action == 3) {
                    tasksSQL.setUserConfirmation(this.task.getObjectID(), user, this.task.getConfirm(), this.task.getConfirmMessage());
                } else {
                    throw WebdavExceptionCode.INVALID_ACTION.create(this.action);
                }
                tasks.this.writeResponse(this.task, 200, "[1200] OK", this.clientId, os, xo);
            }
            catch (OXException exc) {
                if (exc.isMandatory()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 409, tasks.this.getErrorMessage(exc, "[%s] Missing field"), this.clientId, os, xo);
                } else if (exc.isNoPermission()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 403, tasks.this.getErrorMessage(exc, "[%s] No permission"), this.clientId, os, xo);
                } else if (exc.isConflict() || exc.getCategories().contains(Category.CATEGORY_CONFLICT)) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 409, "[1000] This object was modified on the server", this.clientId, os, xo);
                } else if (exc.isNotFound()) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 404, "[1001] Object not found", this.clientId, os, xo);
                } else if (exc.getCategory() == Category.CATEGORY_TRUNCATED) {
                    LOG.debug("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 409, tasks.this.getErrorMessage(exc, "[%s] invalid user input"), this.clientId, os, xo);
                } else {
                    LOG.error("parsePropChilds", (Throwable)exc);
                    tasks.this.writeResponse(this.task, 500, tasks.this.getErrorMessage(exc, "[%s] Server Error - ") + exc.toString(), this.clientId, os, xo);
                }
            }
            catch (Exception e) {
                LOG.error("parsePropChilds", (Throwable)e);
                tasks.this.writeResponse(this.task, 500, tasks.this.getErrorMessage("[%s] Server Error - ", "undefinied error") + e.toString(), this.clientId, os, xo);
            }
        }

        public void setLastModifiedCache(LastModifiedCache lastModifiedCache) {
            this.lastModifiedCache = lastModifiedCache;
        }
    }
}

