/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.loader;

import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import java.util.HashSet;
import java.util.Set;

public class LoadingHints {
    private Property property;
    private final Set<WebdavProperty> properties = new HashSet<WebdavProperty>();
    private int depth;
    private WebdavPath url;
    private boolean loadLocks;

    public void setProps(Property which) {
        this.property = which;
    }

    public Property getProps() {
        return this.property;
    }

    public void addProperty(String namespaceURI, String name) {
        this.properties.add(new WebdavProperty(namespaceURI, name));
    }

    public Set<WebdavProperty> getPropterties() {
        return this.properties;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setUrl(WebdavPath url) {
        this.url = url;
    }

    public WebdavPath getUrl() {
        return this.url;
    }

    public void loadLocks(boolean b) {
        this.loadLocks = b;
    }

    public boolean getLoadLocks() {
        return this.loadLocks;
    }

    public boolean mustLoad(String namespace, String name) {
        return this.properties.contains(new WebdavProperty(namespace, name));
    }

    public boolean mustLoad(Protocol.Property p) {
        return this.mustLoad(p.getNamespace(), p.getName());
    }

    public boolean loadOnly(Object ... propertyDefinitions) {
        HashSet<WebdavProperty> propDefs = new HashSet<WebdavProperty>(propertyDefinitions.length);
        Object cache = null;
        for (Object o : propertyDefinitions) {
            if (String.class.isInstance(o)) {
                if (cache == null) {
                    cache = o;
                } else {
                    propDefs.add(new WebdavProperty((String)cache, (String)o));
                    cache = null;
                }
            }
            if (!Protocol.Property.class.isInstance(o)) continue;
            cache = null;
            Protocol.Property p = (Protocol.Property)o;
            propDefs.add(new WebdavProperty(p.getNamespace(), p.getName()));
        }
        return this.properties.containsAll(propDefs);
    }

    public static enum Property {
        ALL,
        SOME,
        NONE;

    }
}

