/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.passwordmechs.IPasswordMech;
import com.openexchange.passwordmechs.PasswordMechFactory;
import com.openexchange.user.UserService;
import com.openexchange.user.UserServiceInterceptor;
import com.openexchange.user.UserServiceInterceptorRegistry;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserServiceImpl
implements UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserServiceImpl.class);
    private final UserServiceInterceptorRegistry interceptorRegistry;
    private final PasswordMechFactory passwordMechFactory;

    public UserServiceImpl(UserServiceInterceptorRegistry interceptorRegistry, PasswordMechFactory factory) {
        this.interceptorRegistry = interceptorRegistry;
        this.passwordMechFactory = factory;
    }

    @Override
    public boolean isGuest(int userId, Context context) throws OXException {
        return UserStorage.getInstance().isGuest(userId, context);
    }

    @Override
    public boolean isGuest(int userId, int contextId) throws OXException {
        return UserStorage.getInstance().isGuest(userId, contextId);
    }

    @Override
    public Context getContext(int contextId) throws OXException {
        return ContextStorage.getStorageContext(contextId);
    }

    @Override
    public String getUserAttribute(String name, int userId, Context context) throws OXException {
        return UserStorage.getInstance().getUserAttribute(name, userId, context);
    }

    @Override
    public void setUserAttribute(String name, String value, int userId, Context context) throws OXException {
        UserStorage.getInstance().setUserAttribute(name, value, userId, context);
    }

    @Override
    public void setAttribute(String name, String value, int userId, Context context) throws OXException {
        UserStorage.getInstance().setAttribute(name, value, userId, context);
    }

    @Override
    public void setAttribute(Connection con, String name, String value, int userId, Context context) throws OXException {
        UserStorage.getInstance().setAttribute(con, name, value, userId, context);
    }

    @Override
    public User getUser(int uid, Context context) throws OXException {
        return UserStorage.getInstance().getUser(uid, context);
    }

    @Override
    public User getUser(int userId, int contextId) throws OXException {
        return UserStorage.getInstance().getUser(userId, ContextStorage.getInstance().getContext(contextId));
    }

    @Override
    public User getUser(Connection con, int uid, Context context) throws OXException {
        return UserStorage.getInstance().getUser(context, uid, con);
    }

    @Override
    public User[] getUser(Context context, int[] userIds) throws OXException {
        return UserStorage.getInstance().getUser(context, userIds);
    }

    @Override
    public User[] getUser(Context context) throws OXException {
        return UserStorage.getInstance().getUser(context);
    }

    @Override
    public User[] getUser(Connection con, Context ctx, boolean includeGuests, boolean excludeUsers) throws OXException {
        return UserStorage.getInstance().getUser(con, ctx, includeGuests, excludeUsers);
    }

    @Override
    public User[] getUser(Context ctx, boolean includeGuests, boolean excludeUsers) throws OXException {
        return UserStorage.getInstance().getUser(ctx, includeGuests, excludeUsers);
    }

    @Override
    public User[] getGuestsCreatedBy(Connection connection, Context context, int userId) throws OXException {
        return UserStorage.getInstance().getGuestsCreatedBy(connection, context, userId);
    }

    @Override
    public int createUser(Context context, User user) throws OXException {
        this.checkUser(user);
        List<UserServiceInterceptor> interceptors = this.interceptorRegistry.getInterceptors();
        this.beforeCreate(context, user, interceptors);
        int userId = UserStorage.getInstance().createUser(context, user);
        UserImpl created = new UserImpl(user);
        created.setId(userId);
        this.afterCreate(context, created, interceptors);
        return userId;
    }

    @Override
    public int createUser(Connection con, Context context, User user) throws OXException {
        this.checkUser(user);
        List<UserServiceInterceptor> interceptors = this.interceptorRegistry.getInterceptors();
        this.beforeCreate(context, user, interceptors);
        int userId = UserStorage.getInstance().createUser(con, context, user);
        UserImpl created = new UserImpl(user);
        created.setId(userId);
        this.afterCreate(context, created, interceptors);
        return userId;
    }

    @Override
    public void deleteUser(Context context, User user) throws OXException {
        List<UserServiceInterceptor> interceptors = this.interceptorRegistry.getInterceptors();
        this.beforeDelete(context, user, interceptors);
        UserStorage.getInstance().deleteUser(context, user.getId());
        this.afterDelete(context, user, interceptors);
    }

    @Override
    public void deleteUser(Connection con, Context context, User user) throws OXException {
        List<UserServiceInterceptor> interceptors = this.interceptorRegistry.getInterceptors();
        this.beforeDelete(context, user, interceptors);
        UserStorage.getInstance().deleteUser(con, context, user.getId());
        this.afterDelete(context, user, interceptors);
    }

    @Override
    public void deleteUser(Context context, int userId) throws OXException {
        this.deleteUser(context, this.getUser(userId, context));
    }

    @Override
    public void deleteUser(Connection con, Context context, int userId) throws OXException {
        this.deleteUser(con, context, this.getUser(con, userId, context));
    }

    @Override
    public int getUserId(String loginInfo, Context context) throws OXException {
        return UserStorage.getInstance().getUserId(loginInfo, context);
    }

    @Override
    public void invalidateUser(Context ctx, int userId) throws OXException {
        UserStorage.getInstance().invalidateUser(ctx, userId);
    }

    @Override
    public int[] listAllUser(Context context) throws OXException {
        return UserStorage.getInstance().listAllUser(context);
    }

    @Override
    public int[] listAllUser(Context context, boolean includeGuests, boolean excludeUsers) throws OXException {
        return UserStorage.getInstance().listAllUser(null, context, includeGuests, excludeUsers);
    }

    @Override
    public int[] listAllUser(int contextID, boolean includeGuests, boolean excludeUsers) throws OXException {
        return UserStorage.getInstance().listAllUser(null, contextID, includeGuests, excludeUsers);
    }

    @Override
    public int[] listModifiedUser(Date modifiedSince, Context context) throws OXException {
        return UserStorage.getInstance().listModifiedUser(modifiedSince, context);
    }

    @Override
    public int[] resolveIMAPLogin(String imapLogin, Context context) throws OXException {
        return UserStorage.getInstance().resolveIMAPLogin(imapLogin, context);
    }

    @Override
    public User searchUser(String email, Context context) throws OXException {
        return UserStorage.getInstance().searchUser(email, context);
    }

    @Override
    public User searchUser(String email, Context context, boolean considerAliases) throws OXException {
        return UserStorage.getInstance().searchUser(email, context, considerAliases);
    }

    @Override
    public User searchUser(String email, Context context, boolean considerAliases, boolean includeGuests, boolean excludeUsers) throws OXException {
        return UserStorage.getInstance().searchUser(email, context, considerAliases, includeGuests, excludeUsers);
    }

    @Override
    public User[] searchUserByName(String name, Context context, int searchType) throws OXException {
        return UserStorage.getInstance().searchUserByName(name, context, searchType);
    }

    @Override
    public void updateUser(User user, Context context) throws OXException {
        this.updateUser(null, user, context);
    }

    @Override
    public void updateUser(Connection con, User user, Context context) throws OXException {
        List<UserServiceInterceptor> interceptors = this.interceptorRegistry.getInterceptors();
        this.beforeUpdate(context, user, UserServiceInterceptor.EMPTY_PROPS, interceptors);
        UserStorage.getInstance().updateUser(con, user, context);
        this.afterUpdate(context, user, UserServiceInterceptor.EMPTY_PROPS, interceptors);
    }

    @Override
    public boolean authenticate(User user, String password) throws OXException {
        IPasswordMech iPasswordMech = this.passwordMechFactory.get(user.getPasswordMech());
        return iPasswordMech.check(password, user.getUserPassword());
    }

    private void beforeCreate(Context context, User user, List<UserServiceInterceptor> interceptors) throws OXException {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                interceptor.beforeCreate(context, user, null);
            }
        }
    }

    private void afterCreate(Context context, User user, List<UserServiceInterceptor> interceptors) {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                try {
                    interceptor.afterCreate(context, user, null);
                }
                catch (OXException e) {
                    LOG.error("Error while calling interceptor.", (Throwable)e);
                }
            }
        }
    }

    private void beforeUpdate(Context context, User user, Map<String, Object> properties, List<UserServiceInterceptor> interceptors) throws OXException {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                interceptor.beforeUpdate(context, user, null, properties);
            }
        }
    }

    private void afterUpdate(Context context, User user, Map<String, Object> properties, List<UserServiceInterceptor> interceptors) {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                try {
                    interceptor.afterUpdate(context, user, null, properties);
                }
                catch (OXException e) {
                    LOG.error("Error while calling interceptor.", (Throwable)e);
                }
            }
        }
    }

    private void beforeDelete(Context context, User user, List<UserServiceInterceptor> interceptors) throws OXException {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                interceptor.beforeDelete(context, user, null);
            }
        }
    }

    private void afterDelete(Context context, User user, List<UserServiceInterceptor> interceptors) {
        if (!user.isGuest()) {
            for (UserServiceInterceptor interceptor : interceptors) {
                try {
                    interceptor.afterDelete(context, user, null);
                }
                catch (OXException e) {
                    LOG.error("Error while calling interceptor.", (Throwable)e);
                }
            }
        }
    }

    private void checkUser(User user) throws OXException {
        String mail = user.getMail();
        String language = user.getPreferredLanguage();
        String timeZone = user.getTimeZone();
        String passwordMech = user.getPasswordMech();
        if (mail == null) {
            throw UserExceptionCode.MISSING_PARAMETER.create("mail address");
        }
        if (language == null || LocaleTools.getLocale((String)language) == null) {
            throw UserExceptionCode.MISSING_PARAMETER.create("preferred language");
        }
        Locale locale = LocaleTools.getLocale((String)language);
        if (locale == null) {
            throw UserExceptionCode.INVALID_LOCALE.create(language);
        }
        if (timeZone == null) {
            throw UserExceptionCode.MISSING_PARAMETER.create("timezone");
        }
        List<String> validTimeZones = Arrays.asList(TimeZone.getAvailableIDs());
        boolean found = false;
        for (String validTimeZone : validTimeZones) {
            if (!validTimeZone.equals(timeZone)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw UserExceptionCode.INVALID_TIMEZONE.create(timeZone);
        }
        if (passwordMech == null) {
            throw UserExceptionCode.MISSING_PASSWORD_MECH.create();
        }
    }

    @Override
    public void updatePassword(User user, Context context) throws OXException {
        IPasswordMech iPasswordMech = this.passwordMechFactory.get(user.getPasswordMech());
        UserStorage.getInstance().updatePassword(null, context, user.getId(), iPasswordMech, user.getUserPassword());
    }

    @Override
    public void updatePassword(Connection connection, User user, Context context) throws OXException {
        IPasswordMech iPasswordMech = this.passwordMechFactory.get(user.getPasswordMech());
        UserStorage.getInstance().updatePassword(connection, context, user.getId(), iPasswordMech, user.getUserPassword());
    }
}

