/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServletRegistration
extends ServiceTracker<HttpService, HttpService> {
    private static Logger LOG = LoggerFactory.getLogger(HTTPServletRegistration.class);
    private final Servlet servlet;
    private final String alias;

    public HTTPServletRegistration(BundleContext context, String alias, Servlet servlet) {
        super(context, HttpService.class, null);
        this.alias = alias;
        this.servlet = servlet;
        this.open();
    }

    public HTTPServletRegistration(BundleContext context, Servlet servlet, String alias) {
        super(context, HttpService.class, null);
        this.alias = alias;
        this.servlet = servlet;
        this.open();
    }

    public HttpService addingService(ServiceReference<HttpService> reference) {
        try {
            HttpService service = (HttpService)super.addingService(reference);
            service.registerServlet(this.alias, this.servlet, null, null);
            return service;
        }
        catch (ServletException e) {
            LOG.error("", (Throwable)e);
            this.context.ungetService(reference);
        }
        catch (NamespaceException e) {
            LOG.error("", (Throwable)e);
            this.context.ungetService(reference);
        }
        return null;
    }

    public void removedService(ServiceReference<HttpService> reference, HttpService service) {
        service.unregister(this.alias);
        super.removedService(reference, (Object)service);
    }

    private void unregister0() {
        HttpService service = (HttpService)this.getService();
        if (service != null) {
            service.unregister(this.alias);
        }
    }

    public void unregister() {
        this.unregister0();
        this.close();
    }
}

