/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.tools.encoding.Base64;
import java.nio.charset.UnsupportedCharsetException;

public final class Authorization {
    private static final String BASIC_AUTH = "basic";
    private static final String SPNEGO_AUTH = "negotiate";
    private static final String DIGEST_AUTH = "digest";
    private static final char UNKNOWN = '\ufffd';

    private Authorization() {
    }

    public static boolean checkForAuthorizationHeader(String authHeader) {
        String authScheme = Authorization.extractAuthScheme(authHeader);
        if (null == authScheme) {
            return false;
        }
        return authScheme.equalsIgnoreCase(BASIC_AUTH) || authScheme.equalsIgnoreCase(SPNEGO_AUTH);
    }

    public static boolean checkForDigestAuthorization(String auth) {
        if (null == auth) {
            return false;
        }
        if (auth.length() <= DIGEST_AUTH.length()) {
            return false;
        }
        return auth.substring(0, DIGEST_AUTH.length()).equalsIgnoreCase(DIGEST_AUTH);
    }

    public static String extractAuthScheme(String authHeader) {
        if (Strings.isEmpty((String)authHeader)) {
            return null;
        }
        int spacePos = authHeader.indexOf(32);
        if (-1 == spacePos) {
            return null;
        }
        return authHeader.substring(0, spacePos);
    }

    public static boolean checkForBasicAuthorization(String authHeader) {
        String authScheme = Authorization.extractAuthScheme(authHeader);
        if (null == authScheme) {
            return false;
        }
        return authScheme.equalsIgnoreCase(BASIC_AUTH);
    }

    public static boolean checkForKerberosAuthorization(String authHeader) {
        String authScheme = Authorization.extractAuthScheme(authHeader);
        if (null == authScheme) {
            return false;
        }
        return authScheme.equalsIgnoreCase(SPNEGO_AUTH);
    }

    public static Credentials decode(String auth) throws UnsupportedCharsetException {
        byte[] decoded = Base64.decode(auth.substring(BASIC_AUTH.length() + 1));
        String userpass = new String(decoded, Charsets.UTF_8).trim();
        if (userpass.indexOf(65533) >= 0) {
            userpass = new String(decoded, Charsets.ISO_8859_1).trim();
        }
        int delimiter = userpass.indexOf(58);
        String login = "";
        String pass = "";
        if (-1 != delimiter) {
            login = userpass.substring(0, delimiter);
            pass = userpass.substring(delimiter + 1);
        }
        return new Credentials(login, pass);
    }

    public static boolean checkLogin(String pass) {
        return pass != null && !Strings.isEmpty((String)pass);
    }

    public static class Credentials {
        private final String login;
        private final String password;

        public Credentials(String login, String password) {
            this.login = login;
            this.password = password;
        }

        public String getLogin() {
            return this.login;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(24);
            builder.append("Credentials [");
            if (this.login != null) {
                builder.append("login=").append(this.login).append(", ");
            }
            if (this.password != null) {
                builder.append("password=").append(this.password);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

