/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.permissionLoader;

import com.openexchange.concurrent.TimeoutConcurrentMap;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.osgi.ServerActivator;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.permissionLoader.Gate;
import com.openexchange.tools.oxfolder.permissionLoader.StampedFuture;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PermissionLoaderService
implements Runnable {
    protected static final Logger LOG = LoggerFactory.getLogger(PermissionLoaderService.class);
    private static volatile PermissionLoaderService instance;
    private static final Pair POISON;
    private static final long MAX_RUNNING_TIME = 60000L;
    private static final long WAIT_TIME = 3000L;
    private static final int MAX_CONCURRENT_TASKS = -1;
    protected final AtomicReferenceArray<StampedFuture> concurrentFutures = null;
    private final BlockingQueue<Pair> queue;
    private volatile TimeoutConcurrentMap<Pair, OCLPermission[]> permsMap;
    private final AtomicBoolean keepgoing = new AtomicBoolean(true);
    private volatile Future<Object> future;
    private final String simpleName;
    private final Gate gate;
    private final StampedFuture placeHolder = null;
    private volatile ServiceTracker<ThreadPoolService, ThreadPoolService> poolTracker;
    protected volatile ThreadPoolService threadPool;
    protected volatile ConcurrentMap<Integer, ConWrapper> pooledCons;
    private volatile ScheduledTimerTask timerTask;
    private static final int MAX_FILLER_CHUNK = 1024;
    private static final String SQL_LOAD_P = "SELECT permission_id, fp, orp, owp, odp, admin_flag, group_flag, system FROM oxfolder_permissions WHERE cid = ? AND fuid = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermissionLoaderService getInstance() {
        PermissionLoaderService tmp = instance;
        if (null != tmp) return tmp;
        Class<PermissionLoaderService> clazz = PermissionLoaderService.class;
        synchronized (PermissionLoaderService.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = tmp = new PermissionLoaderService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static void dropInstance() {
        PermissionLoaderService tmp = instance;
        if (null != tmp) {
            tmp.shutDown();
            instance = null;
        }
    }

    public PermissionLoaderService() {
        this.queue = new LinkedBlockingQueue<Pair>();
        this.simpleName = this.getClass().getSimpleName();
        this.gate = new Gate(-1);
    }

    public void startUp() throws OXException {
        final BundleContext context = ServerActivator.getContext();
        if (context == null) {
            this.threadPool = ThreadPools.getThreadPool();
        } else {
            ServiceTrackerCustomizer<ThreadPoolService, ThreadPoolService> customizer = new ServiceTrackerCustomizer<ThreadPoolService, ThreadPoolService>(){

                public ThreadPoolService addingService(ServiceReference<ThreadPoolService> reference) {
                    ThreadPoolService service;
                    PermissionLoaderService.this.threadPool = service = (ThreadPoolService)context.getService(reference);
                    return service;
                }

                public void modifiedService(ServiceReference<ThreadPoolService> reference, ThreadPoolService service) {
                }

                public void removedService(ServiceReference<ThreadPoolService> reference, ThreadPoolService service) {
                    PermissionLoaderService.this.threadPool = null;
                    context.ungetService(reference);
                }
            };
            this.poolTracker = new ServiceTracker(context, ThreadPoolService.class, (ServiceTrackerCustomizer)customizer);
            this.poolTracker.open();
        }
        this.future = ThreadPools.getThreadPool().submit(ThreadPools.task((Runnable)this, (String)this.simpleName));
        this.permsMap = new TimeoutConcurrentMap(20, true);
        this.pooledCons = new ConcurrentHashMap<Integer, ConWrapper>();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    long stamp = System.currentTimeMillis() - 1000L;
                    Iterator it = PermissionLoaderService.this.pooledCons.values().iterator();
                    while (it.hasNext()) {
                        ConWrapper vw = (ConWrapper)it.next();
                        Connection connection = vw.readyForRemoval(stamp);
                        if (connection == null) continue;
                        it.remove();
                        Database.backNoTimeout(vw.contextId, false, connection);
                        LOG.debug("Closed \"shared\" connection.");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.timerTask = ServerServiceRegistry.getInstance().getService(TimerService.class).scheduleWithFixedDelay(task, 1000L, 1000L);
        this.gate.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutDown() {
        block14: {
            this.keepgoing.set(false);
            this.queue.offer(POISON);
            try {
                this.future.get(3L, TimeUnit.SECONDS);
                if (null == this.timerTask) break block14;
            }
            catch (InterruptedException e) {
                block15: {
                    Thread.currentThread().interrupt();
                    if (null == this.timerTask) break block15;
                    this.timerTask.cancel(false);
                    this.timerTask = null;
                    for (ConWrapper vw : this.pooledCons.values()) {
                        Connection connection = vw.con;
                        if (connection == null) continue;
                        Database.backNoTimeout(vw.contextId, false, connection);
                    }
                    this.pooledCons.clear();
                }
                if (null == this.poolTracker) return;
                this.poolTracker.close();
                this.poolTracker = null;
                return;
                catch (ExecutionException e2) {
                    block16: {
                        LOG.error("Error stopping queue", e2.getCause());
                        if (null == this.timerTask) break block16;
                        this.timerTask.cancel(false);
                        this.timerTask = null;
                        for (ConWrapper vw : this.pooledCons.values()) {
                            Connection connection = vw.con;
                            if (connection == null) continue;
                            Database.backNoTimeout(vw.contextId, false, connection);
                        }
                        this.pooledCons.clear();
                    }
                    if (null == this.poolTracker) return;
                    this.poolTracker.close();
                    this.poolTracker = null;
                    return;
                    catch (TimeoutException e3) {
                        block17: {
                            try {
                                this.future.cancel(true);
                                if (null == this.timerTask) break block17;
                            }
                            catch (Throwable throwable) {
                                if (null != this.timerTask) {
                                    this.timerTask.cancel(false);
                                    this.timerTask = null;
                                    for (ConWrapper vw : this.pooledCons.values()) {
                                        Connection connection = vw.con;
                                        if (connection == null) continue;
                                        Database.backNoTimeout(vw.contextId, false, connection);
                                    }
                                    this.pooledCons.clear();
                                }
                                if (null == this.poolTracker) throw throwable;
                                this.poolTracker.close();
                                this.poolTracker = null;
                                throw throwable;
                            }
                            this.timerTask.cancel(false);
                            this.timerTask = null;
                            for (ConWrapper vw : this.pooledCons.values()) {
                                Connection connection = vw.con;
                                if (connection == null) continue;
                                Database.backNoTimeout(vw.contextId, false, connection);
                            }
                            this.pooledCons.clear();
                        }
                        if (null == this.poolTracker) return;
                        this.poolTracker.close();
                        this.poolTracker = null;
                        return;
                    }
                }
            }
            this.timerTask.cancel(false);
            this.timerTask = null;
            for (ConWrapper vw : this.pooledCons.values()) {
                Connection connection = vw.con;
                if (connection == null) continue;
                Database.backNoTimeout(vw.contextId, false, connection);
            }
            this.pooledCons.clear();
        }
        if (null == this.poolTracker) return;
        this.poolTracker.close();
        this.poolTracker = null;
        return;
    }

    public void submitPermissionsFor(int contextId, int folderId) {
        this.queue.offer(PermissionLoaderService.newPair(folderId, contextId));
    }

    public void submitPermissionsFor(int contextId, int ... folderIds) {
        ArrayList<Pair> tmp = new ArrayList<Pair>(folderIds.length);
        for (int folderId : folderIds) {
            tmp.add(PermissionLoaderService.newPair(folderId, contextId));
        }
        this.queue.addAll(tmp);
    }

    public OCLPermission[] pollPermissions(int folderId, int contextId) {
        return this.permsMap.remove(PermissionLoaderService.newPair(folderId, contextId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Gate gate = this.gate;
            ArrayList<Pair> list = new ArrayList<Pair>(128);
            TObjectProcedure<List<Pair>> proc = new TObjectProcedure<List<Pair>>(){

                public boolean execute(List<Pair> pairs) {
                    try {
                        PermissionLoaderService.this.handlePairs(pairs);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.error("Interrupted permission loader run.", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.error("Failed permission loader run.", (Throwable)e);
                    }
                    return true;
                }
            };
            while (this.keepgoing.get()) {
                gate.pass();
                try {
                    if (this.queue.isEmpty()) {
                        Pair next;
                        try {
                            next = this.queue.take();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            gate.signalDone();
                            return;
                        }
                        if (POISON == next) {
                            return;
                        }
                        list.add(next);
                        PermissionLoaderService.await(100L, true);
                    }
                    this.queue.drainTo(list);
                    boolean quit = list.remove(POISON);
                    if (!list.isEmpty()) {
                        DelegaterTask task = new DelegaterTask(new ArrayList<Pair>(list), proc);
                        ThreadPoolService threadPool = this.threadPool;
                        if (null == threadPool) {
                            task.call();
                        } else {
                            threadPool.submit((Task)task);
                        }
                    }
                    if (quit) {
                        return;
                    }
                    list.clear();
                }
                finally {
                    gate.signalDone();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted permission loader run.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Failed permission loader run.", (Throwable)e);
        }
    }

    protected void handlePairs(List<Pair> groupedPairs) throws InterruptedException {
        int size = groupedPairs.size();
        int configuredBlockSize = 1024;
        if (size <= 1024) {
            this.handlePairsSublist(groupedPairs, this.simpleName);
        } else {
            int fromIndex = 0;
            while (fromIndex < size) {
                int toIndex = fromIndex + 1024;
                if (toIndex > size) {
                    this.schedulePairsSublist(groupedPairs.subList(fromIndex, size));
                    fromIndex = size;
                    continue;
                }
                this.schedulePairsSublist(groupedPairs.subList(fromIndex, toIndex));
                fromIndex = toIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePairsSublist(List<Pair> groupedPairsSublist) throws InterruptedException {
        ThreadPoolService threadPool = this.threadPool;
        if (null == threadPool) {
            this.handlePairsSublist(groupedPairsSublist, this.simpleName);
        } else if (null == this.concurrentFutures) {
            PairHandlerTask task = new PairHandlerTask(groupedPairsSublist);
            threadPool.submit(ThreadPools.task((Callable)((Object)task)));
            task.start(null);
        } else {
            int index = -1;
            while (index < 0) {
                long earliestStamp = System.currentTimeMillis() - 60000L;
                for (int i = 0; index < 0 && i < -1; ++i) {
                    StampedFuture sf = this.concurrentFutures.get(i);
                    if (null == sf) {
                        if (!this.concurrentFutures.compareAndSet(i, null, this.placeHolder)) continue;
                        index = i;
                        continue;
                    }
                    if (sf.getStamp() >= earliestStamp) continue;
                    sf.getFuture().cancel(true);
                    LOG.debug("Cancelled elapsed task running for {}msec.", (Object)(System.currentTimeMillis() - sf.getStamp()));
                    if (!this.concurrentFutures.compareAndSet(i, sf, this.placeHolder)) continue;
                    index = i;
                }
                LOG.debug(index < 0 ? "Awaiting a free/elapsed slot..." : "Found a free/elapsed slot...");
                if (index >= 0) continue;
                StampedFuture i = this.placeHolder;
                synchronized (i) {
                    this.placeHolder.wait(3000L);
                }
            }
            IndexedPairHandlerTask task = new IndexedPairHandlerTask(groupedPairsSublist, index);
            Future f = threadPool.submit(ThreadPools.task((Callable)((Object)task)));
            StampedFuture sf = new StampedFuture(f);
            this.concurrentFutures.set(index, sf);
            ((PairHandlerTask)task).start(sf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePairsSublist(List<Pair> pairsChunk, String threadDesc) {
        block50: {
            if (pairsChunk.isEmpty()) {
                return;
            }
            try {
                int contextId = pairsChunk.get((int)0).contextId;
                Integer key = contextId;
                ConWrapper readConWrapper = (ConWrapper)this.pooledCons.get(key);
                if (null == readConWrapper) {
                    Connection newReadCon = Database.getNoTimeout(contextId, false);
                    ConWrapper nw = new ConWrapper(newReadCon, contextId);
                    readConWrapper = this.pooledCons.putIfAbsent(key, nw);
                    if (null != readConWrapper) {
                        LOG.debug("Using \"un-shared\" connection.");
                        try {
                            for (Pair pair : pairsChunk) {
                                this.permsMap.put(pair, PermissionLoaderService.loadFolderPermissions(pair.folderId, contextId, newReadCon), 60);
                            }
                        }
                        catch (SQLException e) {
                            throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.FOLDER, e.getMessage()});
                        }
                        finally {
                            Database.backNoTimeout(contextId, false, newReadCon);
                            LOG.debug("Released \"un-shared\" connection.");
                        }
                        return;
                    }
                    readConWrapper = nw;
                } else {
                    LOG.debug("Using \"shared\" connection.");
                }
                Lock rlock = readConWrapper.rlock;
                rlock.lock();
                boolean dec = false;
                try {
                    if (readConWrapper.obtain()) {
                        dec = true;
                        ConWrapper e = readConWrapper;
                        synchronized (e) {
                            Connection con = readConWrapper.con;
                            for (Pair pair : pairsChunk) {
                                this.permsMap.put(pair, PermissionLoaderService.loadFolderPermissions(pair.folderId, contextId, con), 60);
                            }
                            break block50;
                        }
                    }
                    this.handlePairsSublist(pairsChunk, threadDesc);
                    return;
                }
                catch (SQLException e) {
                    this.pooledCons.remove(key);
                    throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.FOLDER, e.getMessage()});
                }
                finally {
                    if (dec) {
                        readConWrapper.release();
                    }
                    rlock.unlock();
                }
            }
            catch (OXException e) {
                LOG.error("Failed loading permissions.", (Throwable)e);
            }
            catch (RuntimeException e) {
                LOG.error("Failed loading permissions.", (Throwable)e);
            }
            finally {
                if (null != this.placeHolder) {
                    StampedFuture e = this.placeHolder;
                    synchronized (e) {
                        this.placeHolder.notifyAll();
                    }
                }
            }
        }
    }

    protected static OCLPermission[] loadFolderPermissions(int folderId, int cid, Connection con) throws OXException, SQLException {
        OCLPermission[] oCLPermissionArray;
        ResultSet rs;
        PreparedStatement stmt;
        block7: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement(SQL_LOAD_P);
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) break block7;
            OCLPermission[] oCLPermissionArray2 = new OCLPermission[]{};
            DBUtils.closeSQLStuff(rs, stmt);
            return oCLPermissionArray2;
        }
        try {
            ArrayList<OCLPermission> ret = new ArrayList<OCLPermission>(8);
            do {
                OCLPermission p = new OCLPermission();
                p.setEntity(rs.getInt(1));
                p.setAllPermission(rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5));
                p.setFolderAdmin(rs.getInt(6) > 0);
                p.setGroupPermission(rs.getInt(7) > 0);
                p.setSystem(rs.getInt(8));
                ret.add(p);
            } while (rs.next());
            oCLPermissionArray = ret.toArray(new OCLPermission[ret.size()]);
        }
        catch (SQLException e) {
            try {
                if ("Connection was already closed.".equals(e.getMessage())) {
                    throw e;
                }
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.FOLDER, e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return oCLPermissionArray;
    }

    protected static TIntObjectMap<List<Pair>> groupByContext(Collection<Pair> pairs) {
        TIntObjectHashMap map = new TIntObjectHashMap(pairs.size());
        for (Pair pair : pairs) {
            int contextId = pair.contextId;
            LinkedList<Pair> set = (LinkedList<Pair>)map.get(contextId);
            if (null == set) {
                set = new LinkedList<Pair>();
                map.put(contextId, set);
            }
            set.add(pair);
        }
        return map;
    }

    protected static void await(long millis, boolean blocking) throws InterruptedException {
        long time1;
        if (blocking) {
            Thread.sleep(millis);
            return;
        }
        long time0 = System.currentTimeMillis();
        while ((time1 = System.currentTimeMillis()) - time0 < millis) {
        }
    }

    private static Pair newPair(int folderid, int contextId) {
        return new Pair(folderid, contextId);
    }

    static {
        POISON = PermissionLoaderService.newPair(-1, -1);
    }

    private static final class ConWrapper {
        protected final int contextId;
        protected volatile Connection con;
        protected volatile long lastAccessed;
        protected final AtomicInteger counter;
        protected final Lock rlock;
        protected final Lock wlock;

        protected ConWrapper(Connection con, int contextId) {
            this.contextId = contextId;
            ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
            this.rlock = rwlock.readLock();
            this.wlock = rwlock.writeLock();
            this.con = con;
            this.counter = new AtomicInteger();
            this.lastAccessed = System.currentTimeMillis();
        }

        protected boolean obtain() {
            if (null == this.con) {
                return false;
            }
            this.counter.incrementAndGet();
            return true;
        }

        protected void release() {
            this.counter.decrementAndGet();
            this.lastAccessed = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Connection readyForRemoval(long stamp) {
            if (!this.wlock.tryLock()) {
                return null;
            }
            try {
                if (this.lastAccessed < stamp && (null == this.con || 0 == this.counter.get())) {
                    Connection c = this.con;
                    this.con = null;
                    Connection connection = c;
                    return connection;
                }
                Connection connection = null;
                return connection;
            }
            finally {
                this.wlock.unlock();
            }
        }
    }

    private final class IndexedPairHandlerTask
    extends PairHandlerTask {
        private final int indexPos;
        private volatile StampedFuture sf;

        protected IndexedPairHandlerTask(List<Pair> pairs, int indexPos) {
            super(pairs);
            this.indexPos = indexPos;
        }

        @Override
        protected void start(StampedFuture sf) {
            this.sf = sf;
            this.startSignal.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            try {
                this.startSignal.await();
                StampedFuture sf = this.sf;
                if (null != sf) {
                    sf.setStamp(System.currentTimeMillis());
                }
                PermissionLoaderService.this.handlePairsSublist(this.pairs, String.valueOf(this.indexPos + 1));
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                PermissionLoaderService.this.concurrentFutures.set(this.indexPos, null);
            }
        }
    }

    private class PairHandlerTask
    implements Task<Object> {
        protected final List<Pair> pairs;
        protected final CountDownLatch startSignal = new CountDownLatch(1);

        protected PairHandlerTask(List<Pair> pairs) {
            this.pairs = pairs;
        }

        protected void start(StampedFuture sf) {
            this.startSignal.countDown();
        }

        public void setThreadName(ThreadRenamer threadRenamer) {
        }

        public void beforeExecute(Thread t) {
        }

        public void afterExecute(Throwable t) {
        }

        public Object call() throws Exception {
            this.startSignal.await();
            PermissionLoaderService.this.handlePairsSublist(this.pairs, null);
            return null;
        }
    }

    private static final class Pair {
        public final int folderId;
        public final int contextId;
        private final int hash;

        public Pair(int folderId, int contextId) {
            this.folderId = folderId;
            this.contextId = contextId;
            int prime = 31;
            int result = 1;
            result = 31 * result + folderId;
            this.hash = result = 31 * result + contextId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.folderId != other.folderId) {
                return false;
            }
            return this.contextId == other.contextId;
        }
    }

    private final class DelegaterTask
    implements Task<Object> {
        private final List<Pair> list;
        private final TObjectProcedure<List<Pair>> proc;

        protected DelegaterTask(List<Pair> list, TObjectProcedure<List<Pair>> proc) {
            this.list = list;
            this.proc = proc;
        }

        public void setThreadName(ThreadRenamer threadRenamer) {
        }

        public void beforeExecute(Thread t) {
        }

        public void afterExecute(Throwable t) {
        }

        public Object call() throws Exception {
            PermissionLoaderService.groupByContext(this.list).forEachValue(this.proc);
            return null;
        }
    }
}

