/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener.sql;

import com.openexchange.tools.oxfolder.deletelistener.CorruptPermission;
import com.openexchange.tools.oxfolder.deletelistener.Permission;
import com.openexchange.tools.oxfolder.deletelistener.sql.MergerUtility;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupPermissionMerger {
    private static final Logger LOG = LoggerFactory.getLogger(GroupPermissionMerger.class);

    private GroupPermissionMerger() {
    }

    public static void handleCorruptGroupPermissions(CorruptPermission[] corruptPermissions, Connection con) throws SQLException {
        boolean[] delete = new boolean[1];
        for (CorruptPermission corruptPermission : corruptPermissions) {
            Permission merged;
            int admin = MergerUtility.getContextAdminID(corruptPermission.cid, con);
            delete[0] = false;
            try {
                merged = MergerUtility.getMergedPermission(corruptPermission.permission_id, admin, corruptPermission.fuid, corruptPermission.cid, con, delete);
            }
            catch (IllegalStateException e) {
                continue;
            }
            if (delete[0]) {
                MergerUtility.deletePermission(corruptPermission.permission_id, corruptPermission.fuid, corruptPermission.cid, con);
                LOG.info("Permission deleted for group {} on folder {} in context {}", new Object[]{corruptPermission.permission_id, corruptPermission.fuid, corruptPermission.cid});
                MergerUtility.updatePermission(merged, admin, admin, corruptPermission.fuid, corruptPermission.cid, con);
                LOG.info("...and merged to context admin: {}", (Object)merged);
                continue;
            }
            MergerUtility.updatePermission(merged, corruptPermission.permission_id, admin, corruptPermission.fuid, corruptPermission.cid, con);
            LOG.info("Permission re-assigned to context admin: {}", (Object)merged);
        }
    }
}

