/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.config.ConfigurationService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OXFolderSQL {
    private static final Logger LOG = LoggerFactory.getLogger(OXFolderSQL.class);
    private static final int UPDATE_CHUNK_SIZE = 100;
    private static final String SQL_LOCK = "SELECT fuid FROM oxfolder_tree WHERE cid=? AND fuid=? FOR UPDATE";
    private static final String SQL_LOCK_BACKUP = "SELECT fuid FROM del_oxfolder_tree WHERE cid=? AND fuid=? FOR UPDATE";
    private static final String SQL_SELECT_WITH_NON_EXISTING_PARENT = "SELECT ot1.fuid FROM oxfolder_tree AS ot1 where ot1.cid = ? AND ot1.parent <> 0 AND NOT EXISTS (SELECT ot2.fuid FROM oxfolder_tree AS ot2 where ot2.cid = ? AND ot1.parent = ot2.fuid)";
    private static final String SQL_SELECT_ADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_DEFAULTFLD = "SELECT ot.fuid FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.created_from = ? AND ot.module = ? AND ot.default_flag = 1";
    private static final String SQL_DEFAULTFLDTYPE = "SELECT ot.fuid FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.created_from = ? AND ot.module = ? AND ot.type = ? AND ot.default_flag = 1";
    private static final String SQL_SELECT_ALL_SHARED_FLDS = "SELECT ot.fuid FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.type = ? AND ot.created_from = ? AND (SELECT COUNT(op.permission_id) FROM oxfolder_permissions AS op WHERE op.cid = ot.cid AND op.fuid = ot.fuid) > 1 GROUP BY ot.fuid";
    private static final String SQL_UPDATE_LAST_MOD = "UPDATE oxfolder_tree SET changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_LAST_MOD2 = "UPDATE oxfolder_tree SET changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_NAME = "UPDATE oxfolder_tree SET fname = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_LOOKUPFOLDER = "SELECT fuid,fname FROM oxfolder_tree WHERE cid=? AND parent=? AND fname=? AND module=?";
    private static final String SQL_UPDATE_PERMS = "UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, odp = ? WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_ADD_PERMS = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, group_flag, fp, orp, owp, odp, admin_flag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_REM_SINGLE_SYS_PERM = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ? AND system = 1";
    private static final String SQL_REM_ALL_SYS_PERM = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND system = 1";
    private static final String SQL_GETSUBFLDIDS = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?";
    private static final String SQL_UDTSUBFLDFLG = "UPDATE oxfolder_tree SET subfolder_flag = ?, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_NUMSUB = "SELECT COUNT(ot.fuid) FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? WHERE op.permission_id IN #IDS# AND op.admin_flag > 0 AND ot.parent = ?";
    private static final String SQL_INSERT_NEW_FOLDER = "INSERT INTO oxfolder_tree (fuid, cid, parent, fname, module, type, creating_date, created_from, changing_date, changed_from, permission_flag, subfolder_flag, default_flag) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_NEW_PERMISSIONS = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE_PARENT_SUBFOLDER_FLAG = "UPDATE oxfolder_tree SET subfolder_flag = 1, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_EXISTING_PERMISSIONS = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND system = 0";
    private static final String SQL_MOVE_UPDATE = "UPDATE oxfolder_tree SET parent=?,changing_date=?,changed_from=?,fname=? WHERE cid=? AND fuid=? AND NOT EXISTS (SELECT 1 FROM (SELECT fname,fuid FROM oxfolder_tree WHERE cid=? AND parent=? AND parent>?) AS ft WHERE ft.fname=? AND ft.fuid<>?);";
    private static final String SQL_MOVE_SELECT = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?";
    private static final String SQL_MOVE_UPDATE2 = "UPDATE oxfolder_tree SET subfolder_flag = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_RENAME_UPDATE = "UPDATE oxfolder_tree SET fname = ?, changing_date = ?, changed_from = ? where cid = ? AND fuid = ?";
    private static final String STR_OXFOLDERTREE = "oxfolder_tree";
    private static final String STR_OXFOLDERPERMS = "oxfolder_permissions";
    private static final String STR_DELOXFOLDERTREE = "del_oxfolder_tree";
    private static final String STR_DELOXFOLDERPERMS = "del_oxfolder_permissions";
    private static final String SQL_DELETE_INSERT_OT = "INSERT INTO del_oxfolder_tree (cid, fuid, parent, module, type, creating_date, created_from, changing_date, changed_from, permission_flag, subfolder_flag, default_flag) SELECT oxfolder_tree.cid, oxfolder_tree.fuid, oxfolder_tree.parent, oxfolder_tree.module, oxfolder_tree.type, oxfolder_tree.creating_date, oxfolder_tree.created_from, oxfolder_tree.changing_date, oxfolder_tree.changed_from, oxfolder_tree.permission_flag, oxfolder_tree.subfolder_flag, oxfolder_tree.default_flag FROM oxfolder_tree WHERE oxfolder_tree.cid = ? AND oxfolder_tree.fuid = ?";
    private static final String SQL_DELETE_INSERT_OP = "INSERT INTO del_oxfolder_permissions SELECT * FROM oxfolder_permissions WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_DELETE_SF = "DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_DELETE = "DELETE FROM #TABLE# WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_UPDATE = "UPDATE del_oxfolder_tree SET changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_RESTORE_OT = "INSERT INTO oxfolder_tree SELECT * FROM del_oxfolder_tree WHERE cid = ? AND fuid = ?";
    private static final String SQL_RESTORE_OP = "INSERT INTO oxfolder_permissions SELECT * FROM del_oxfolder_permissions WHERE cid = ? AND fuid = ?";
    private static final String TMPL_FOLDER_TABLE = "#FOLDER#";
    private static final String TMPL_PERM_TABLE = "#PERM#";
    private static final String TMPL_IDS = "#IDS#";
    private static final String SQL_DROP_SYS_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND permission_id = ? AND system > 0";
    private static final String SQL_GET_CONTEXT_MAILADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_SEL_PERMS = "SELECT ot.fuid, ot.type, ot.module, ot.default_flag FROM #PERM# AS op JOIN #FOLDER# AS ot ON op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? WHERE op.permission_id IN #IDS# GROUP BY ot.fuid";
    private static final String SQL_DELETE_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_REASSIGN_PERMS = "UPDATE #PERM# SET permission_id = ?, group_flag = 0 WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_REASSIGN_UPDATE_TIMESTAMP = "UPDATE #FOLDER# SET changed_from = ?, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_DEL_PERM = "DELETE FROM #PERM# WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_REASSIGN_UPDATE_PERM = "UPDATE #PERM# SET fp = ?, orp = ?, owp = ?, odp = ?, admin_flag = ?, group_flag = ? WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_REASSIGN_SEL_PERM = "SELECT fp, orp, owp, odp, admin_flag FROM #PERM# WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_SEL_FOLDERS = "SELECT ot.fuid, ot.type, ot.module, ot.default_flag FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.created_from = ?";
    private static final String SQL_SEL_FOLDERS2 = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.changed_from = ?";
    private static final String SQL_DELETE_FOLDER = "DELETE FROM #FOLDER# WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_SPECIAL_REFS = "DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_FOLDER_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_FOLDERS = "UPDATE #FOLDER# SET created_from = ?, changed_from = ?, changing_date = ?, default_flag = 0 WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_FOLDERS_WITH_NAME = "UPDATE #FOLDER# SET created_from = ?, changed_from = ?, changing_date = ?, default_flag = 0, fname = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_DEF_INF = "SELECT fname FROM #FOLDER# WHERE cid = ? AND fuid = ? AND module = ? AND created_from = ? AND default_flag = 1";

    private OXFolderSQL() {
    }

    public static void lock(int folderId, int contextId, Connection con) throws SQLException {
        OXFolderSQL.lock(folderId, contextId, false, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock(int folderId, int contextId, boolean backupTable, Connection con) throws SQLException {
        if (null == con) {
            return;
        }
        PreparedStatement stmt = null;
        try {
            if (con.getAutoCommit()) {
                throw new SQLException("Connection is not in transaction state.");
            }
            stmt = con.prepareStatement(SQL_LOCK);
            stmt.setInt(1, contextId);
            stmt.setInt(2, folderId);
            stmt.executeQuery();
            if (backupTable) {
                DBUtils.closeSQLStuff(stmt);
                stmt = con.prepareStatement(SQL_LOCK_BACKUP);
                stmt.setInt(1, contextId);
                stmt.setInt(2, folderId);
                stmt.executeQuery();
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getNonExistingParents(Context ctx) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            int[] nArray = OXFolderSQL.getNonExistingParents(ctx, con);
            return nArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    public static int[] getNonExistingParents(Context ctx, Connection con) throws OXException {
        int[] nArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_WITH_NON_EXISTING_PARENT);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet set = new TIntHashSet(16);
            while (rs.next()) {
                set.add(rs.getInt(1));
            }
            nArray = set.toArray();
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getContextAdminID(Context ctx, Connection readConArg) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block4: {
            int n;
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
                stmt.setInt(1, ctx.getContextId());
                rs = OXFolderSQL.executeQuery(stmt);
                if (rs.next()) break block4;
                n = -1;
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = rs.getInt(1);
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUserDefaultFolder(int userId, int module, Connection readCon, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block4: {
            int n;
            rc = readCon;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (rc == null) {
                    rc = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = rc.prepareStatement(SQL_DEFAULTFLD);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                stmt.setInt(3, module);
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUserDefaultFolder(int userId, int module, int type, Connection readCon, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block4: {
            int n;
            rc = readCon;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (rc == null) {
                    rc = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = rc.prepareStatement(SQL_DEFAULTFLDTYPE);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                stmt.setInt(3, module);
                stmt.setInt(4, type);
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntCollection getSharedFoldersOf(int owner, Connection readConArg, Context ctx) throws OXException, SQLException {
        TIntArrayList tIntArrayList;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block5: {
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SELECT_ALL_SHARED_FLDS);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, 1);
            stmt.setInt(3, owner);
            rs = OXFolderSQL.executeQuery(stmt);
            if (rs.next()) break block5;
            TIntArrayList tIntArrayList2 = new TIntArrayList(0);
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            return tIntArrayList2;
        }
        try {
            TIntArrayList sia = new TIntArrayList(16);
            do {
                sia.add(rs.getInt(1));
            } while (rs.next());
            tIntArrayList = sia;
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return tIntArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateLastModified(int folderId, long lastModified, int modifiedBy, Connection writeConArg, Context ctx) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection writeCon;
        block6: {
            writeCon = writeConArg;
            closeWriteCon = false;
            stmt = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderId, ctx.getContextId(), writeCon);
                stmt = writeCon.prepareStatement(SQL_UPDATE_LAST_MOD);
                stmt.setLong(1, lastModified);
                stmt.setInt(2, modifiedBy);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, folderId);
                OXFolderSQL.executeUpdate(stmt);
                if (startedTransaction) {
                    writeCon.commit();
                    rollback = false;
                    writeCon.setAutoCommit(true);
                }
                if (!startedTransaction || !rollback || null == writeCon) break block6;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != writeCon) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                DBUtils.closeResources(null, stmt, closeWriteCon ? writeCon : null, false, ctx);
                throw throwable;
            }
            writeCon.rollback();
            writeCon.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateLastModified(int folderId, long lastModified, Connection writeConArg, Context ctx) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection writeCon;
        block6: {
            writeCon = writeConArg;
            closeWriteCon = false;
            stmt = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderId, ctx.getContextId(), writeCon);
                stmt = writeCon.prepareStatement(SQL_UPDATE_LAST_MOD2);
                stmt.setLong(1, lastModified);
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, folderId);
                OXFolderSQL.executeUpdate(stmt);
                if (startedTransaction) {
                    writeCon.commit();
                    rollback = false;
                    writeCon.setAutoCommit(true);
                }
                if (!startedTransaction || !rollback || null == writeCon) break block6;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != writeCon) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                DBUtils.closeResources(null, stmt, closeWriteCon ? writeCon : null, false, ctx);
                throw throwable;
            }
            writeCon.rollback();
            writeCon.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
    }

    public static int updateFolderType(Connection writeConnection, Context context, int type, List<Integer> folderIDs) throws OXException, SQLException {
        return OXFolderSQL.updateFolderType(writeConnection, context, type, 0, folderIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateFolderType(Connection writeConnection, Context context, int type, int optNewOwner, List<Integer> folderIDs) throws OXException, SQLException {
        if (null == folderIDs || 0 == folderIDs.size()) {
            return 0;
        }
        int updated = 0;
        boolean closeWriteConnection = false;
        boolean rollback = false;
        boolean startedTransaction = false;
        try {
            if (null == writeConnection) {
                writeConnection = DBPool.pickupWriteable(context);
                closeWriteConnection = true;
            }
            if (startedTransaction = writeConnection.getAutoCommit()) {
                writeConnection.setAutoCommit(false);
                rollback = true;
            }
            for (int i = 0; i < folderIDs.size(); i += 100) {
                int length = Math.min(folderIDs.size(), i + 100) - i;
                List<Integer> ids = folderIDs.subList(i, i + length);
                StringBuilder stringBuilder = new StringBuilder("UPDATE oxfolder_tree SET type=?");
                if (optNewOwner > 0) {
                    stringBuilder.append(", created_from=?");
                }
                stringBuilder.append(" WHERE cid=? AND fuid");
                if (1 == ids.size()) {
                    stringBuilder.append("=?;");
                } else {
                    stringBuilder.append(" IN (?");
                    for (int j = 1; j < ids.size(); ++j) {
                        stringBuilder.append(",?");
                    }
                    stringBuilder.append(");");
                }
                PreparedStatement stmt = null;
                try {
                    stmt = writeConnection.prepareStatement(stringBuilder.toString());
                    int pos = 0;
                    stmt.setInt(++pos, type);
                    if (optNewOwner > 0) {
                        stmt.setInt(++pos, optNewOwner);
                    }
                    stmt.setInt(++pos, context.getContextId());
                    int off = ++pos;
                    for (int j = 0; j < ids.size(); ++j) {
                        stmt.setInt(j + off, ids.get(j));
                    }
                    updated += OXFolderSQL.executeUpdate(stmt);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(stmt);
            }
            if (startedTransaction) {
                writeConnection.commit();
                rollback = false;
                writeConnection.setAutoCommit(true);
            }
        }
        finally {
            if (startedTransaction && rollback && null != writeConnection) {
                writeConnection.rollback();
                writeConnection.setAutoCommit(true);
            }
            if (closeWriteConnection) {
                DBPool.closeWriterSilent(context, writeConnection);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateFolderOwner(Connection writeConnection, Context context, int newOwner, List<Integer> folderIDs) throws OXException, SQLException {
        if (null == folderIDs || 0 == folderIDs.size()) {
            return 0;
        }
        int updated = 0;
        boolean closeWriteConnection = false;
        boolean rollback = false;
        boolean startedTransaction = false;
        try {
            if (null == writeConnection) {
                writeConnection = DBPool.pickupWriteable(context);
                closeWriteConnection = true;
            }
            if (startedTransaction = writeConnection.getAutoCommit()) {
                writeConnection.setAutoCommit(false);
                rollback = true;
            }
            for (int i = 0; i < folderIDs.size(); i += 100) {
                int length = Math.min(folderIDs.size(), i + 100) - i;
                List<Integer> ids = folderIDs.subList(i, i + length);
                StringBuilder stringBuilder = new StringBuilder("UPDATE oxfolder_tree SET created_from=? WHERE cid=? AND fuid");
                if (1 == ids.size()) {
                    stringBuilder.append("=?;");
                } else {
                    stringBuilder.append(" IN (?");
                    for (int j = 1; j < ids.size(); ++j) {
                        stringBuilder.append(",?");
                    }
                    stringBuilder.append(");");
                }
                PreparedStatement stmt = null;
                try {
                    stmt = writeConnection.prepareStatement(stringBuilder.toString());
                    int pos = 0;
                    stmt.setInt(++pos, newOwner);
                    stmt.setInt(++pos, context.getContextId());
                    int off = ++pos;
                    for (int j = 0; j < ids.size(); ++j) {
                        stmt.setInt(j + off, ids.get(j));
                    }
                    updated += OXFolderSQL.executeUpdate(stmt);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(stmt);
            }
            if (startedTransaction) {
                writeConnection.commit();
                rollback = false;
                writeConnection.setAutoCommit(true);
            }
        }
        finally {
            if (startedTransaction && rollback && null != writeConnection) {
                writeConnection.rollback();
                writeConnection.setAutoCommit(true);
            }
            if (closeWriteConnection) {
                DBPool.closeWriterSilent(context, writeConnection);
            }
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void updateName(int folderId, String newName, long lastModified, int modifiedBy, Connection writeConArg, Context ctx) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection writeCon;
        block6: {
            writeCon = writeConArg;
            closeWriteCon = false;
            stmt = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderId, ctx.getContextId(), writeCon);
                stmt = writeCon.prepareStatement(SQL_UPDATE_NAME);
                stmt.setString(1, newName);
                stmt.setLong(2, lastModified);
                stmt.setInt(3, modifiedBy);
                stmt.setInt(4, ctx.getContextId());
                stmt.setInt(5, folderId);
                OXFolderSQL.executeUpdate(stmt);
                if (startedTransaction) {
                    writeCon.commit();
                    rollback = false;
                    writeCon.setAutoCommit(true);
                }
                if (!startedTransaction || !rollback || null == writeCon) break block6;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != writeCon) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                DBUtils.closeResources(null, stmt, closeWriteCon ? writeCon : null, false, ctx);
                throw throwable;
            }
            writeCon.rollback();
            writeCon.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntList lookUpFolders(int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        TIntLinkedList folderList = new TIntLinkedList();
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_LOOKUPFOLDER);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, parent);
            stmt.setString(3, folderName);
            stmt.setInt(4, module);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                int fuid = rs.getInt(1);
                String fname = rs.getString(2);
                if (!Strings.equalsNormalizedIgnoreCase((String)folderName, (String)fname)) continue;
                folderList.add(fuid);
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return folderList;
    }

    public static int lookUpFolder(int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        return OXFolderSQL.lookUpFolderOnUpdate(-1, parent, folderName, module, readConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int lookUpFolderOnUpdate(int folderId, int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        int n;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ConfigurationService service;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            StringBuilder stmtBuilder = new StringBuilder("SELECT fuid,fname FROM oxfolder_tree WHERE cid=? AND parent=? AND fname=?");
            if (module > 0 && null != (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)) && service.getBoolProperty("com.openexchange.oxfolder.considerModuleOnDuplicateCheck", false)) {
                stmtBuilder.append(" AND module=").append(module);
            }
            if (folderId > 0) {
                stmtBuilder.append(" AND fuid!=").append(folderId);
            }
            stmt = readCon.prepareStatement(stmtBuilder.toString());
            stmtBuilder = null;
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, parent);
            stmt.setString(3, folderName);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                int fuid = rs.getInt(1);
                String fname = rs.getString(2);
                if (!Strings.equalsNormalizedIgnoreCase((String)folderName, (String)fname)) break block7;
                n = fuid;
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        {
            block7: {
                return n;
            }
            continue;
        }
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(int folderId, Connection readConArg, Context ctx) throws OXException, SQLException {
        boolean bl;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement("SELECT 1 FROM oxfolder_tree WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            bl = rs.next();
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(int folderId, Connection readConArg, Context ctx, String table) throws OXException, SQLException {
        boolean bl;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(new StringBuilder(40).append("SELECT 1 FROM ").append(table).append(" WHERE cid = ? AND fuid = ?").toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            bl = rs.next();
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSinglePermission(int folderId, int permissionId, int folderPermission, int objectReadPermission, int objectWritePermission, int objectDeletePermission, Connection writeCon, Context ctx) throws OXException, SQLException {
        boolean bl;
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection wc;
        block10: {
            boolean startedTransaction;
            boolean rollback;
            block8: {
                boolean bl2;
                block9: {
                    wc = writeCon;
                    closeWriteCon = false;
                    stmt = null;
                    rollback = false;
                    startedTransaction = false;
                    try {
                        boolean failed;
                        if (wc == null) {
                            wc = DBPool.pickupWriteable(ctx);
                            closeWriteCon = true;
                        }
                        if (startedTransaction = wc.getAutoCommit()) {
                            wc.setAutoCommit(false);
                            rollback = true;
                        }
                        OXFolderSQL.lock(folderId, ctx.getContextId(), wc);
                        stmt = wc.prepareStatement(SQL_UPDATE_PERMS);
                        int pos = 1;
                        stmt.setInt(pos++, folderPermission);
                        stmt.setInt(pos++, objectReadPermission);
                        stmt.setInt(pos++, objectWritePermission);
                        stmt.setInt(pos++, objectDeletePermission);
                        stmt.setInt(pos++, ctx.getContextId());
                        stmt.setInt(pos++, folderId);
                        stmt.setInt(pos++, permissionId);
                        boolean bl3 = failed = OXFolderSQL.executeUpdate(stmt) != 1;
                        if (!failed) break block8;
                        if (startedTransaction) {
                            wc.commit();
                            rollback = false;
                            wc.setAutoCommit(true);
                        }
                        bl2 = false;
                        if (!startedTransaction || !rollback || null == wc) break block9;
                    }
                    catch (Throwable throwable) {
                        if (startedTransaction && rollback && null != wc) {
                            wc.rollback();
                            wc.setAutoCommit(true);
                        }
                        DBUtils.closeResources(null, stmt, closeWriteCon ? wc : null, false, ctx);
                        throw throwable;
                    }
                    wc.rollback();
                    wc.setAutoCommit(true);
                }
                DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
                return bl2;
            }
            DBUtils.closeSQLStuff(null, stmt);
            stmt = null;
            OXFolderSQL.updateLastModified(folderId, System.currentTimeMillis(), wc, ctx);
            if (startedTransaction) {
                wc.commit();
                rollback = false;
                wc.setAutoCommit(true);
            }
            bl = true;
            if (!startedTransaction || !rollback || null == wc) break block10;
            wc.rollback();
            wc.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSinglePermission(int folderId, int permissionId, boolean isGroup, int folderPermission, int objectReadPermission, int objectWritePermission, int objectDeletePermission, boolean isAdmin, int system, Connection writeCon, Context ctx) throws OXException, SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection wc;
        block8: {
            wc = writeCon;
            closeWriteCon = false;
            stmt = null;
            rs = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                boolean success;
                if (wc == null) {
                    wc = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (startedTransaction = wc.getAutoCommit()) {
                    wc.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderId, ctx.getContextId(), wc);
                stmt = wc.prepareStatement("SELECT 1 FROM oxfolder_permissions WHERE cid=? AND permission_id=? AND fuid=? AND system=?");
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, permissionId);
                stmt.setInt(pos++, folderId);
                stmt.setInt(pos++, system);
                rs = stmt.executeQuery();
                boolean alreadyExists = rs.next();
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = null;
                if (alreadyExists) {
                    success = true;
                } else {
                    stmt = wc.prepareStatement(SQL_ADD_PERMS);
                    pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderId);
                    stmt.setInt(pos++, permissionId);
                    stmt.setInt(pos++, isGroup ? 1 : 0);
                    stmt.setInt(pos++, folderPermission);
                    stmt.setInt(pos++, objectReadPermission);
                    stmt.setInt(pos++, objectWritePermission);
                    stmt.setInt(pos++, objectDeletePermission);
                    stmt.setInt(pos++, isAdmin ? 1 : 0);
                    stmt.setInt(pos++, system);
                    boolean bl2 = success = OXFolderSQL.executeUpdate(stmt) == 1;
                }
                if (startedTransaction) {
                    wc.commit();
                    rollback = false;
                    wc.setAutoCommit(true);
                }
                bl = success;
                if (!startedTransaction || !rollback || null == wc) break block8;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != wc) {
                    wc.rollback();
                    wc.setAutoCommit(true);
                }
                DBUtils.closeResources(rs, stmt, closeWriteCon ? wc : null, false, ctx);
                throw throwable;
            }
            wc.rollback();
            wc.setAutoCommit(true);
        }
        DBUtils.closeResources(rs, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteSingleSystemPermission(int folderId, int permissionId, Connection writeCon, Context ctx) throws OXException, SQLException {
        boolean bl;
        Connection wc = writeCon;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = wc.prepareStatement(SQL_REM_SINGLE_SYS_PERM);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, permissionId);
            bl = OXFolderSQL.executeUpdate(stmt) == 1;
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllSystemPermission(int folderId, Connection writeCon, Context ctx) throws OXException, SQLException {
        Connection wc = writeCon;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = wc.prepareStatement(SQL_REM_ALL_SYS_PERM);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntList getSubfolderIDs(int folderId, Connection readConArg, Context ctx) throws OXException, SQLException {
        TIntArrayList retval = new TIntArrayList();
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                retval.add(rs.getInt(1));
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getSubfolderIDs(int folderId, Connection readConnection, Context context, boolean recursive) throws OXException, SQLException {
        ArrayList<Integer> subfolderIDs = new ArrayList<Integer>();
        boolean closeReadConnection = false;
        try {
            if (null == readConnection) {
                readConnection = DBPool.pickup(context);
                closeReadConnection = true;
            }
            ArrayList<Integer> parentFolderIDs = new ArrayList<Integer>();
            parentFolderIDs.add(folderId);
            do {
                StringBuilder stringBuilder = new StringBuilder("SELECT fuid FROM oxfolder_tree WHERE cid=? AND parent");
                if (1 == parentFolderIDs.size()) {
                    stringBuilder.append("=?;");
                } else {
                    stringBuilder.append(" IN (?");
                    for (int i = 1; i < parentFolderIDs.size(); ++i) {
                        stringBuilder.append(",?");
                    }
                    stringBuilder.append(");");
                }
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = readConnection.prepareStatement(stringBuilder.toString());
                    stmt.setInt(1, context.getContextId());
                    for (int i = 0; i < parentFolderIDs.size(); ++i) {
                        stmt.setInt(i + 2, (Integer)parentFolderIDs.get(i));
                    }
                    parentFolderIDs.clear();
                    rs = OXFolderSQL.executeQuery(stmt);
                    while (rs.next()) {
                        Integer folderID = rs.getInt(1);
                        subfolderIDs.add(folderID);
                        parentFolderIDs.add(folderID);
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
            } while (recursive && !parentFolderIDs.isEmpty());
            DBUtils.closeResources(null, null, closeReadConnection ? readConnection : null, true, context);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, null, closeReadConnection ? readConnection : null, true, context);
            throw throwable;
        }
        return subfolderIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getPermissionEntities(List<Integer> folderIDs, Connection readConnection, Context context, boolean includeGroups) throws OXException, SQLException {
        StringBuilder stringBuilder = new StringBuilder("SELECT DISTINCT permission_id FROM oxfolder_permissions WHERE cid=? AND fuid");
        if (1 == folderIDs.size()) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN (?");
            for (int i = 1; i < folderIDs.size(); ++i) {
                stringBuilder.append(",?");
            }
            stringBuilder.append(')');
        }
        if (!includeGroups) {
            stringBuilder.append(" AND group_flag=0");
        }
        ArrayList<Integer> entityIDs = new ArrayList<Integer>();
        boolean closeReadConnection = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (null == readConnection) {
                readConnection = DBPool.pickup(context);
                closeReadConnection = true;
            }
            stmt = readConnection.prepareStatement(stringBuilder.toString());
            stmt.setInt(1, context.getContextId());
            for (int i = 0; i < folderIDs.size(); ++i) {
                stmt.setInt(i + 2, folderIDs.get(i));
            }
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                entityIDs.add(rs.getInt(1));
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadConnection ? readConnection : null, true, context);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadConnection ? readConnection : null, true, context);
            throw throwable;
        }
        return entityIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getPathToRoot(int folderId, Connection readConnection, Context context) throws OXException, SQLException {
        ArrayList<Integer> subfolderIDs = new ArrayList<Integer>();
        boolean closeReadConnection = false;
        try {
            if (null == readConnection) {
                readConnection = DBPool.pickup(context);
                closeReadConnection = true;
            }
            int currentID = folderId;
            while (0 != currentID) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = readConnection.prepareStatement("SELECT parent FROM oxfolder_tree WHERE cid=? AND fuid=?;");
                    stmt.setInt(1, context.getContextId());
                    stmt.setInt(2, currentID);
                    rs = OXFolderSQL.executeQuery(stmt);
                    currentID = rs.next() ? Integer.valueOf(rs.getInt(1)) : 0;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
                subfolderIDs.add(currentID);
            }
            DBUtils.closeResources(null, null, closeReadConnection ? readConnection : null, true, context);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, null, closeReadConnection ? readConnection : null, true, context);
            throw throwable;
        }
        return subfolderIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getParentId(int folder, Context ctx) throws OXException, SQLException {
        Connection connection = DBPool.pickup(ctx);
        try {
            int n = OXFolderSQL.getParentId(folder, ctx, connection);
            return n;
        }
        finally {
            DBPool.closeReaderSilent(ctx, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getParentId(int folder, Context ctx, Connection connection) throws OXException, SQLException {
        int n;
        if (null == connection) {
            return OXFolderSQL.getParentId(folder, ctx);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement("SELECT parent FROM oxfolder_tree WHERE cid=? AND fuid=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folder);
            rs = stmt.executeQuery();
            n = rs.next() ? rs.getInt(1) : -1;
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return n;
    }

    public static String[] getFolderPath(int folder, Connection connection, Context ctx) throws OXException {
        ArrayList<String> folderPath = new ArrayList<String>();
        folderPath.add(String.valueOf(folder));
        int startID = folder;
        if (0 != startID) {
            try {
                List<Integer> pathToRoot = OXFolderSQL.getPathToRoot(startID, connection, ctx);
                for (Integer id : pathToRoot) {
                    folderPath.add(String.valueOf(id));
                }
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        return folderPath.toArray(new String[folderPath.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void updateSubfolderFlag(int folderId, boolean hasSubfolders, long lastModified, Connection writeConArg, Context ctx) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean closeCon;
        Connection writeCon;
        block6: {
            writeCon = writeConArg;
            closeCon = false;
            stmt = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderId, ctx.getContextId(), writeCon);
                stmt = writeCon.prepareStatement(SQL_UDTSUBFLDFLG);
                stmt.setInt(1, hasSubfolders ? 1 : 0);
                stmt.setLong(2, lastModified);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, folderId);
                OXFolderSQL.executeUpdate(stmt);
                if (startedTransaction) {
                    writeCon.commit();
                    rollback = false;
                    writeCon.setAutoCommit(true);
                }
                if (!startedTransaction || !rollback || null == writeCon) break block6;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != writeCon) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                DBUtils.closeResources(null, stmt, closeCon ? writeCon : null, false, ctx);
                throw throwable;
            }
            writeCon.rollback();
            writeCon.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumOfMoveableSubfolders(int folderId, int userId, int[] groups, Connection readConArg, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block3: {
            int n;
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement(SQL_NUMSUB.replaceFirst(TMPL_IDS, StringCollection.getSqlInString(userId, groups)));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, folderId);
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block3;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return 0;
    }

    static void insertFolderSQL(int newFolderID, int userId, FolderObject folder, long creatingTime, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.insertFolderSQL(newFolderID, userId, folder, creatingTime, false, ctx, writeConArg);
    }

    static void insertDefaultFolderSQL(int newFolderID, int userId, FolderObject folder, long creatingTime, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.insertFolderSQL(newFolderID, userId, folder, creatingTime, true, ctx, writeConArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFolderSQL(int newFolderID, int userId, FolderObject folder, long creatingTime, boolean acceptDefaultFlag, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        int permissionFlag = OXFolderSQL.determinePermissionFlag(folder);
        boolean closeWriteCon = false;
        try {
            boolean startedTransaction;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (startedTransaction = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            try {
                InputStream metaStream;
                block22: {
                    metaStream = null;
                    Statement stmt = null;
                    try {
                        OCLPermission[] permissions;
                        OXFolderSQL.lock(folder.getParentFolderID(), ctx.getContextId(), writeCon);
                        stmt = writeCon.prepareStatement("INSERT INTO oxfolder_tree (fuid,cid,parent,fname,module,type,creating_date,created_from,changing_date,changed_from,permission_flag,subfolder_flag,default_flag,meta) SELECT ?,?,?,?,?,?,?,?,?,?,?,?,?,? FROM DUAL WHERE NOT EXISTS (SELECT 1 FROM oxfolder_tree WHERE cid=? AND parent=? AND fname=? AND parent>?);");
                        stmt.setInt(1, newFolderID);
                        stmt.setInt(2, ctx.getContextId());
                        stmt.setInt(3, folder.getParentFolderID());
                        stmt.setString(4, folder.getFolderName());
                        stmt.setInt(5, folder.getModule());
                        stmt.setInt(6, folder.getType());
                        stmt.setLong(7, creatingTime);
                        stmt.setInt(8, folder.containsCreatedBy() ? folder.getCreatedBy() : userId);
                        stmt.setLong(9, creatingTime);
                        stmt.setInt(10, userId);
                        stmt.setInt(11, permissionFlag);
                        stmt.setInt(12, 0);
                        if (acceptDefaultFlag) {
                            stmt.setInt(13, folder.isDefaultFolder() ? 1 : 0);
                        } else {
                            stmt.setInt(13, 0);
                        }
                        metaStream = OXFolderUtility.serializeMeta(folder.getMeta());
                        if (null == metaStream) {
                            stmt.setNull(14, 2004);
                        } else {
                            stmt.setBinaryStream(14, metaStream);
                        }
                        stmt.setInt(15, ctx.getContextId());
                        stmt.setInt(16, folder.getParentFolderID());
                        stmt.setString(17, folder.getFolderName());
                        stmt.setInt(18, 20);
                        if (0 == OXFolderSQL.executeUpdate((PreparedStatement)stmt)) {
                            throw new SQLException("Entry not inserted");
                        }
                        stmt.close();
                        stmt = null;
                        stmt = writeCon.prepareStatement(SQL_UPDATE_PARENT_SUBFOLDER_FLAG);
                        stmt.setLong(1, creatingTime);
                        stmt.setInt(2, ctx.getContextId());
                        stmt.setInt(3, folder.getParentFolderID());
                        OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                        stmt.close();
                        stmt = null;
                        stmt = writeCon.prepareStatement(SQL_INSERT_NEW_PERMISSIONS);
                        for (OCLPermission ocl : permissions = folder.getNonSystemPermissionsAsArray()) {
                            stmt.setInt(1, ctx.getContextId());
                            stmt.setInt(2, newFolderID);
                            stmt.setInt(3, ocl.getEntity());
                            stmt.setInt(4, ocl.getFolderPermission());
                            stmt.setInt(5, ocl.getReadPermission());
                            stmt.setInt(6, ocl.getWritePermission());
                            stmt.setInt(7, ocl.getDeletePermission());
                            stmt.setInt(8, ocl.isFolderAdmin() ? 1 : 0);
                            stmt.setInt(9, ocl.isGroupPermission() ? 1 : 0);
                            stmt.addBatch();
                        }
                        OXFolderSQL.executeBatch((PreparedStatement)stmt);
                        stmt.close();
                        stmt = null;
                        Date creatingDate = new Date(creatingTime);
                        folder.setObjectID(newFolderID);
                        folder.setCreationDate(creatingDate);
                        folder.setCreatedBy(userId);
                        folder.setLastModified(creatingDate);
                        folder.setModifiedBy(userId);
                        folder.setSubfolderFlag(false);
                        if (!acceptDefaultFlag) {
                            folder.setDefaultFolder(false);
                        }
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        Streams.close(metaStream);
                        throw throwable;
                    }
                    stmt.close();
                    stmt = null;
                }
                Streams.close((Closeable)metaStream);
            }
            catch (SQLException e) {
                if (startedTransaction) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw e;
            }
            catch (JSONException e) {
                if (startedTransaction) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw OXFolderExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
            if (startedTransaction) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void markAsDefaultFolder(Connection connection, Context context, int folderID, int type, String folderName, long lastModified) throws SQLException, OXException {
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection writeCon;
        block6: {
            writeCon = connection;
            closeWriteCon = false;
            stmt = null;
            boolean rollback = false;
            boolean startedTransaction = false;
            try {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(context);
                    closeWriteCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                    rollback = true;
                }
                OXFolderSQL.lock(folderID, context.getContextId(), writeCon);
                stmt = writeCon.prepareStatement("UPDATE oxfolder_tree SET type=?,default_flag=1,fname=?,changing_date=? WHERE cid=? AND fuid=?;");
                stmt.setInt(1, type);
                stmt.setString(2, folderName);
                stmt.setLong(3, lastModified);
                stmt.setInt(4, context.getContextId());
                stmt.setInt(5, folderID);
                OXFolderSQL.executeUpdate(stmt);
                if (startedTransaction) {
                    writeCon.commit();
                    rollback = false;
                    writeCon.setAutoCommit(true);
                }
                if (!startedTransaction || !rollback || null == writeCon) break block6;
            }
            catch (Throwable throwable) {
                if (startedTransaction && rollback && null != writeCon) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                DBUtils.closeResources(null, stmt, closeWriteCon ? writeCon : null, false, context);
                throw throwable;
            }
            writeCon.rollback();
            writeCon.setAutoCommit(true);
        }
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void updateFolderSQL(int userId, FolderObject folder, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        int permissionFlag = OXFolderSQL.determinePermissionFlag(folder);
        boolean closeWriteCon = false;
        try {
            InputStream metaStream;
            boolean startedTransaction;
            block25: {
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (startedTransaction = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                }
                Statement stmt = null;
                metaStream = null;
                try {
                    OCLPermission[] permissions;
                    OXFolderSQL.lock(folder.getObjectID(), ctx.getContextId(), writeCon);
                    int pos = 1;
                    boolean containsMeta = folder.containsMeta();
                    boolean containsCreatedBy = folder.containsCreatedBy();
                    if (folder.containsFolderName()) {
                        stmt = writeCon.prepareStatement("UPDATE oxfolder_tree SET fname=?" + (containsMeta ? ",meta=?" : "") + ",changing_date=?,changed_from=?,permission_flag=?,module=?" + (containsCreatedBy ? ",created_from=?" : "") + " WHERE cid=? AND fuid=? AND NOT EXISTS (SELECT 1 FROM (" + "SELECT fname,fuid FROM oxfolder_tree WHERE cid=? AND parent=? AND parent>?) AS ft WHERE ft.fname=? AND ft.fuid<>?);");
                        stmt.setString(pos++, folder.getFolderName());
                        if (containsMeta) {
                            metaStream = OXFolderUtility.serializeMeta(folder.getMeta());
                            if (null == metaStream) {
                                stmt.setNull(pos++, 2004);
                            } else {
                                stmt.setBinaryStream(pos++, metaStream);
                            }
                        }
                        stmt.setLong(pos++, lastModified);
                        stmt.setInt(pos++, userId);
                        stmt.setInt(pos++, permissionFlag);
                        stmt.setInt(pos++, folder.getModule());
                        if (containsCreatedBy) {
                            stmt.setInt(pos++, folder.getCreatedBy());
                        }
                        stmt.setInt(pos++, ctx.getContextId());
                        stmt.setInt(pos++, folder.getObjectID());
                        stmt.setInt(pos++, ctx.getContextId());
                        stmt.setInt(pos++, folder.getParentFolderID());
                        stmt.setInt(pos++, 20);
                        stmt.setString(pos++, folder.getFolderName());
                        stmt.setInt(pos++, folder.getObjectID());
                        if (0 == OXFolderSQL.executeUpdate((PreparedStatement)stmt)) {
                            throw new SQLException("Entry not updated");
                        }
                        stmt.close();
                        stmt = null;
                    } else {
                        stmt = writeCon.prepareStatement("UPDATE oxfolder_tree SET " + (containsMeta ? "meta = ?, " : "") + "changing_date = ?, changed_from = ?, " + "permission_flag = ?, module = ? " + (containsCreatedBy ? ", created_from = ? " : "") + "WHERE cid = ? AND fuid = ?");
                        if (containsMeta) {
                            metaStream = OXFolderUtility.serializeMeta(folder.getMeta());
                            if (null == metaStream) {
                                stmt.setNull(pos++, 2004);
                            } else {
                                stmt.setBinaryStream(pos++, metaStream);
                            }
                        }
                        stmt.setLong(pos++, lastModified);
                        stmt.setInt(pos++, userId);
                        stmt.setInt(pos++, permissionFlag);
                        stmt.setInt(pos++, folder.getModule());
                        if (containsCreatedBy) {
                            stmt.setInt(pos++, folder.getCreatedBy());
                        }
                        stmt.setInt(pos++, ctx.getContextId());
                        stmt.setInt(pos++, folder.getObjectID());
                        OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                        stmt.close();
                        stmt = null;
                    }
                    stmt = writeCon.prepareStatement(SQL_DELETE_EXISTING_PERMISSIONS);
                    pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folder.getObjectID());
                    OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_INSERT_NEW_PERMISSIONS);
                    for (OCLPermission oclPerm : permissions = folder.getNonSystemPermissionsAsArray()) {
                        pos = 1;
                        stmt.setInt(pos++, ctx.getContextId());
                        stmt.setInt(pos++, folder.getObjectID());
                        stmt.setInt(pos++, oclPerm.getEntity());
                        stmt.setInt(pos++, oclPerm.getFolderPermission());
                        stmt.setInt(pos++, oclPerm.getReadPermission());
                        stmt.setInt(pos++, oclPerm.getWritePermission());
                        stmt.setInt(pos++, oclPerm.getDeletePermission());
                        stmt.setInt(pos++, oclPerm.isFolderAdmin() ? 1 : 0);
                        stmt.setInt(pos++, oclPerm.isGroupPermission() ? 1 : 0);
                        stmt.addBatch();
                    }
                    OXFolderSQL.executeBatch((PreparedStatement)stmt);
                    stmt.close();
                    stmt = null;
                    if (stmt == null) break block25;
                }
                catch (SQLException e) {
                    try {
                        if (!startedTransaction) throw e;
                        writeCon.rollback();
                        writeCon.setAutoCommit(true);
                        throw e;
                        catch (JSONException e2) {
                            if (startedTransaction) {
                                writeCon.rollback();
                                writeCon.setAutoCommit(true);
                            }
                            throw OXFolderExceptionCode.JSON_ERROR.create(e2, e2.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        Streams.close(metaStream);
                        throw throwable;
                    }
                }
                stmt.close();
                stmt = null;
            }
            Streams.close((Closeable)metaStream);
            if (!startedTransaction) return;
            writeCon.commit();
            writeCon.setAutoCommit(true);
            return;
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void moveFolderSQL(int userId, FolderObject src, FolderObject dest, long lastModified, Context ctx, Connection readConArg, Connection writeConArg) throws SQLException, OXException {
        ResultSet subFolderRS;
        PreparedStatement pst;
        boolean closeWriteCon;
        Connection writeCon;
        block11: {
            writeCon = writeConArg;
            closeWriteCon = false;
            Connection readCon = readConArg;
            pst = null;
            subFolderRS = null;
            try {
                boolean isAuto;
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (readCon == null) {
                    readCon = writeCon;
                }
                if (isAuto = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                }
                try {
                    int srcParentId = OXFolderSQL.getParentId(src.getObjectID(), ctx, writeCon);
                    int destParentId = OXFolderSQL.getParentId(dest.getObjectID(), ctx, writeCon);
                    OXFolderSQL.lock(srcParentId > 0 ? srcParentId : src.getObjectID(), ctx.getContextId(), writeCon);
                    OXFolderSQL.lock(destParentId > 0 ? destParentId : dest.getObjectID(), ctx.getContextId(), writeCon);
                    pst = writeCon.prepareStatement(SQL_MOVE_UPDATE);
                    pst.setInt(1, dest.getObjectID());
                    pst.setLong(2, lastModified);
                    pst.setInt(3, src.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setString(4, src.getFolderName());
                    pst.setInt(5, ctx.getContextId());
                    pst.setInt(6, src.getObjectID());
                    pst.setInt(7, ctx.getContextId());
                    pst.setInt(8, dest.getObjectID());
                    pst.setInt(9, dest.getObjectID());
                    pst.setString(10, src.getFolderName());
                    pst.setInt(11, src.getObjectID());
                    if (0 == OXFolderSQL.executeUpdate(pst)) {
                        throw new SQLException("Entry not updated");
                    }
                    pst.close();
                    pst = null;
                    pst = readCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?");
                    pst.setInt(1, ctx.getContextId());
                    pst.setInt(2, src.getParentFolderID());
                    subFolderRS = OXFolderSQL.executeQuery(pst);
                    boolean srcParentHasSubfolders = subFolderRS.next();
                    subFolderRS.close();
                    subFolderRS = null;
                    pst.close();
                    pst = null;
                    pst = writeCon.prepareStatement(SQL_MOVE_UPDATE2);
                    pst.setInt(1, 1);
                    pst.setLong(2, lastModified);
                    pst.setInt(3, dest.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setInt(4, ctx.getContextId());
                    pst.setInt(5, dest.getObjectID());
                    pst.addBatch();
                    pst.setInt(1, srcParentHasSubfolders ? 1 : 0);
                    pst.setLong(2, lastModified);
                    pst.setInt(3, src.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setInt(4, ctx.getContextId());
                    pst.setInt(5, src.getParentFolderID());
                    pst.addBatch();
                    OXFolderSQL.executeBatch(pst);
                    pst.close();
                    pst = null;
                }
                catch (SQLException se) {
                    if (isAuto) {
                        writeCon.rollback();
                        writeCon.setAutoCommit(true);
                    }
                    throw se;
                }
                if (!isAuto) break block11;
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(subFolderRS, pst);
                if (closeWriteCon && writeCon != null) {
                    DBPool.closeWriterSilent(ctx, writeCon);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(subFolderRS, pst);
        if (closeWriteCon && writeCon != null) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameFolderSQL(int userId, FolderObject folderObj, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        try {
            boolean isAuto;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            Statement pst = null;
            try {
                OXFolderSQL.lock(folderObj.getObjectID(), ctx.getContextId(), writeCon);
                pst = writeCon.prepareStatement(SQL_RENAME_UPDATE);
                pst.setString(1, folderObj.getFolderName());
                pst.setLong(2, lastModified);
                pst.setInt(3, userId);
                pst.setInt(4, ctx.getContextId());
                pst.setInt(5, folderObj.getObjectID());
                OXFolderSQL.executeUpdate((PreparedStatement)pst);
                pst.close();
                pst = null;
            }
            catch (SQLException sqle) {
                if (isAuto) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw sqle;
            }
            finally {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            if (isAuto) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    static void delWorkingOXFolder(int folderId, int userId, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.delOXFolder(folderId, userId, lastModified, true, true, ctx, writeConArg);
    }

    static void delOXFolder(int folderId, int userId, long lastModified, boolean deleteWorking, boolean createBackup, Context ctx, Connection writeConArg) throws SQLException, OXException {
        PreparedStatement stmt;
        boolean isAuto;
        boolean closeWriteCon;
        Connection writeCon;
        block14: {
            writeCon = writeConArg;
            closeWriteCon = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            String folderTable = deleteWorking ? STR_OXFOLDERTREE : STR_DELOXFOLDERTREE;
            String permTable = deleteWorking ? STR_OXFOLDERPERMS : STR_DELOXFOLDERPERMS;
            boolean backup = createBackup && deleteWorking;
            stmt = null;
            try {
                int parent = OXFolderSQL.getParentId(folderId, ctx, writeCon);
                OXFolderSQL.lock(parent > 0 ? parent : folderId, ctx.getContextId(), backup, writeCon);
                if (backup) {
                    stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OT);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OP);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                if (deleteWorking) {
                    stmt = writeCon.prepareStatement("DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?");
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", permTable));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", folderTable));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                if (backup) {
                    stmt = writeCon.prepareStatement(SQL_DELETE_UPDATE);
                    stmt.setLong(1, lastModified);
                    stmt.setInt(2, userId);
                    stmt.setInt(3, ctx.getContextId());
                    stmt.setInt(4, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                if (!isAuto) break block14;
                writeCon.commit();
            }
            catch (SQLException e) {
                try {
                    if (isAuto) {
                        DBUtils.rollback(writeCon);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    if (closeWriteCon) {
                        DBPool.closeWriterSilent(ctx, writeCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (isAuto) {
            DBUtils.autocommit(writeCon);
        }
        if (closeWriteCon) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    static void backupOXFolder(int folderId, int userId, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        PreparedStatement stmt;
        boolean isAuto;
        boolean closeWriteCon;
        Connection writeCon;
        block11: {
            writeCon = writeConArg;
            closeWriteCon = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            stmt = null;
            try {
                OXFolderSQL.lock(folderId, ctx.getContextId(), true, writeCon);
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OT);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OP);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_UPDATE);
                stmt.setLong(1, lastModified);
                stmt.setInt(2, userId);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                if (!isAuto) break block11;
                writeCon.commit();
            }
            catch (SQLException e) {
                try {
                    if (isAuto) {
                        DBUtils.rollback(writeCon);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    if (closeWriteCon) {
                        DBPool.closeWriterSilent(ctx, writeCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (isAuto) {
            DBUtils.autocommit(writeCon);
        }
        if (closeWriteCon) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    public static void restore(int folderId, Context ctx, Connection writeConArg) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean isAuto;
        boolean closeWriteCon;
        Connection writeCon;
        block11: {
            writeCon = writeConArg;
            closeWriteCon = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            stmt = null;
            try {
                OXFolderSQL.lock(folderId, ctx.getContextId(), true, writeCon);
                stmt = writeCon.prepareStatement(SQL_RESTORE_OT);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_RESTORE_OP);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                if (!isAuto) break block11;
                writeCon.commit();
            }
            catch (SQLException e) {
                try {
                    if (isAuto) {
                        DBUtils.rollback(writeCon);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    if (closeWriteCon) {
                        DBPool.closeWriterSilent(ctx, writeCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (isAuto) {
            DBUtils.autocommit(writeCon);
        }
        if (closeWriteCon) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    public static int getNextSerialForAdmin(Context ctx, Connection con) throws SQLException {
        return IDGenerator.getId(ctx, 20, con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void hardDeleteOXFolder(int folderId, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Statement stmt;
        boolean closeWrite;
        Connection writeCon;
        block10: {
            boolean isAuto;
            writeCon = writeConArg;
            closeWrite = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            stmt = null;
            try {
                String andClause = " AND fuid = ";
                stmt = writeCon.createStatement();
                stmt.addBatch("DELETE FROM oxfolder_specialfolders WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.addBatch("DELETE FROM oxfolder_permissions WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.addBatch("DELETE FROM oxfolder_tree WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.executeBatch();
                if (isAuto) {
                    writeCon.commit();
                }
                if (!isAuto) break block10;
            }
            catch (SQLException e) {
                try {
                    if (!isAuto) throw e;
                    writeCon.rollback();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    DBUtils.closeResources(null, stmt, closeWrite ? writeCon : null, false, ctx);
                    throw throwable;
                }
            }
            DBUtils.autocommit(writeCon);
        }
        DBUtils.closeResources(null, stmt, closeWrite ? writeCon : null, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanseSystemPermissions(int entity, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean createReadCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                createReadCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_DROP_SYS_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, createReadCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, createReadCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getContextMailAdmin(Connection readConArg, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean createReadCon;
        Connection readCon;
        block4: {
            int n;
            readCon = readConArg;
            createReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    createReadCon = true;
                }
                stmt = readCon.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
                stmt.setInt(1, ctx.getContextId());
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
        return n;
    }

    static void handleMailAdminPermissions(int mailAdmin, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityPermissions(mailAdmin, null, -1L, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    static void handleEntityPermissions(int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityPermissions(entity, (Integer)mailAdmin, lastModified, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityPermissions(int entity, Integer mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMailAdmin = mailAdmin == null;
        try {
            EventAdmin eventAdmin;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            String permissionsIDs = isMailAdmin ? "" + '(' + entity + ',' + 0 + ')' : "" + '(' + entity + ')';
            stmt = readCon.prepareStatement(SQL_SEL_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable).replaceFirst(TMPL_FOLDER_TABLE, folderTable).replaceFirst(TMPL_IDS, permissionsIDs));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet deletePerms = new TIntHashSet();
            TIntHashSet reassignPerms = new TIntHashSet();
            while (rs.next()) {
                boolean defaultFlag;
                int fuid = rs.getInt(1);
                int type = rs.getInt(2);
                int module = rs.getInt(3);
                boolean bl = defaultFlag = rs.getInt(4) > 0;
                if (isMailAdmin || OXFolderSQL.markForDeletion(type, module, defaultFlag)) {
                    deletePerms.add(fuid);
                    continue;
                }
                reassignPerms.add(fuid);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            OXFolderSQL.deletePermissions((TIntSet)deletePerms, entity, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignPermissions((TIntSet)reassignPerms, entity, mailAdmin, lastModified, folderTable, permTable, readCon, writeConArg, ctx);
            }
            ConditionTreeMapManagement.dropFor(ctx.getContextId());
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iter = deletePerms.iterator();
                    int i = deletePerms.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iter.next(), ctx);
                    }
                    iter = reassignPerms.iterator();
                    i = reassignPerms.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iter.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
                TIntIterator iter = deletePerms.iterator();
                int i = deletePerms.size();
                while (i-- > 0) {
                    OXFolderSQL.broadcastEvent(iter.next(), false, entity, ctx, eventAdmin, readCon);
                }
                iter = reassignPerms.iterator();
                i = reassignPerms.size();
                while (i-- > 0) {
                    OXFolderSQL.broadcastEvent(iter.next(), false, entity, ctx, eventAdmin, readCon);
                }
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
    }

    private static void broadcastEvent(int fuid, boolean deleted, int entity, Context ctx, EventAdmin eventAdmin, Connection readCon) throws OXException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
        ((Dictionary)properties).put("com.openexchange.folderstorage.context", ctx.getContextId());
        ((Dictionary)properties).put("com.openexchange.folderstorage.user", entity);
        ((Dictionary)properties).put("com.openexchange.folderstorage.folder", Integer.toString(fuid));
        ((Dictionary)properties).put("com.openexchange.folderstorage.content-related", !deleted);
        if (deleted) {
            String[] pathToRootString = OXFolderSQL.getFolderPath(fuid, readCon, ctx);
            ((Dictionary)properties).put("com.openexchange.folderstorage.folderPath", pathToRootString);
        }
        Event event = new Event("com/openexchange/folderstorage", properties);
        eventAdmin.sendEvent(event);
        LOG.debug("Notified content-related-wise changed folder \"{} in context {}", (Object)fuid, (Object)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePermissions(TIntSet deletePerms, int entity, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = deletePerms.size();
        if (size == 0) {
            return;
        }
        TIntIterator iter = deletePerms.iterator();
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            for (int i = 0; i < size; ++i) {
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, iter.next());
                stmt.setInt(3, entity);
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reassignPermissions(TIntSet reassignPerms, int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = reassignPerms.size();
        if (size == 0) {
            return;
        }
        Connection wc = writeConArg;
        boolean closeWrite = false;
        Connection rc = readConArg;
        boolean closeRead = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int i;
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            if (rc == null) {
                rc = DBPool.pickup(ctx);
                closeRead = true;
            }
            TIntIterator iter = reassignPerms.iterator();
            for (i = 0; i < size; ++i) {
                int fuid = iter.next();
                stmt = rc.prepareStatement("SELECT 1 FROM " + permTable + " WHERE cid = ? AND permission_id = ? AND fuid = ?");
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, mailAdmin);
                stmt.setInt(3, fuid);
                rs = OXFolderSQL.executeQuery(stmt);
                boolean hasPerm = rs.next();
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                if (hasPerm) {
                    try {
                        OCLPermission mergedPerm = OXFolderSQL.getMergedPermission(entity, mailAdmin, fuid, permTable, readConArg, ctx);
                        OXFolderSQL.deleteSingleEntityPermission(entity, fuid, permTable, wc, ctx);
                        OXFolderSQL.updateSingleEntityPermission(mergedPerm, mailAdmin, fuid, permTable, wc, ctx);
                    }
                    catch (Exception e) {
                        LOG.error("", (Throwable)e);
                    }
                    continue;
                }
                stmt = wc.prepareStatement(SQL_REASSIGN_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, fuid);
                stmt.setInt(4, entity);
                try {
                    OXFolderSQL.executeUpdate(stmt);
                    continue;
                }
                catch (SQLException e) {
                    LOG.error("", (Throwable)e);
                    continue;
                }
                finally {
                    stmt.close();
                }
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_UPDATE_TIMESTAMP.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            iter = reassignPerms.iterator();
            for (i = 0; i < size; ++i) {
                stmt.setInt(1, mailAdmin);
                stmt.setLong(2, lastModified);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, iter.next());
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(rs, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeWrite ? wc : null, false, ctx);
            if (closeRead && rc != null) {
                DBPool.closeReaderSilent(ctx, rc);
            }
            throw throwable;
        }
        if (closeRead && rc != null) {
            DBPool.closeReaderSilent(ctx, rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSingleEntityPermission(int entity, int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean close = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                close = true;
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_DEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            stmt.setInt(3, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSingleEntityPermission(OCLPermission mergedPerm, int mailAdmin, int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean close = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                close = true;
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_UPDATE_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, mergedPerm.getFolderPermission());
            stmt.setInt(2, mergedPerm.getReadPermission());
            stmt.setInt(3, mergedPerm.getWritePermission());
            stmt.setInt(4, mergedPerm.getDeletePermission());
            stmt.setInt(5, mergedPerm.isFolderAdmin() ? 1 : 0);
            stmt.setInt(6, mergedPerm.isGroupPermission() ? 1 : 0);
            stmt.setInt(7, ctx.getContextId());
            stmt.setInt(8, mailAdmin);
            stmt.setInt(9, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OCLPermission getMergedPermission(int entity, int mailAdmin, int fuid, String permTable, Connection readConArg, Context ctx) throws SQLException, OXException {
        OCLPermission adminPerm;
        ResultSet innerRs;
        PreparedStatement innerStmt;
        boolean closeRead;
        Connection readCon;
        block8: {
            block6: {
                block7: {
                    OCLPermission oCLPermission;
                    readCon = readConArg;
                    closeRead = false;
                    innerStmt = null;
                    innerRs = null;
                    try {
                        if (readCon == null) {
                            readCon = DBPool.pickup(ctx);
                            closeRead = true;
                        }
                        innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
                        innerStmt.setInt(1, ctx.getContextId());
                        innerStmt.setInt(2, mailAdmin);
                        innerStmt.setInt(3, fuid);
                        innerRs = OXFolderSQL.executeQuery(innerStmt);
                        if (innerRs.next()) break block6;
                        innerRs.close();
                        innerStmt.close();
                        innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
                        innerStmt.setInt(1, ctx.getContextId());
                        innerStmt.setInt(2, entity);
                        innerStmt.setInt(3, fuid);
                        innerRs = OXFolderSQL.executeQuery(innerStmt);
                        if (innerRs.next()) break block7;
                        oCLPermission = new OCLPermission(mailAdmin, fuid);
                        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                        throw throwable;
                    }
                    return oCLPermission;
                }
                OCLPermission adminPerm2 = new OCLPermission(mailAdmin, fuid);
                adminPerm2.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
                adminPerm2.setFolderAdmin(innerRs.getInt(5) > 0);
                adminPerm2.setGroupPermission(false);
                OCLPermission oCLPermission = adminPerm2;
                DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                return oCLPermission;
            }
            adminPerm = new OCLPermission(mailAdmin, fuid);
            adminPerm.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
            adminPerm.setFolderAdmin(innerRs.getInt(5) > 0);
            adminPerm.setGroupPermission(false);
            innerRs.close();
            innerStmt.close();
            innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            innerStmt.setInt(1, ctx.getContextId());
            innerStmt.setInt(2, entity);
            innerStmt.setInt(3, fuid);
            innerRs = OXFolderSQL.executeQuery(innerStmt);
            if (innerRs.next()) break block8;
            OCLPermission oCLPermission = adminPerm;
            DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
            return oCLPermission;
        }
        OCLPermission entityPerm = new OCLPermission(entity, fuid);
        entityPerm.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
        entityPerm.setFolderAdmin(innerRs.getInt(5) > 0);
        OCLPermission mergedPerm = new OCLPermission(mailAdmin, fuid);
        mergedPerm.setFolderPermission(Math.max(adminPerm.getFolderPermission(), entityPerm.getFolderPermission()));
        mergedPerm.setReadObjectPermission(Math.max(adminPerm.getReadPermission(), entityPerm.getReadPermission()));
        mergedPerm.setWriteObjectPermission(Math.max(adminPerm.getWritePermission(), entityPerm.getWritePermission()));
        mergedPerm.setDeleteObjectPermission(Math.max(adminPerm.getDeletePermission(), entityPerm.getDeletePermission()));
        mergedPerm.setFolderAdmin(adminPerm.isFolderAdmin() || entityPerm.isFolderAdmin());
        mergedPerm.setGroupPermission(false);
        OCLPermission oCLPermission = mergedPerm;
        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
        return oCLPermission;
    }

    static void handleMailAdminFolders(int mailAdmin, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityFolders(mailAdmin, null, -1L, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    static void handleEntityFolders(int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityFolders(entity, (Integer)mailAdmin, lastModified, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityFolders(int entity, Integer mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMailAdmin = mailAdmin == null;
        try {
            EventAdmin eventAdmin;
            int i;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SEL_FOLDERS.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet deleteFolders = new TIntHashSet();
            TIntHashSet reassignFolders = new TIntHashSet();
            while (rs.next()) {
                boolean defaultFlag;
                int fuid = rs.getInt(1);
                int type = rs.getInt(2);
                int module = rs.getInt(3);
                boolean bl = defaultFlag = rs.getInt(4) > 0;
                if (isMailAdmin || OXFolderSQL.markForDeletion(type, module, defaultFlag)) {
                    deleteFolders.add(fuid);
                    continue;
                }
                reassignFolders.add(fuid);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            OXFolderSQL.deleteFolders((TIntSet)deleteFolders, folderTable, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignFolders((TIntSet)reassignFolders, entity, mailAdmin, lastModified, folderTable, writeConArg, ctx);
            }
            ConditionTreeMapManagement.dropFor(ctx.getContextId());
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iterator = deleteFolders.iterator();
                    i = deleteFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                    iterator = reassignFolders.iterator();
                    i = reassignFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            stmt = readCon.prepareStatement(SQL_SEL_FOLDERS2.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            deleteFolders = new TIntHashSet();
            reassignFolders = new TIntHashSet();
            while (rs.next()) {
                int fuid = rs.getInt(1);
                if (isMailAdmin) {
                    deleteFolders.add(fuid);
                    continue;
                }
                reassignFolders.add(fuid);
            }
            OXFolderSQL.deleteFolders((TIntSet)deleteFolders, folderTable, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignFolders((TIntSet)reassignFolders, entity, mailAdmin, lastModified, folderTable, writeConArg, ctx);
            }
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iterator = deleteFolders.iterator();
                    i = deleteFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                    iterator = reassignFolders.iterator();
                    i = reassignFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
                TIntIterator iterator = deleteFolders.iterator();
                int i2 = deleteFolders.size();
                while (i2-- > 0) {
                    OXFolderSQL.broadcastEvent(iterator.next(), true, entity, ctx, eventAdmin, readCon);
                }
                iterator = reassignFolders.iterator();
                i2 = reassignFolders.size();
                while (i2-- > 0) {
                    OXFolderSQL.broadcastEvent(iterator.next(), false, entity, ctx, eventAdmin, readCon);
                }
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFolders(TIntSet deleteFolders, String folderTable, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = deleteFolders.size();
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            int fuid;
            int i;
            TIntIterator iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                OXFolderSQL.checkFolderPermissions(fuid, permTable, writeConArg, ctx);
            }
            iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                OXFolderSQL.deleteSpecialfoldersRefs(fuid, writeConArg, ctx);
            }
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_FOLDER.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, fuid);
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSpecialfoldersRefs(int fuid, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement("DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFolderPermissions(int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_FOLDER_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reassignFolders(TIntSet reassignFolders, int entity, int mailAdmin, long lastModified, String folderTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            int size = reassignFolders.size();
            TIntIterator iter = reassignFolders.iterator();
            boolean found = false;
            for (int i = 0; i < size && !found; ++i) {
                int fuid = iter.next();
                String fname = OXFolderSQL.isDefaultInfostoreFolder(fuid, entity, folderTable, wc, ctx);
                if (fname == null) continue;
                iter.remove();
                --size;
                stmt = wc.prepareStatement(SQL_REASSIGN_FOLDERS_WITH_NAME.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, mailAdmin);
                stmt.setLong(3, lastModified);
                stmt.setString(4, fname + fuid);
                stmt.setInt(5, ctx.getContextId());
                stmt.setInt(6, fuid);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                found = true;
            }
            iter = reassignFolders.iterator();
            stmt = wc.prepareStatement(SQL_REASSIGN_FOLDERS.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            for (int i = 0; i < size; ++i) {
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, mailAdmin);
                stmt.setLong(3, lastModified);
                stmt.setInt(4, ctx.getContextId());
                stmt.setInt(5, iter.next());
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String isDefaultInfostoreFolder(int fuid, int entity, String folderTable, Connection con, Context ctx) throws SQLException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_DEF_INF.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            stmt.setInt(3, 8);
            stmt.setInt(4, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
            throw throwable;
        }
        DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
        return string;
    }

    private static boolean markForDeletion(int type, int module, boolean defaultFlag) {
        return OXFolderSQL.isPrivate(type) || OXFolderSQL.isPersonalInfoStoreFolder(type, module, defaultFlag) || OXFolderSQL.isTrashInfoStoreFolder(type, module, defaultFlag);
    }

    private static boolean isTrashInfoStoreFolder(int type, int module, boolean defaultFlag) {
        return type == 16 && module == 8 && defaultFlag;
    }

    private static boolean isPersonalInfoStoreFolder(int type, int module, boolean defaultFlag) {
        return type == 2 && module == 8 && defaultFlag;
    }

    private static boolean isPrivate(int type) {
        return type == 1;
    }

    private static int executeUpdate(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error("\nFollowing SQL query contains syntax errors:\n{}", (Object)sql.substring(sql.indexOf(": ") + 2));
            }
            throw e;
        }
    }

    private static int[] executeBatch(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeBatch();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error("\nFollowing SQL query contains syntax errors:\n{}", (Object)sql.substring(sql.indexOf(": ") + 2));
            }
            throw e;
        }
    }

    private static ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error("\nFollowing SQL query contains syntax errors:\n{}", (Object)sql.substring(sql.indexOf(": ") + 2));
            }
            throw e;
        }
    }

    private static int determinePermissionFlag(FolderObject folder) {
        int permissionFlag;
        block3: {
            block2: {
                permissionFlag = 3;
                if (folder.getType() != 1) break block2;
                if (folder.getPermissions().size() != 1) break block3;
                permissionFlag = 1;
                break block3;
            }
            if (folder.getType() == 2) {
                int permissionsSize = folder.getPermissions().size();
                Iterator<OCLPermission> iter = folder.getPermissions().iterator();
                for (int i = 0; i < permissionsSize; ++i) {
                    OCLPermission oclPerm = iter.next();
                    if (oclPerm.getEntity() != 0 || oclPerm.getFolderPermission() <= 0) continue;
                    permissionFlag = 2;
                    break;
                }
            }
        }
        return permissionFlag;
    }
}

