/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.net;

import com.openexchange.tools.net.URIDefaults;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIParser {
    private static final Logger LOG = LoggerFactory.getLogger(URIParser.class);
    private static final Pattern IPV6_PATTERN = Pattern.compile("^(?:(?:([a-zA-Z][0-9a-zA-Z]*)://\\[)|\\[)?([0-9a-zA-Z:]*?)(?:\\]|(?:\\]:(.*)))?$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:([a-zA-Z][0-9a-zA-Z]*)://)?(.*?)(?::(.*))?$");

    private URIParser() {
    }

    public static URI parse(String input, URIDefaults defaults) throws URISyntaxException {
        if (null == input || 0 == input.length()) {
            return null;
        }
        Matcher matcher = IPV6_PATTERN.matcher(input);
        if (!matcher.matches() && !(matcher = IPV4_PATTERN.matcher(input)).matches()) {
            return new URI(input);
        }
        URIDefaults defs = null == defaults ? URIDefaults.NULL : defaults;
        int port = URIParser.parsePort(input, matcher.group(3), defs);
        String scheme = matcher.group(1);
        int usedPort = URIParser.applyDefault(port, scheme, defs);
        String usedScheme = URIParser.applyDefault(scheme, port, defs);
        return new URI(usedScheme, null, matcher.group(2), usedPort, null, null, null);
    }

    public static boolean isValid(String input) {
        int port;
        if (null == input || 0 == input.length()) {
            return false;
        }
        Matcher matcher = IPV6_PATTERN.matcher(input);
        if (!matcher.matches() && !(matcher = IPV4_PATTERN.matcher(input)).matches()) {
            try {
                new URI(input);
                return true;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        try {
            port = Integer.parseInt(matcher.group(3));
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (port < 0 || port > 65535) {
            return false;
        }
        try {
            new URI(matcher.group(1), null, matcher.group(2), port, null, null, null);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URI sanitize(String input, URIDefaults defaults) {
        if (null == input || 0 == input.length()) {
            return null;
        }
        try {
            Matcher matcher = IPV6_PATTERN.matcher(input);
            if (!matcher.matches() && !(matcher = IPV4_PATTERN.matcher(input)).matches()) {
                return null;
            }
            URIDefaults defs = null == defaults ? URIDefaults.NULL : defaults;
            int port = URIParser.parsePort(input, matcher.group(3), defs);
            String scheme = matcher.group(1);
            int usedPort = URIParser.applyDefault(port, scheme, defs);
            String usedScheme = URIParser.applyDefault(scheme, port, defs);
            try {
                return new URI(usedScheme, null, matcher.group(2), usedPort, null, null, null);
            }
            catch (URISyntaxException e) {
                return new URI(usedScheme, null, "localhost", usedPort, null, null, null);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Couldn't sanitize URI: {}", (Object)input, (Object)e);
            return null;
        }
    }

    private static int parsePort(String input, String port, URIDefaults defaults) throws URISyntaxException {
        if (null == port) {
            return -1;
        }
        try {
            int iPort = Integer.parseInt(port);
            if (iPort < 0 || iPort > 65535) {
                if (URIDefaults.NULL.equals(defaults)) {
                    throw new URISyntaxException(input, "A valid port value is between 0 and 65535, but is: " + port);
                }
                LOG.warn("Invalid port: {}", (Object)port);
                return defaults.getPort();
            }
            return iPort;
        }
        catch (NumberFormatException e) {
            if (URIDefaults.NULL.equals(defaults)) {
                throw new URISyntaxException(input, e.getMessage());
            }
            LOG.warn("Couldn't parse port", (Throwable)e);
            return defaults.getPort();
        }
    }

    private static int applyDefault(int port, String scheme, URIDefaults defaults) {
        if (-1 == port) {
            if (null != defaults.getSSLProtocol() && defaults.getSSLProtocol().equals(scheme)) {
                return defaults.getSSLPort();
            }
            return defaults.getPort();
        }
        return port;
    }

    private static String applyDefault(String scheme, int port, URIDefaults defaults) {
        if (null == scheme) {
            if (defaults.getSSLPort() == port) {
                return defaults.getSSLProtocol();
            }
            return defaults.getProtocol();
        }
        return scheme;
    }
}

