/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import com.openexchange.java.Charsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordUtil.class);
    private static final int KEY_LENGTH = 16;
    private static final String ALGORITHM = "AES";
    private static final String CIPHER_TYPE = "AES/CBC/PKCS5Padding";
    private static final IvParameterSpec iv = new IvParameterSpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});

    public static String encrypt(String password, String key) throws GeneralSecurityException {
        return PasswordUtil.encrypt(password, PasswordUtil.generateSecretKey(key));
    }

    public static String decrypt(String encryptedPassword, String key) throws GeneralSecurityException {
        return PasswordUtil.decrypt(encryptedPassword, PasswordUtil.generateSecretKey(key));
    }

    public static String encrypt(String password, Key key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(1, key, iv);
        byte[] outputBytes = cipher.doFinal(password.getBytes(Charsets.UTF_8));
        return Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])outputBytes));
    }

    public static String decrypt(String encryptedPassword, Key key) throws GeneralSecurityException {
        byte[] encrypted = Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)encryptedPassword));
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        cipher.init(2, key, iv);
        byte[] outputBytes = cipher.doFinal(encrypted);
        return new String(outputBytes, Charsets.UTF_8);
    }

    public static Key generateRandomKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        keyGenerator.init(new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey;
    }

    public static Key generateSecretKey(String key) {
        return new SecretKeySpec(PasswordUtil.ensureLength(key.getBytes(Charsets.UTF_8)), ALGORITHM);
    }

    private static byte[] ensureLength(byte[] bytes) {
        byte[] keyBytes;
        int len = bytes.length;
        if (len < 16) {
            keyBytes = new byte[16];
            System.arraycopy(bytes, 0, keyBytes, 0, len);
            for (int i = len; i < keyBytes.length; ++i) {
                keyBytes[i] = 48;
            }
        } else if (len > 16) {
            keyBytes = new byte[16];
            System.arraycopy(bytes, 0, keyBytes, 0, keyBytes.length);
        } else {
            keyBytes = bytes;
        }
        return keyBytes;
    }
}

