/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.spamhandler.osgi;

import com.openexchange.spamhandler.SpamHandler;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpamHandlerServiceTracker
implements ServiceTrackerCustomizer<SpamHandler, SpamHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(SpamHandlerServiceTracker.class);
    private final BundleContext context;

    public SpamHandlerServiceTracker(BundleContext context) {
        this.context = context;
    }

    public SpamHandler addingService(ServiceReference<SpamHandler> reference) {
        Object registrationName;
        SpamHandler addedService = (SpamHandler)this.context.getService(reference);
        if (null == addedService) {
            LOG.warn("Added service is null!", new Throwable());
        }
        if (null == (registrationName = reference.getProperty("name"))) {
            LOG.error("Missing registration name in spam handler service: {}", (Object)addedService.getClass().getName());
            return addedService;
        }
        if (SpamHandlerRegistry.registerSpamHandler(registrationName.toString(), addedService)) {
            LOG.info("Spam handler registered for name '{}", registrationName);
        } else {
            LOG.warn("Spam handler could not be registered for name '{}. Another spam handler has already been registered for the same name.", registrationName);
        }
        return addedService;
    }

    public void modifiedService(ServiceReference<SpamHandler> reference, SpamHandler service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<SpamHandler> reference, SpamHandler service) {
        try {
            SpamHandlerRegistry.unregisterSpamHandler(service);
        }
        finally {
            this.context.ungetService(reference);
        }
    }
}

