/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.spamhandler;

import com.openexchange.exception.OXException;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.session.Session;

public abstract class SpamHandler {
    public static final String SPAM_HANDLER_FALLBACK = "NoSpamHandler";
    protected static final String FULLNAME_INBOX = "INBOX";
    private final int hashCode = this.getSpamHandlerName().hashCode();

    protected SpamHandler() {
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpamHandler)) {
            return false;
        }
        SpamHandler other = (SpamHandler)obj;
        return !(this.getSpamHandlerName() == null ? other.getSpamHandlerName() != null : !this.getSpamHandlerName().equals(other.getSpamHandlerName()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public boolean isCreateConfirmedSpam() {
        return true;
    }

    public boolean isCreateConfirmedHam() {
        return true;
    }

    public boolean isUnsubscribeSpamFolders() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSpam(int accountId, String fullName, String[] mailIDs, boolean move, Session session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            if (this.isCreateConfirmedSpam()) {
                String confirmedSpamFullname = mailAccess.getFolderStorage().getConfirmedSpamFolder();
                mailAccess.getMessageStorage().copyMessages(fullName, confirmedSpamFullname, mailIDs, true);
            }
            if (move) {
                String spamFullname = mailAccess.getFolderStorage().getSpamFolder();
                mailAccess.getMessageStorage().moveMessages(fullName, spamFullname, mailIDs, true);
            }
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    public abstract String getSpamHandlerName();

    public abstract void handleHam(int var1, String var2, String[] var3, boolean var4, Session var5) throws OXException;
}

