/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi.inspector;

import com.openexchange.server.services.SessionInspector;
import com.openexchange.session.inspector.SessionInspectorChain;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInspectorChainCustomizer
implements ServiceTrackerCustomizer<SessionInspectorChain, SessionInspectorChain> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionInspectorChainCustomizer.class);
    private final BundleContext context;

    public SessionInspectorChainCustomizer(BundleContext context) {
        this.context = context;
    }

    public SessionInspectorChain addingService(ServiceReference<SessionInspectorChain> reference) {
        SessionInspectorChain auth = (SessionInspectorChain)this.context.getService(reference);
        if (SessionInspector.getInstance().setService(auth)) {
            return auth;
        }
        LOG.error("Several session inspector chains found. Remove all except one!");
        return null;
    }

    public void modifiedService(ServiceReference<SessionInspectorChain> reference, SessionInspectorChain service) {
    }

    public void removedService(ServiceReference<SessionInspectorChain> reference, SessionInspectorChain service) {
        if (!SessionInspector.getInstance().dropService(service)) {
            LOG.error("Removed session inspector chain was not active!");
        }
        this.context.ungetService(reference);
    }
}

