/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.impl.ConfigTree;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesCustomizer
implements ServiceTrackerCustomizer<PreferencesItemService, PreferencesItemService> {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesCustomizer.class);
    private final BundleContext context;

    public PreferencesCustomizer(BundleContext context) {
        this.context = context;
    }

    public PreferencesItemService addingService(ServiceReference<PreferencesItemService> reference) {
        PreferencesItemService item = (PreferencesItemService)this.context.getService(reference);
        try {
            ConfigTree.getInstance().addPreferencesItem(item);
        }
        catch (OXException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Can't add service for preferences item. Path: ");
            String[] path = item.getPath();
            for (int i = 0; i < path.length; ++i) {
                sb.append(path[i]);
                sb.append('/');
            }
            sb.setLength(sb.length() - 1);
            LOG.error(sb.toString(), (Throwable)e);
        }
        return item;
    }

    public void modifiedService(ServiceReference<PreferencesItemService> reference, PreferencesItemService service) {
    }

    public void removedService(ServiceReference<PreferencesItemService> reference, PreferencesItemService service) {
        PreferencesItemService item = service;
        ConfigTree.getInstance().removePreferencesItem(item);
        this.context.ungetService(reference);
    }
}

