/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.quota.json.actions.FilestoreAction;
import com.openexchange.quota.json.actions.GetAction;
import com.openexchange.quota.json.actions.MailAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;

@Module(name="quota", description="The quota module allows accesssing information about the use and quota of the filestore/mailstorage.")
public class QuotaActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(5, 0.9f, 1);

    public QuotaActionFactory(ServiceLookup services, BundleContext context) {
        GetAction getAction = new GetAction(context);
        this.actions.put("get", getAction);
        this.actions.put("GET", getAction);
        this.actions.put("filestore", new FilestoreAction(services));
        this.actions.put("mail", new MailAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

