/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="get", description="Get a mail account", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the account to return.")}, responseDescription="A JSON object representing the desired mail account. See mail account data.")
public final class GetAction
extends AbstractMailAccountAction
implements MailAccountFields {
    private static final Logger LOG = LoggerFactory.getLogger(GetAction.class);
    public static final String ACTION = "get";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jVoid) throws OXException {
        int id = GetAction.parseIntParameter("id", requestData);
        try {
            Map map;
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            MailAccount mailAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
            if (GetAction.isUnifiedINBOXAccount(mailAccount)) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), session.getContextId());
            }
            if (!session.getUserPermissionBits().isMultipleMailAccounts() && !GetAction.isDefaultMailAccount(mailAccount)) {
                throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
            }
            JSONObject jsonAccount = MailAccountWriter.write(mailAccount);
            JSlobId jSlobId = new JSlobId("com.openexchange.mailaccount", Integer.toString(id), session.getUserId(), session.getContextId());
            JSlob jSlob = GetAction.getStorage().opt(jSlobId);
            Map map2 = map = null == jSlob ? null : (Map)JSONCoercion.coerceToNative((JSONValue)jSlob.getJsonObject());
            if (map != null && !map.isEmpty()) {
                jsonAccount.put("meta", JSONCoercion.coerceToJSON(map));
            }
            return new AJAXRequestResult(jsonAccount);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

