/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.mailaccount.MailAccountDeleteListener;
import com.openexchange.mailaccount.internal.DeleteListenerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeleteListenerServiceTracker
implements ServiceTrackerCustomizer<MailAccountDeleteListener, MailAccountDeleteListener> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteListenerServiceTracker.class);
    private final BundleContext context;

    public DeleteListenerServiceTracker(BundleContext context) {
        this.context = context;
    }

    public MailAccountDeleteListener addingService(ServiceReference<MailAccountDeleteListener> reference) {
        MailAccountDeleteListener addedService = (MailAccountDeleteListener)this.context.getService(reference);
        if (DeleteListenerRegistry.getInstance().addDeleteListener(addedService)) {
            return addedService;
        }
        LOG.warn("Duplicate delete listener \"{}\" is not be added to registry.", (Object)addedService.getClass().getName());
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<MailAccountDeleteListener> reference, MailAccountDeleteListener service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<MailAccountDeleteListener> reference, MailAccountDeleteListener service) {
        if (null != service) {
            try {
                DeleteListenerRegistry.getInstance().removeDeleteListener(service);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

