/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccountDeleteListener;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DeleteListenerRegistry {
    private static volatile DeleteListenerRegistry instance;
    private final ConcurrentMap<Class<? extends MailAccountDeleteListener>, MailAccountDeleteListener> registry = new ConcurrentHashMap<Class<? extends MailAccountDeleteListener>, MailAccountDeleteListener>();

    static void initInstance() {
        instance = new DeleteListenerRegistry();
    }

    static void releaseInstance() {
        instance = null;
    }

    public static DeleteListenerRegistry getInstance() {
        return instance;
    }

    public boolean addDeleteListener(MailAccountDeleteListener deleteListener) {
        return null == this.registry.putIfAbsent(deleteListener.getClass(), deleteListener);
    }

    public void removeDeleteListener(MailAccountDeleteListener deleteListener) {
        this.registry.remove(deleteListener.getClass());
    }

    public void triggerOnBeforeDeletion(int id, Map<String, Object> properties, int user, int cid, Connection con) throws OXException {
        for (MailAccountDeleteListener mailAccountDeleteListener : this.registry.values()) {
            mailAccountDeleteListener.onBeforeMailAccountDeletion(id, properties, user, cid, con);
        }
    }

    public void triggerOnAfterDeletion(int id, Map<String, Object> properties, int user, int cid, Connection con) throws OXException {
        for (MailAccountDeleteListener mailAccountDeleteListener : this.registry.values()) {
            mailAccountDeleteListener.onAfterMailAccountDeletion(id, properties, user, cid, con);
        }
    }
}

