/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config.impl;

import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.transport.config.NoReplyConfig;
import com.openexchange.mail.transport.config.NoReplyConfigFactory;
import com.openexchange.mail.transport.config.impl.DefaultNoReplyConfig;
import javax.mail.internet.AddressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNoReplyConfigFactory
implements NoReplyConfigFactory {
    private final ContextService contextService;
    private final ConfigViewFactory configViewFactory;

    public DefaultNoReplyConfigFactory(ContextService contextService, ConfigViewFactory configViewFactory) {
        this.contextService = contextService;
        this.configViewFactory = configViewFactory;
    }

    @Override
    public NoReplyConfig getNoReplyConfig(int contextId) throws OXException {
        return this.loadNoReplyConfig(contextId);
    }

    public NoReplyConfig loadNoReplyConfig(int contextId) throws OXException {
        NoReplyConfig.SecureMode secureMode;
        int port;
        String msg;
        QuotedInternetAddress address;
        Logger logger = LoggerFactory.getLogger(NoReplyConfig.class);
        int contextAdminId = this.contextService.getContext(contextId).getMailadmin();
        ConfigView view = this.configViewFactory.getView(contextAdminId, contextId);
        DefaultNoReplyConfig config = new DefaultNoReplyConfig();
        String sAddress = (String)view.get("com.openexchange.noreply.address", String.class);
        if (Strings.isEmpty((String)sAddress)) {
            String msg2 = "Missing no-reply address";
            logger.error(msg2, new Throwable(msg2));
            address = null;
        } else {
            try {
                address = new QuotedInternetAddress(sAddress, false);
            }
            catch (AddressException e) {
                logger.error("Invalid no-reply address", (Throwable)e);
                address = null;
            }
        }
        config.setAddress(address);
        String str = (String)view.get("com.openexchange.noreply.login", String.class);
        if (Strings.isEmpty((String)str)) {
            msg = "Missing no-reply login";
            logger.error(msg, new Throwable(msg));
        } else {
            config.setLogin(str.trim());
        }
        str = (String)view.get("com.openexchange.noreply.password", String.class);
        if (Strings.isEmpty((String)str)) {
            msg = "Missing no-reply password";
            logger.error(msg, new Throwable(msg));
        } else {
            config.setPassword(str.trim());
        }
        str = (String)view.get("com.openexchange.noreply.server", String.class);
        if (Strings.isEmpty((String)str)) {
            msg = "Missing no-reply server";
            logger.error(msg, new Throwable(msg));
        } else {
            config.setServer(str.trim());
        }
        str = (String)view.get("com.openexchange.noreply.port", String.class);
        if (Strings.isEmpty((String)str)) {
            logger.info("Missing no-reply port. Using 25 as fall-back value.");
            port = 25;
        } else {
            int p = Strings.parseInt((String)str.trim());
            if (p < 0) {
                logger.warn("Invalid no-reply port: {}. Using 25 as fall-back value.", (Object)str);
                port = 25;
            } else {
                port = p;
            }
        }
        config.setPort(port);
        str = (String)view.get("com.openexchange.noreply.secureMode", String.class);
        if (Strings.isEmpty((String)str)) {
            logger.info("Missing no-reply secure mode. Using \"plain\" as fall-back value.");
            secureMode = NoReplyConfig.SecureMode.PLAIN;
        } else {
            NoReplyConfig.SecureMode tmp = NoReplyConfig.SecureMode.secureModeFor(str.trim());
            if (null == tmp) {
                logger.warn("Invalid no-reply secure mode: {}. Using \"plain\" as fall-back value.", (Object)str);
                secureMode = NoReplyConfig.SecureMode.PLAIN;
            } else {
                secureMode = tmp;
            }
        }
        config.setSecureMode(secureMode);
        if (!config.isValid()) {
            throw MailExceptionCode.CONFIG_ERROR.create("The no-reply mail configuration is invalid. Make sure to set all necessary values in noreply.properties and the according context-scope overrides.");
        }
        return config;
    }
}

