/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.transport.MtaStatusInfo;
import com.openexchange.mail.transport.TransportInitialization;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.session.Session;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;

public abstract class MailTransport {
    public static final MailTransport getInstance(Session session) throws OXException {
        return MailTransport.getInstance(session, 0);
    }

    public static final MailTransport getInstance(Session session, int accountId) throws OXException {
        if (!TransportInitialization.getInstance().isInitialized()) {
            throw MailExceptionCode.INITIALIZATION_PROBLEM.create();
        }
        return TransportProviderRegistry.getTransportProviderBySession(session, accountId).createNewMailTransport(session, accountId);
    }

    public MailMessage sendMailMessage(ComposedMailMessage transportMail, ComposeType sendType) throws OXException {
        return this.sendMailMessage(transportMail, sendType, null);
    }

    public abstract MailMessage sendMailMessage(ComposedMailMessage var1, ComposeType var2, Address[] var3) throws OXException;

    public MailMessage sendMailMessage(ComposedMailMessage composedMail, ComposeType sendType, Address[] allRecipients, MtaStatusInfo mtaStatusInfo) throws OXException {
        return this.sendMailMessage(composedMail, sendType, allRecipients);
    }

    public MailMessage sendRawMessage(byte[] asciiBytes) throws OXException {
        return this.sendRawMessage(asciiBytes, (Address[])null);
    }

    public abstract MailMessage sendRawMessage(byte[] var1, Address[] var2) throws OXException;

    public abstract void sendRawMessage(InputStream var1, Address[] var2) throws OXException;

    public MailMessage sendRawMessage(byte[] asciiBytes, SendRawProperties properties) throws OXException {
        return this.sendRawMessage(asciiBytes, (Address[])properties.getRecipients());
    }

    public void sendRawMessage(InputStream stream, SendRawProperties properties) throws OXException {
        this.sendRawMessage(stream, (Address[])properties.getRecipients());
    }

    public abstract void sendReceiptAck(MailMessage var1, String var2) throws OXException;

    public abstract void ping() throws OXException;

    public abstract void close() throws OXException;

    public abstract TransportConfig getTransportConfig() throws OXException;

    protected abstract ITransportProperties createNewMailProperties() throws OXException;

    public static final class SendRawProperties {
        private final List<InternetAddress> recipients = new ArrayList<InternetAddress>(4);
        private InternetAddress sender;
        private boolean validateAddressHeaders = true;
        private boolean sanitizeHeaders = true;

        private SendRawProperties() {
        }

        public static SendRawProperties newInstance() {
            return new SendRawProperties();
        }

        public SendRawProperties addRecipient(InternetAddress recipient) {
            if (recipient != null) {
                this.recipients.add(recipient);
            }
            return this;
        }

        public SendRawProperties setSender(InternetAddress sender) {
            this.sender = sender;
            return this;
        }

        public SendRawProperties setValidateAddressHeaders(boolean validateAddressHeaders) {
            this.validateAddressHeaders = validateAddressHeaders;
            return this;
        }

        public SendRawProperties setSanitizeHeaders(boolean sanitizeHeaders) {
            this.sanitizeHeaders = sanitizeHeaders;
            return this;
        }

        public InternetAddress[] getRecipients() {
            int num = this.recipients.size();
            if (num == 0) {
                return null;
            }
            return this.recipients.toArray(new InternetAddress[num]);
        }

        public InternetAddress getSender() {
            return this.sender;
        }

        public boolean isValidateAddressHeaders() {
            return this.validateAddressHeaders;
        }

        public boolean isSanitizeHeaders() {
            return this.sanitizeHeaders;
        }
    }
}

