/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Message;

public final class BooleanTerm
extends SearchTerm<Boolean> {
    private static final long serialVersionUID = 5351872902045670432L;
    public static final BooleanTerm TRUE = new BooleanTerm(true);
    public static final BooleanTerm FALSE = new BooleanTerm(false);
    private final boolean value;

    private BooleanTerm(boolean value) {
        this.value = value;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Boolean getPattern() {
        return this.value;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return BooleanSearchTerm.getInstance(this.value);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        return this.value;
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        return this.value;
    }

    private static final class BooleanSearchTerm
    extends javax.mail.search.SearchTerm {
        private static final BooleanSearchTerm _TRUE = new BooleanSearchTerm(true);
        private static final BooleanSearchTerm _FALSE = new BooleanSearchTerm(false);
        private static final long serialVersionUID = -8073302646525000957L;
        private final boolean value;

        public static BooleanSearchTerm getInstance(boolean value) {
            return value ? _TRUE : _FALSE;
        }

        private BooleanSearchTerm(boolean value) {
            this.value = value;
        }

        public boolean match(Message msg) {
            return this.value;
        }
    }
}

