/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.osgi;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportProviderServiceTracker
implements ServiceTrackerCustomizer<TransportProvider, TransportProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(TransportProviderServiceTracker.class);
    private final BundleContext context;
    volatile ServiceRegistration<CapabilityChecker> capabilityChecker;
    private volatile ServiceTracker<CapabilityService, CapabilityService> capabilityServiceTracker;

    public TransportProviderServiceTracker(BundleContext context) {
        this.context = context;
    }

    public synchronized TransportProvider addingService(ServiceReference<TransportProvider> reference) {
        BundleContext context = this.context;
        TransportProvider transportProvider = (TransportProvider)context.getService(reference);
        if (null == transportProvider) {
            LOG.warn("Added service is null!", new Throwable());
            context.ungetService(reference);
            return null;
        }
        Object protocol = reference.getProperty("protocol");
        if (null == protocol) {
            LOG.error("Missing protocol in transport provider service: {}", (Object)transportProvider.getClass().getName());
            context.ungetService(reference);
            return null;
        }
        try {
            if (!TransportProviderRegistry.registerTransportProvider(protocol.toString(), transportProvider)) {
                LOG.warn("Transport provider for protocol '{}' could not be added.Another provider which supports the protocol has already been registered.", protocol);
                context.ungetService(reference);
                return null;
            }
            LOG.info("Transport provider for protocol '{}' successfully registered", protocol);
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            context.ungetService(reference);
            return null;
        }
        this.capabilityServiceTracker = new ServiceTracker<CapabilityService, CapabilityService>(context, CapabilityService.class, null){

            public CapabilityService addingService(ServiceReference<CapabilityService> ref) {
                Hashtable<String, String> properties = new Hashtable<String, String>(1);
                String sCapability = "auto_publish_attachments";
                ((Dictionary)properties).put("capabilities", "auto_publish_attachments");
                TransportProviderServiceTracker.this.capabilityChecker = this.context.registerService(CapabilityChecker.class, (Object)new CapabilityChecker(){

                    public boolean isEnabled(String capability, Session ses) throws OXException {
                        if ("auto_publish_attachments".equals(capability)) {
                            ServerSession session = ServerSessionAdapter.valueOf(ses);
                            if (session.isAnonymous() || !session.getUserPermissionBits().hasWebMail()) {
                                return false;
                            }
                            return TransportProperties.getInstance().isPublishOnExceededQuota() && session.getUserPermissionBits().hasInfostore();
                        }
                        return true;
                    }
                }, properties);
                CapabilityService capabilityService = (CapabilityService)this.context.getService(ref);
                capabilityService.declareCapability("auto_publish_attachments");
                return capabilityService;
            }
        };
        this.capabilityServiceTracker.open();
        return transportProvider;
    }

    public void modifiedService(ServiceReference<TransportProvider> reference, TransportProvider service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removedService(ServiceReference<TransportProvider> reference, TransportProvider service) {
        if (null != service) {
            ServiceRegistration<CapabilityChecker> capabilityChecker;
            try {
                try {
                    TransportProvider provider = service;
                    TransportProviderRegistry.unregisterTransportProvider(provider);
                    LOG.info("Transport provider for protocol '{}' successfully unregistered", (Object)provider.getProtocol());
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
            if (TransportProviderRegistry.isEmpty() && (capabilityChecker = this.capabilityChecker) != null) {
                capabilityChecker.unregister();
                this.capabilityChecker = null;
                ServiceTracker<CapabilityService, CapabilityService> capabilityServiceTracker = this.capabilityServiceTracker;
                if (capabilityServiceTracker != null) {
                    capabilityServiceTracker.close();
                    this.capabilityServiceTracker = null;
                }
            }
        }
    }
}

