/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class MimeTypes {
    public static final String MIME_DEFAULT = "text/plain; charset=us-ascii";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_PLAIN_TEMPL = "text/plain; charset=#CS#";
    public static final String MIME_TEXT_ALL = "text/*";
    public static final String MIME_TEXT_HTM_ALL = "text/htm*";
    public static final String MIME_TEXT_HTML = "text/html";
    public static final String MIME_MULTIPART_MIXED = "multipart/mixed";
    public static final String MIME_MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String MIME_MULTIPART_OCTET = "multipart/octet-stream";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_MULTIPART_ALL = "multipart/*";
    public static final String MIME_MESSAGE_RFC822 = "message/rfc822";
    public static final String MIME_TEXT_CALENDAR = "text/calendar";
    public static final String MIME_TEXT_X_VCALENDAR = "text/x-vcalendar";
    public static final String MIME_TEXT_VCARD = "text/vcard";
    public static final String MIME_TEXT_X_VCARD = "text/x-vcard";
    public static final String MIME_APPL_OCTET = "application/octet-stream";
    public static final String MIME_APPL_ALL = "application/*";
    public static final String MIME_TEXT_ENRICHED = "text/enriched";
    public static final String MIME_TEXT_RTF = "text/rtf";
    public static final String MIME_TEXT_RICHTEXT = "text/richtext";
    public static final String MIME_TEXT_RFC822_HDRS = "text/rfc822-headers";
    public static final String MIME_TEXT_ALL_CARD = "text/*card";
    public static final String MIME_TEXT_ALL_CALENDAR = "text/*calendar";
    public static final String MIME_APPLICATION_ICS = "application/ics";
    public static final String MIME_IMAGE_ALL = "image/*";
    public static final String MIME_MESSAGE_DELIVERY_STATUS = "message/delivery-status";
    public static final String MIME_MESSAGE_DISP_NOTIFICATION = "message/disposition-notification";
    public static final String MIME_PGP_SIGN = "application/pgp-signature";
    public static final String MIME_UNKNOWN = "application/octet-stream";
    public static final Set<String> INVALIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/octet-stream", "application/force-download", "application/binary", "application/x-download", "application/vnd", "application/vnd.ms-word.document.12n", "application/vnd.ms-word.document.12", "application/vnd.ms-word", "application/odt", "application/x-pdf")));

    private MimeTypes() {
    }

    public static String getPrimaryType(String contentType) {
        if (Strings.isEmpty((String)contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }

    public static String getFilePrefix(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return fileName;
        }
        int pos = fileName.lastIndexOf(46);
        return pos > 0 && pos < fileName.length() ? fileName.substring(0, pos) : fileName;
    }

    public static String getFileExtension(String fileName) {
        if (Strings.isEmpty((String)fileName)) {
            return fileName;
        }
        int pos = fileName.lastIndexOf(46);
        return pos > 0 && pos < fileName.length() ? fileName.substring(pos) : fileName;
    }

    public static String getBaseType(String mimeType) {
        if (Strings.isEmpty((String)mimeType)) {
            return null;
        }
        int pos = mimeType.indexOf(59);
        if (pos <= 0) {
            return mimeType;
        }
        return pos < mimeType.length() ? mimeType.substring(0, pos).trim() : mimeType;
    }

    public static String getParameterList(String mimeType) {
        if (Strings.isEmpty((String)mimeType)) {
            return null;
        }
        int pos = mimeType.indexOf(59);
        return pos > 0 && pos < mimeType.length() ? mimeType.substring(pos).trim() : null;
    }

    public static boolean equalPrimaryTypes(String contentType1, String contentType2) {
        if (null == contentType1 || null == contentType2) {
            return false;
        }
        return Strings.toLowerCase((CharSequence)MimeTypes.getPrimaryType(contentType1)).startsWith(Strings.toLowerCase((CharSequence)MimeTypes.getPrimaryType(contentType2)));
    }

    public static String checkedMimeType(String givenMimeType, String fileName) {
        return MimeTypes.checkedMimeType(givenMimeType, fileName, null);
    }

    public static String checkedMimeType(String givenMimeType, String fileName, Set<String> invalids) {
        if (Strings.isEmpty((String)fileName)) {
            return givenMimeType;
        }
        if (Strings.isEmpty((String)givenMimeType)) {
            return MimeType2ExtMap.getContentType(fileName);
        }
        String contentTypeByFileName = MimeType2ExtMap.getContentType(fileName, null);
        if ((null == contentTypeByFileName || MimeTypes.equalPrimaryTypes(givenMimeType, contentTypeByFileName)) && !MimeTypes.consideredAsInvalid(givenMimeType, invalids)) {
            return givenMimeType;
        }
        String parameterList = MimeTypes.getParameterList(givenMimeType);
        return Strings.isEmpty((String)parameterList) ? contentTypeByFileName : contentTypeByFileName + parameterList;
    }

    private static boolean consideredAsInvalid(String givenMimeType, Set<String> invalids) {
        return null == invalids || invalids.isEmpty() ? false : invalids.contains(Strings.toLowerCase((CharSequence)MimeTypes.getBaseType(givenMimeType)));
    }

    public static String checkedFileName(String givenFileName, String baseType) {
        if (Strings.isEmpty((String)baseType)) {
            return givenFileName;
        }
        String contentTypeByFileName = MimeType2ExtMap.getContentType(givenFileName, null);
        if (null == contentTypeByFileName || MimeTypes.equalPrimaryTypes(baseType, contentTypeByFileName)) {
            return givenFileName;
        }
        String fileExtension = MimeType2ExtMap.getFileExtension(baseType);
        if ("dat".equals(fileExtension)) {
            return givenFileName;
        }
        String filePrefix = MimeTypes.getFilePrefix(givenFileName);
        return (Strings.isEmpty((String)filePrefix) ? "file" : filePrefix) + '.' + fileExtension;
    }
}

