/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MimeTypeFileLineParser {
    private static final Pattern PAT_VAL = Pattern.compile("(?:[^\"][\\p{L}&&[^\\s\"]]*|\"[\\p{L}&&[^\"]]+\")");
    private String type;
    private final List<String> extensions = new ArrayList<String>();
    private static final String STR_TYPE = "type=";
    private static final String STR_EXTS = "exts=";

    public MimeTypeFileLineParser(String entry) {
        this.parse(entry);
    }

    private void parse(String entry) {
        int start;
        Matcher m;
        int pos = -1;
        pos = entry.toLowerCase(Locale.ENGLISH).indexOf(STR_TYPE);
        if (pos != -1 && (m = PAT_VAL.matcher(entry)).find(start = pos + 5) && m.start() == start) {
            this.type = m.group();
        }
        if ((pos = entry.toLowerCase(Locale.ENGLISH).indexOf(STR_EXTS)) != -1 && (m = PAT_VAL.matcher(entry)).find(start = pos + 5) && m.start() == start) {
            String sExts = m.group();
            String[] exts = sExts.charAt(0) == '\"' && sExts.charAt(sExts.length() - 1) == '\"' ? sExts.substring(1, sExts.length() - 1).split("[ \t\n\r\f]*,[ \t\n\r\f]*") : m.group().split("[ \t\n\r\f]*,[ \t\n\r\f]*");
            this.extensions.addAll(Arrays.asList(exts));
        }
    }

    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String getType() {
        return this.type;
    }
}

