/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.utils.UploadSizeValidation;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.json.parser.AbstractAttachmentHandler;
import com.openexchange.mail.json.parser.LinkedAttachment;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tx.TransactionAware;
import com.openexchange.user.UserService;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAttachmentHandler
extends AbstractAttachmentHandler
implements TransactionAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttachmentHandler.class);
    private static final Pattern PATTERN_DATE = Pattern.compile(Pattern.quote("#DATE#"));
    protected final Session session;
    protected final TransportProvider transportProvider;
    protected final String protocol;
    protected final String hostName;
    protected boolean exceeded;
    protected TextBodyMailPart textPart;
    protected long consumed;

    public DefaultAttachmentHandler(Session session, TransportProvider transportProvider, String protocol, String hostName) throws OXException {
        super(session);
        this.protocol = protocol;
        this.hostName = hostName;
        this.transportProvider = transportProvider;
        this.session = session;
    }

    @Override
    public void setTextPart(TextBodyMailPart textPart) {
        this.textPart = textPart;
    }

    @Override
    public void addAttachment(MailPart attachment) throws OXException {
        long size;
        if (this.doAction && !this.exceeded) {
            size = attachment.getSize();
            if (size <= 0L) {
                LOG.debug("Missing size: {}", (Object)size, (Object)new Throwable());
            }
            if (this.uploadQuotaPerFile > 0L && size > this.uploadQuotaPerFile) {
                if (LOG.isDebugEnabled()) {
                    String fileName = attachment.getFileName();
                    OXException e = MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(UploadUtility.getSize(this.uploadQuotaPerFile), null == fileName ? "" : fileName, UploadUtility.getSize(size));
                    LOG.debug("Per-file quota ({}) exceeded. Message is going to be sent with links to publishing infostore folder.", (Object)UploadUtility.getSize(this.uploadQuotaPerFile), (Object)e);
                }
                this.exceeded = true;
            }
            this.consumed += size;
            if (this.uploadQuota > 0L && this.consumed > this.uploadQuota) {
                if (LOG.isDebugEnabled()) {
                    OXException e = MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(UploadUtility.getSize(this.uploadQuota));
                    LOG.debug("Overall quota ({}) exceeded. Message is going to be sent with links to publishing infostore folder.", (Object)UploadUtility.getSize(this.uploadQuota), (Object)e);
                }
                this.exceeded = true;
            }
        }
        if ((size = attachment.getSize()) > 0L) {
            UploadSizeValidation.checkSize(size);
        }
        this.attachments.add(attachment);
    }

    @Override
    public ComposedMailMessage[] generateComposedMails(ComposedMailMessage source, List<OXException> warnings) throws OXException {
        if (!this.exceeded) {
            source.setBodyPart(this.textPart);
            for (MailPart attachment : this.attachments) {
                source.addEnclosedPart(attachment);
            }
            return new ComposedMailMessage[]{source};
        }
        warnings.add(MailExceptionCode.USED_PUBLISHING_FEATURE.create());
        try {
            this.startTransaction();
            ComposedMailMessage[] composedMails = this.generateComposedMails0(source, this.publishAttachments(source, warnings));
            this.commit();
            ComposedMailMessage[] composedMailMessageArray = composedMails;
            return composedMailMessageArray;
        }
        catch (OXException e) {
            this.rollback();
            throw e;
        }
        finally {
            this.finish();
        }
    }

    public void setTransactional(boolean transactional) {
    }

    public void setRequestTransactional(boolean transactional) {
    }

    public void setCommitsTransaction(boolean commits) {
    }

    protected abstract List<LinkedAttachment> publishAttachments(ComposedMailMessage var1, List<OXException> var2) throws OXException;

    protected Date getExpiratioDate() {
        if (TransportProperties.getInstance().publishedDocumentsExpire()) {
            return new Date(System.currentTimeMillis() + TransportProperties.getInstance().getPublishedDocumentTimeToLive());
        }
        return null;
    }

    protected String getPassword() {
        return null;
    }

    private ComposedMailMessage[] generateComposedMails0(ComposedMailMessage source, List<LinkedAttachment> links) throws OXException {
        HashSet<InternetAddress> addresses = new HashSet<InternetAddress>();
        addresses.addAll(Arrays.asList(source.getTo()));
        addresses.addAll(Arrays.asList(source.getCc()));
        addresses.addAll(Arrays.asList(source.getBcc()));
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
        Context ctx = this.getContext();
        HashMap<Locale, ComposedMailMessage> internalMessages = new HashMap<Locale, ComposedMailMessage>(addresses.size());
        ComposedMailMessage externalMessage = null;
        for (InternetAddress address : addresses) {
            User user;
            try {
                user = userService.searchUser(IDNA.toIDN((String)address.getAddress()), ctx);
            }
            catch (OXException e) {
                if (!LdapExceptionCode.NO_USER_BY_MAIL.equals(e)) {
                    throw e;
                }
                user = null;
            }
            if (null == user) {
                if (null == externalMessage) {
                    externalMessage = this.generateExternalVersion(address, source, ctx, links, TransportProperties.getInstance().isProvideLinksInAttachment(), this.getExpiratioDate());
                }
                externalMessage.addRecipient(address);
                continue;
            }
            Locale locale = user.getLocale();
            ComposedMailMessage localedMessage = (ComposedMailMessage)internalMessages.get(locale);
            if (null == localedMessage) {
                localedMessage = this.generateInternalVersion(address, source, ctx, links, TransportProperties.getInstance().isProvideLinksInAttachment(), this.getExpiratioDate(), locale);
                internalMessages.put(locale, localedMessage);
            }
            localedMessage.addRecipient(address);
        }
        ArrayList<Object> mails = new ArrayList<Object>(internalMessages.size() + 1);
        mails.addAll(internalMessages.values());
        if (null != externalMessage) {
            mails.add(externalMessage);
        }
        if (mails.isEmpty()) {
            mails.add(this.generateInternalVersion(null, source, ctx, links, TransportProperties.getInstance().isProvideLinksInAttachment(), this.getExpiratioDate(), this.getSessionUser().getLocale()));
        }
        return mails.toArray(new ComposedMailMessage[mails.size()]);
    }

    protected Context getContext() throws OXException {
        if (this.session instanceof ServerSession) {
            return ((ServerSession)this.session).getContext();
        }
        return ContextStorage.getStorageContext(this.session.getContextId());
    }

    protected User getSessionUser() throws OXException {
        if (this.session instanceof ServerSession) {
            return ((ServerSession)this.session).getUser();
        }
        return UserStorage.getInstance().getUser(this.session.getUserId(), this.getContext());
    }

    protected Locale getSessionUserLocale() throws OXException {
        return this.getSessionUser().getLocale();
    }

    protected ComposedMailMessage generateInternalVersion(InternetAddress recipient, ComposedMailMessage source, Context ctx, List<LinkedAttachment> links, boolean appendLinksAsAttachment, Date elapsedDate, Locale locale) throws OXException {
        ComposedMailMessage internalVersion = this.copyOf(source, ctx);
        TextBodyMailPart textPart = this.textPart.copy();
        textPart.setPlainText(null);
        StringHelper stringHelper = StringHelper.valueOf(locale);
        if (appendLinksAsAttachment) {
            internalVersion.setBodyPart(textPart);
            StringBuilder textBuilder = new StringBuilder(256 * links.size());
            textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br>");
            this.appendLinks(recipient, links, textBuilder);
            internalVersion.addEnclosedPart(this.createLinksAttachment(textBuilder.toString()));
        } else {
            String text = (String)textPart.getContent();
            StringBuilder textBuilder = new StringBuilder(text.length() + 512);
            textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br>");
            this.appendLinks(recipient, links, textBuilder);
            if (elapsedDate != null) {
                textBuilder.append(HtmlProcessing.htmlFormat(PATTERN_DATE.matcher(stringHelper.getString("The links will be deleted on #DATE#")).replaceFirst(DateFormat.getDateInstance(1, locale).format(elapsedDate)))).append("<br><br>");
            }
            textBuilder.append(text);
            textPart.setText(textBuilder.toString());
            internalVersion.setBodyPart(textPart);
        }
        return internalVersion;
    }

    protected ComposedMailMessage generateExternalVersion(InternetAddress recipient, ComposedMailMessage source, Context ctx, List<LinkedAttachment> links, boolean appendLinksAsAttachment, Date elapsedDate) throws OXException {
        ComposedMailMessage externalVersion = this.copyOf(source, ctx);
        TextBodyMailPart textPart = this.textPart.copy();
        if (TransportProperties.getInstance().isSendAttachmentToExternalRecipients()) {
            externalVersion.setBodyPart(textPart);
            for (MailPart attachment : this.attachments) {
                externalVersion.addEnclosedPart(attachment);
            }
        } else {
            textPart.setPlainText(null);
            Locale locale = TransportProperties.getInstance().getExternalRecipientsLocale();
            if (null == locale) {
                locale = this.getSessionUserLocale();
            }
            StringHelper stringHelper = StringHelper.valueOf(locale);
            if (appendLinksAsAttachment) {
                externalVersion.setBodyPart(textPart);
                StringBuilder textBuilder = new StringBuilder(256 * links.size());
                textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br>");
                this.appendLinks(recipient, links, textBuilder);
                externalVersion.addEnclosedPart(this.createLinksAttachment(textBuilder.toString()));
            } else {
                String text = (String)textPart.getContent();
                StringBuilder textBuilder = new StringBuilder(text.length() + 512);
                textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br>");
                this.appendLinks(recipient, links, textBuilder);
                if (elapsedDate != null) {
                    textBuilder.append(HtmlProcessing.htmlFormat(PATTERN_DATE.matcher(stringHelper.getString("The links will be deleted on #DATE#")).replaceFirst(DateFormat.getDateInstance(1, locale).format(elapsedDate)))).append("<br><br>");
                }
                textBuilder.append(text);
                textPart.setText(textBuilder.toString());
                externalVersion.setBodyPart(textPart);
            }
        }
        return externalVersion;
    }

    protected void appendLinks(InternetAddress recipient, List<LinkedAttachment> linkedAttachments, StringBuilder textBuilder) {
        for (LinkedAttachment linkedAttachment : linkedAttachments) {
            String link = linkedAttachment.getLink(recipient);
            char quot = link.indexOf(34) < 0 ? (char)'\"' : '\'';
            textBuilder.append("<a href=").append(quot).append(link).append(quot).append('>');
            String name = linkedAttachment.getName();
            if (null != name && name.length() > 0) {
                textBuilder.append(name).append("</a><br>");
                continue;
            }
            textBuilder.append(link).append("</a><br>");
        }
    }

    private MailPart createLinksAttachment(String text) throws OXException, OXException {
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            MessageUtility.setText(HtmlProcessing.getConformHTML(text, "UTF-8"), "UTF-8", "html", (Part)bodyPart);
            bodyPart.setHeader(MessageHeaders.HDR_MIME_VERSION, "1.0");
            bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType("text/html; charset=UTF-8; name=links.html"));
            bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TRANSFER_ENC, "base64");
            bodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition("attachment; filename=links.html"));
            return MimeMessageConverter.convertPart((Part)bodyPart, false);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private ComposedMailMessage copyOf(ComposedMailMessage source, Context ctx) throws OXException {
        ComposedMailMessage composedMail = this.transportProvider.getNewComposedMailMessage(this.session, ctx);
        if (source.containsFlags()) {
            composedMail.setFlags(source.getFlags());
        }
        if (source.containsThreadLevel()) {
            composedMail.setThreadLevel(source.getThreadLevel());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsHeaders()) {
            composedMail.addHeaders(source.getHeaders());
        }
        if (source.containsFrom()) {
            composedMail.addFrom(source.getFrom());
        }
        if (source.containsTo()) {
            composedMail.addTo(source.getTo());
        }
        if (source.containsCc()) {
            composedMail.addCc(source.getCc());
        }
        if (source.containsBcc()) {
            composedMail.addBcc(source.getBcc());
        }
        if (source.containsReplyTo()) {
            composedMail.addReplyTo(source.getReplyTo());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsPriority()) {
            composedMail.setPriority(source.getPriority());
        }
        if (source.containsColorLabel()) {
            composedMail.setColorLabel(source.getColorLabel());
        }
        if (source.containsAppendVCard()) {
            composedMail.setAppendVCard(source.isAppendVCard());
        }
        if (source.containsMsgref()) {
            composedMail.setMsgref(source.getMsgref());
        }
        if (source.containsSubject()) {
            composedMail.setSubject(source.getSubject());
        }
        if (source.containsSize()) {
            composedMail.setSize(source.getSize());
        }
        if (source.containsSentDate()) {
            composedMail.setSentDate(source.getSentDate());
        }
        if (source.containsReceivedDate()) {
            composedMail.setReceivedDate(source.getReceivedDate());
        }
        if (source.containsContentType()) {
            composedMail.setContentType(source.getContentType());
        }
        return composedMail;
    }
}

