/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.actions.FolderInfo;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="delete", description="Delete mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the deleted mails.")}, requestBody="An array of objects providing folder IDs and object IDs of the deleted mails. [{ \"folder\":\"default0/INBOX\", \"id\":\"123\" } ... { \"folder\":\"default0/MyFolder\", \"id\":\"134\" }]", responseDescription="An array with object IDs of mails which were modified after the specified timestamp and were therefore not deleted.")
public final class DeleteAction
extends AbstractMailAction {
    public DeleteAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            boolean hardDelete = AJAXRequestDataTools.parseBoolParameter(req.getParameter("harddelete"));
            boolean returnAffectedFolders = AJAXRequestDataTools.parseBoolParameter(req.getParameter("returnAffectedFolders"));
            JSONArray jsonIds = (JSONArray)req.getRequest().requireData();
            MailServletInterface mailInterface = this.getMailInterface(req);
            JSONArray jResponse = null;
            int length = jsonIds.length();
            if (length > 0) {
                ArrayList<MailPath> l = new ArrayList<MailPath>(length);
                LinkedHashMap<FullnameArgument, FolderInfo> folders2 = returnAffectedFolders ? new LinkedHashMap<FullnameArgument, FolderInfo>(length) : null;
                for (int i = 0; i < length; ++i) {
                    JSONObject jId = jsonIds.getJSONObject(i);
                    FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(jId.getString("folder"));
                    l.add(new MailPath(fa.getAccountId(), fa.getFullname(), jId.getString("id")));
                }
                Collections.sort(l, MailPath.COMPARATOR);
                String lastFldArg = ((MailPath)l.get(0)).getFolderArgument();
                ArrayList<String> arr = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    MailPath current = (MailPath)l.get(i);
                    String folderArgument = current.getFolderArgument();
                    if (!lastFldArg.equals(folderArgument)) {
                        String[] uids = arr.toArray(new String[arr.size()]);
                        mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                        if (null != folders2) {
                            FullnameArgument trash;
                            int connectedAccount = mailInterface.getAccountID();
                            FullnameArgument fa = new FullnameArgument(connectedAccount, current.getFolder());
                            folders2.put(fa, this.getFolderInfo(current.getFolder(), mailInterface));
                            if (!hardDelete && !(trash = MailFolderUtility.prepareMailFolderParam(mailInterface.getTrashFolder(connectedAccount))).equals(fa)) {
                                folders2.put(trash, this.getFolderInfo(trash.getFullName(), mailInterface));
                            }
                        }
                        arr.clear();
                        lastFldArg = folderArgument;
                    }
                    arr.add(current.getMailID());
                }
                int size = arr.size();
                if (size > 0) {
                    String[] uids = arr.toArray(new String[size]);
                    mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                    if (null != folders2) {
                        FullnameArgument trash;
                        int connectedAccount = mailInterface.getAccountID();
                        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(lastFldArg);
                        folders2.put(fa, this.getFolderInfo(fa.getFullName(), mailInterface));
                        if (!hardDelete && !(trash = MailFolderUtility.prepareMailFolderParam(mailInterface.getTrashFolder(connectedAccount))).equals(fa)) {
                            folders2.put(trash, this.getFolderInfo(trash.getFullName(), mailInterface));
                        }
                    }
                }
                if (returnAffectedFolders && null != folders2 && !folders2.isEmpty()) {
                    jResponse = new JSONObject(4);
                    jResponse.put("conflicts", (Object)new JSONArray(0));
                    JSONObject jFolders = new JSONObject(folders2.size());
                    for (Map.Entry infoEntry : folders2.entrySet()) {
                        FullnameArgument fa = (FullnameArgument)infoEntry.getKey();
                        String id = MailFolderUtility.prepareFullname(fa.getAccountId(), fa.getFullName());
                        FolderInfo folderInfo = (FolderInfo)infoEntry.getValue();
                        jFolders.put(id, (Object)new JSONObject(4).put("total", folderInfo.total).put("unread", folderInfo.unread));
                    }
                    jResponse.put("folders", (Object)jFolders);
                }
            }
            return new AJAXRequestResult((Object)(null == jResponse ? new JSONArray(0) : jResponse), "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private FolderInfo getFolderInfo(String fullName, MailServletInterface mailInterface) throws OXException {
        return FolderInfo.getFolderInfo(fullName, mailInterface.getMailAccess().getFolderStorage());
    }
}

