/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.json.cache.JsonCacheService;
import com.openexchange.json.cache.JsonCaches;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.IndexRange;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.ColumnCollection;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.MailRequestSha1Calculator;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.converters.MailConverter;
import com.openexchange.mail.search.ANDTerm;
import com.openexchange.mail.search.FlagTerm;
import com.openexchange.mail.search.ORTerm;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONValue;

@Action(method=RequestMethod.GET, name="all", description="Get all mails.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for appointments are defined in Detailed mail data. The alias \\\"all\\\" uses the predefined columnset [600, 601]."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response or the string \u201cthread\u201d to return thread-sorted messages. If this parameter is specified and holds a column number, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response (not IMAP: with timestamp): An array with mail data. Each array element describes one mail and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public final class AllAction
extends AbstractMailAction
implements MailRequestSha1Calculator {
    public AllAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JsonCacheService jsonCache;
        boolean cache = req.optBool("cache", false);
        if (cache && CACHABLE_FORMATS.contains(req.getRequest().getFormat()) && null != (jsonCache = JsonCaches.getCache())) {
            AJAXRequestResult result;
            ServerSession session;
            String sha1Sum = this.getSha1For(req);
            final String id = "com.openexchange.mail." + sha1Sum;
            JSONValue jsonValue = jsonCache.opt(id, (session = req.getSession()).getUserId(), session.getContextId());
            if (null == jsonValue) {
                String folderId;
                MailServletInterface mailInterface = this.getMailInterface(req);
                if (mailInterface.getMessageCount(folderId = req.checkParameter("folder")) <= mailInterface.getMailConfig().getMailProperties().getMailFetchLimit()) {
                    return this.perform0(req, mailInterface, false);
                }
                result = new AJAXRequestResult((Object)new JSONArray(0), "json");
                result.setResponseProperty("cached", Boolean.TRUE);
            } else {
                result = new AJAXRequestResult((Object)jsonValue, "json");
                result.setResponseProperty("cached", Boolean.TRUE);
            }
            AJAXRequestData requestData = req.getRequest().copyOf();
            requestData.setProperty("mail.sha1", sha1Sum);
            requestData.setProperty("mail.sha1calc", this);
            requestData.setProperty(id, jsonValue);
            final MailRequest mailRequest = new MailRequest(requestData, session);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ServerSession session = mailRequest.getSession();
                    MailServletInterface mailInterface = null;
                    boolean locked = false;
                    try {
                        if (!jsonCache.lock(id, session.getUserId(), session.getContextId())) {
                            return;
                        }
                        locked = true;
                        mailInterface = MailServletInterface.getInstance(session);
                        AJAXRequestResult requestResult = AllAction.this.perform0(mailRequest, mailInterface, true);
                        MailConverter.getInstance().convert(mailRequest.getRequest(), requestResult, session, null);
                    }
                    catch (Exception e) {
                        try {
                            jsonCache.delete(id, session.getUserId(), session.getContextId());
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (null != mailInterface) {
                            try {
                                mailInterface.close(true);
                            }
                            catch (Exception e) {}
                        }
                        if (locked) {
                            try {
                                jsonCache.unlock(id, session.getUserId(), session.getContextId());
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            };
            ThreadPools.getThreadPool().submit(ThreadPools.trackableTask((Runnable)r));
            return result;
        }
        return this.perform0(req, this.getMailInterface(req), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AJAXRequestResult perform0(MailRequest req, MailServletInterface mailInterface, boolean cache) throws OXException {
        try {
            List<Object> mails;
            long start;
            boolean filterApplied;
            int[] fromToIndices;
            block43: {
                String folderId = req.checkParameter("folder");
                ColumnCollection columnCollection = req.checkColumnsAndHeaders();
                int[] columns = columnCollection.getFields();
                String[] headers = columnCollection.getHeaders();
                String sort = req.getParameter("sort");
                String order = req.getParameter("order");
                if (sort != null && order == null) {
                    throw MailExceptionCode.MISSING_PARAM.create("order");
                }
                String s = req.getParameter("limit");
                if (null == s) {
                    int leftHandLimit = req.optInt("left_hand_limit");
                    int rightHandLimit = req.optInt("right_hand_limit");
                    if (leftHandLimit == -9999 || rightHandLimit == -9999) {
                        fromToIndices = null;
                    } else {
                        fromToIndices = new int[]{leftHandLimit < 0 ? 0 : leftHandLimit, rightHandLimit < 0 ? 0 : rightHandLimit};
                        if (fromToIndices[0] >= fromToIndices[1]) {
                            return new AJAXRequestResult(Collections.emptyList(), "mail");
                        }
                    }
                } else {
                    int end;
                    int start2;
                    try {
                        int i;
                        int pos = s.indexOf(44);
                        if (pos < 0) {
                            start2 = 0;
                            i = Integer.parseInt(s.trim());
                            end = i < 0 ? 0 : i;
                        } else {
                            i = Integer.parseInt(s.substring(0, pos).trim());
                            start2 = i < 0 ? 0 : i;
                            i = Integer.parseInt(s.substring(pos + 1).trim());
                            end = i < 0 ? 0 : i;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw MailExceptionCode.INVALID_INT_VALUE.create(e, s);
                    }
                    if (start2 >= end) {
                        return new AJAXRequestResult(Collections.emptyList(), "mail");
                    }
                    fromToIndices = new int[]{start2, end};
                }
                boolean ignoreSeen = req.optBool("unseen");
                boolean ignoreDeleted = !req.optBool("deleted", true);
                boolean bl = filterApplied = ignoreSeen || ignoreDeleted;
                if (filterApplied) {
                    int fieldFlags = MailListField.FLAGS.getField();
                    boolean found = false;
                    for (int i = 0; !found && i < columns.length; ++i) {
                        found = fieldFlags == columns[i];
                    }
                    if (!found) {
                        int[] tmp = columns;
                        columns = new int[columns.length + 1];
                        System.arraycopy(tmp, 0, columns, 0, tmp.length);
                        columns[tmp.length] = fieldFlags;
                    }
                }
                columns = AllAction.prepareColumns(columns);
                int orderDir = OrderDirection.ASC.getOrder();
                if (order != null) {
                    if (order.equalsIgnoreCase("asc")) {
                        orderDir = OrderDirection.ASC.getOrder();
                    } else if (order.equalsIgnoreCase("desc")) {
                        orderDir = OrderDirection.DESC.getOrder();
                    } else {
                        throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                    }
                }
                start = System.currentTimeMillis();
                mails = new LinkedList<MailMessage>();
                SearchIterator<MailMessage> it = null;
                try {
                    int sortCol;
                    if ("thread".equalsIgnoreCase(sort)) {
                        it = mailInterface.getAllThreadedMessages(folderId, MailSortField.RECEIVED_DATE.getField(), orderDir, columns, filterApplied ? null : fromToIndices);
                        int i = it.size();
                        while (i-- > 0) {
                            MailMessage mm = (MailMessage)it.next();
                            if (AllAction.discardMail(mm, ignoreSeen, ignoreDeleted)) continue;
                            if (!mm.containsAccountId()) {
                                mm.setAccountId(mailInterface.getAccountID());
                            }
                            mails.add(mm);
                        }
                        break block43;
                    }
                    try {
                        sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                    }
                    catch (NumberFormatException e) {
                        throw MailExceptionCode.INVALID_INT_VALUE.create(e, "sort");
                    }
                    if (filterApplied) {
                        MailMessage[] result;
                        ORTerm second;
                        FlagTerm first;
                        mailInterface.openFor(folderId);
                        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess = mailInterface.getMailAccess();
                        FlagTerm flagTerm = first = ignoreSeen ? new FlagTerm(32, false) : null;
                        ORTerm oRTerm = ignoreDeleted ? (ignoreSeen ? null : new ORTerm(new FlagTerm(2, false), new FlagTerm(32, false))) : (second = null);
                        SearchTerm searchTerm = null != first && null != second ? new ANDTerm(first, second) : (null == first ? second : first);
                        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderId);
                        IndexRange indexRange = null == fromToIndices ? IndexRange.NULL : new IndexRange(fromToIndices[0], fromToIndices[1]);
                        MailSortField sortField = MailSortField.getField(sortCol);
                        OrderDirection orderDirection = OrderDirection.getOrderDirection(orderDir);
                        IMailMessageStorage messageStorage = mailAccess.getMessageStorage();
                        MailField[] fields = MailField.getFields(columns);
                        if (null != headers && 0 < headers.length) {
                            if (messageStorage instanceof IMailMessageStorageExt) {
                                IMailMessageStorageExt ext = (IMailMessageStorageExt)messageStorage;
                                result = ext.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, fields, headers);
                            } else {
                                result = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, fields);
                                this.enrichWithHeaders(fa.getFullname(), result, headers, messageStorage);
                            }
                        } else {
                            result = messageStorage.searchMessages(fa.getFullname(), indexRange, sortField, orderDirection, searchTerm, fields);
                        }
                        for (MailMessage mm : result) {
                            if (null == mm) continue;
                            if (!mm.containsAccountId()) {
                                mm.setAccountId(mailInterface.getAccountID());
                            }
                            mails.add(mm);
                        }
                    } else {
                        it = mailInterface.getAllMessages(folderId, sortCol, orderDir, columns, headers, filterApplied ? null : fromToIndices, AJAXRequestDataTools.parseBoolParameter("continuation", req.getRequest()));
                        int i = it.size();
                        while (i-- > 0) {
                            MailMessage mm = (MailMessage)it.next();
                            if (AllAction.discardMail(mm, ignoreSeen, ignoreDeleted)) continue;
                            if (!mm.containsAccountId()) {
                                mm.setAccountId(mailInterface.getAccountID());
                            }
                            mails.add(mm);
                        }
                    }
                }
                finally {
                    SearchIterators.close(it);
                }
            }
            if (filterApplied && null != fromToIndices) {
                int fromIndex = fromToIndices[0];
                int toIndex = fromToIndices[1];
                int sz = mails.size();
                if (fromIndex > sz) {
                    mails = Collections.emptyList();
                } else {
                    if (toIndex >= sz) {
                        toIndex = sz;
                    }
                    mails = mails.subList(fromIndex, toIndex);
                }
            }
            AJAXRequestResult result = new AJAXRequestResult(mails, "mail").setDurationByStart(start);
            result.setResponseProperty("cached", cache);
            return result;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public String getSha1For(MailRequest req) throws OXException {
        String id = (String)req.getRequest().getProperty("mail.sha1");
        if (null != id) {
            return id;
        }
        String sha1Sum = JsonCaches.getSHA1Sum((String[])new String[]{"all", req.checkParameter("folder"), req.checkParameter("columns"), req.getParameter("sort"), req.getParameter("order"), req.getParameter("limit"), req.getParameter("left_hand_limit"), req.getParameter("right_hand_limit"), req.getParameter("unseen"), req.getParameter("deleted")});
        return sha1Sum;
    }

    private void enrichWithHeaders(String fullName, MailMessage[] mails, String[] headerNames, IMailMessageStorage messageStorage) throws OXException {
        int length = mails.length;
        String[] ids = new String[length];
        int i = ids.length;
        while (i-- > 0) {
            MailMessage m = mails[i];
            ids[i] = null == m ? null : m.getMailId();
        }
        MailMessage[] headers = messageStorage.getMessages(fullName, ids, MailFields.toArray(MailField.HEADERS));
        int i2 = length;
        while (i2-- > 0) {
            MailMessage header;
            MailMessage mailMessage = mails[i2];
            if (null == mailMessage || null == (header = headers[i2])) continue;
            for (String headerName : headerNames) {
                String[] values = header.getHeader(headerName);
                if (null == values) continue;
                for (String value : values) {
                    mailMessage.addHeader(headerName, value);
                }
            }
        }
    }
}

