/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.exception.OXException;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import org.json.JSONException;

public abstract class AbstractArchiveMailAction
extends AbstractMailAction {
    private static final String CAPABILITY_ARCHIVE_EMAILS = "archive_emails";

    protected AbstractArchiveMailAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected final AJAXRequestResult perform(MailRequest req) throws OXException, JSONException {
        CapabilityService capabilityService = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
        if (null != capabilityService && !capabilityService.getCapabilities((Session)req.getSession()).contains(CAPABILITY_ARCHIVE_EMAILS)) {
            throw AjaxExceptionCodes.NO_PERMISSION_FOR_MODULE.create("mail-archive");
        }
        return this.performArchive(req);
    }

    protected abstract AJAXRequestResult performArchive(MailRequest var1) throws OXException, JSONException;

    public static class ArchiveDataWrapper {
        private final String id;
        private final boolean created;

        public ArchiveDataWrapper(String id, boolean created) {
            this.id = id;
            this.created = created;
        }

        public String getId() {
            return this.id;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

