/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAware;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.session.Session;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class ContentAwareComposedMailMessage
extends ComposedMailMessage
implements ContentAware {
    private static final long serialVersionUID = 7469781321067672927L;
    private final MimeMessage content;

    public ContentAwareComposedMailMessage(MimeMessage content, Session session, int contextId) throws OXException {
        this(content, session, ContextStorage.getStorageContext(contextId));
    }

    public ContentAwareComposedMailMessage(MimeMessage content, Session session, Context ctx) {
        super(session, ctx);
        this.content = content;
    }

    public ContentAwareComposedMailMessage(MimeMessage content, int contextId) throws OXException {
        super(null, ContextStorage.getStorageContext(contextId));
        this.content = content;
    }

    private static InternetAddress[] convert(Address[] a) {
        if (null == a) {
            return null;
        }
        int length = a.length;
        InternetAddress[] ret = new InternetAddress[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (InternetAddress)a[i];
        }
        return ret;
    }

    @Override
    public void setMailSettings(UserSettingMail mailSettings) {
        throw new UnsupportedOperationException("ContentAwareComposedMailMessage.setMailSettings()");
    }

    @Override
    public UserSettingMail getMailSettings() {
        return null;
    }

    @Override
    public boolean containsFrom() {
        try {
            Address[] from = this.content.getFrom();
            return from != null && from.length > 0;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    @Override
    public InternetAddress[] getFrom() {
        try {
            return ContentAwareComposedMailMessage.convert(this.content.getFrom());
        }
        catch (MessagingException e) {
            return null;
        }
    }

    @Override
    public String getFirstHeader(String name) {
        try {
            return this.content.getHeader(name, null);
        }
        catch (MessagingException e) {
            return null;
        }
    }

    @Override
    public Object getContent() throws OXException {
        return this.content;
    }

    @Override
    public int getEnclosedCount() throws OXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBodyPart(TextBodyMailPart mailPart) {
    }

    @Override
    public TextBodyMailPart getBodyPart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MailPart removeEnclosedPart(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEnclosedPart(MailPart part) {
    }

    @Override
    public String getMailId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMailId(String id) {
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws OXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadContent() throws OXException {
    }

    @Override
    public void prepareForCaching() {
    }
}

