/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.config;

import com.openexchange.exception.OXException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.Initialization;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailPropertiesInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(MailPropertiesInit.class);
    private final AtomicBoolean started = new AtomicBoolean();
    private static final MailPropertiesInit instance = new MailPropertiesInit();

    private MailPropertiesInit() {
    }

    public static MailPropertiesInit getInstance() {
        return instance;
    }

    public void start() throws OXException {
        if (this.started.get()) {
            LOG.error("{} already started", (Object)this.getClass().getName());
            return;
        }
        MailProperties.getInstance().loadProperties();
        this.started.set(true);
    }

    public void stop() {
        if (!this.started.get()) {
            LOG.error("{} cannot be stopped since it has not been started before", (Object)this.getClass().getName());
            return;
        }
        MailProperties.getInstance().resetProperties();
        MailProperties.releaseInstance();
        this.started.set(false);
    }
}

