/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.event.impl.osgi.EventHandlerRegistration;
import com.openexchange.exception.OXException;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.session.Session;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAccessCacheEventListener
implements EventHandlerRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccessCacheEventListener.class);
    private volatile ServiceRegistration<EventHandler> serviceRegistration;

    public void handleEvent(Event event) {
        block11: {
            IMailAccessCache mac;
            String topic;
            block10: {
                IMailAccessCache mac2;
                topic = event.getTopic();
                if (!"com/openexchange/sessiond/remove/data".equals(topic) && !"com/openexchange/sessiond/remove/container".equals(topic)) break block10;
                Map sessions = (Map)event.getProperty("com.openexchange.sessiond.container");
                try {
                    mac2 = MailAccess.getMailAccessCache();
                }
                catch (OXException e) {
                    LOG.error("Managed mail access cache could not be obtained.", (Throwable)e);
                    return;
                }
                for (Session session : sessions.values()) {
                    if (session.isTransient()) continue;
                    try {
                        mac2.clearUserEntries(session);
                    }
                    catch (OXException e) {
                        LOG.error("Unable to clear cached mail access for session: {}", (Object)session.getSessionID(), (Object)e);
                    }
                }
                break block11;
            }
            if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block11;
            Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
            if (session.isTransient()) {
                return;
            }
            try {
                mac = MailAccess.getMailAccessCache();
            }
            catch (OXException e) {
                LOG.error("Managed mail access cache could not be obtained.", (Throwable)e);
                return;
            }
            try {
                mac.clearUserEntries(session);
            }
            catch (OXException e) {
                LOG.error("Unable to clear cached mail access for session: {}", (Object)session.getSessionID(), (Object)e);
            }
        }
    }

    @Override
    public void registerService(BundleContext context) {
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", new String[]{"com/openexchange/sessiond/remove/data", "com/openexchange/sessiond/remove/container", "com/openexchange/sessiond/remove/session"});
        this.serviceRegistration = context.registerService(EventHandler.class, (Object)this, serviceProperties);
    }

    @Override
    public void unregisterService() {
        ServiceRegistration<EventHandler> serviceRegistration = this.serviceRegistration;
        if (null != serviceRegistration) {
            serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

