/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginResult;
import com.openexchange.user.UserService;

public class LoginNameRecorder
implements LoginHandlerService {
    private static final String LOGIN_ATTRIBUTE_NAME = LoginNameRecorder.class.getSimpleName().toLowerCase() + "/user_login";
    private final UserService userService;

    public LoginNameRecorder(UserService userService) {
        this.userService = userService;
    }

    @Override
    public void handleLogin(LoginResult login) throws OXException {
        block3: {
            String loginValue = login.getSession().getLogin();
            Context ctx = login.getContext();
            if (login.getContext().isReadOnly()) {
                return;
            }
            try {
                this.userService.setAttribute(LOGIN_ATTRIBUTE_NAME, loginValue, login.getUser().getId(), ctx);
            }
            catch (OXException ex) {
                if (ex.getCode() == UserExceptionCode.CONCURRENT_ATTRIBUTES_UPDATE.getNumber() && ex.getPrefix().equalsIgnoreCase(UserExceptionCode.CONCURRENT_ATTRIBUTES_UPDATE.getPrefix())) break block3;
                throw ex;
            }
        }
    }

    @Override
    public void handleLogout(LoginResult logout) throws OXException {
    }
}

