/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ImageLocation {
    public static final String PROPERTY_REGISTRATION_NAME = "registrationName";
    public static final String PROPERTY_NO_ROUTE = "__noRoute";
    private final String accountId;
    private final String folder;
    private final String id;
    private final String imageId;
    private final String timestamp;
    private final String optImageHost;
    private final ConcurrentMap<String, Object> properties = new ConcurrentHashMap<String, Object>(2, 0.9f, 1);

    protected ImageLocation(Builder builder) {
        this.accountId = builder.accountId;
        this.folder = builder.folder;
        this.id = builder.id;
        this.imageId = builder.imageId;
        this.timestamp = builder.timestamp;
        this.optImageHost = builder.optImageHost;
    }

    public boolean putPropertyIfAbsent(String name, Object value) {
        return null == this.properties.putIfAbsent(name, value);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void putProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Set<String> propertyNames() {
        return this.properties.keySet();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getId() {
        return this.id;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getOptImageHost() {
        return this.optImageHost;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getRegistrationName() {
        return (String)this.properties.get(PROPERTY_REGISTRATION_NAME);
    }

    public void setRegistrationName(String registrationName) {
        this.properties.putIfAbsent(PROPERTY_REGISTRATION_NAME, registrationName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("ImageLocation [");
        if (this.accountId != null) {
            builder.append("accountId=").append(this.accountId).append(", ");
        }
        if (this.folder != null) {
            builder.append("folder=").append(this.folder).append(", ");
        }
        if (this.id != null) {
            builder.append("id=").append(this.id).append(", ");
        }
        if (this.imageId != null) {
            builder.append("imageId=").append(this.imageId).append(", ");
        }
        if (this.timestamp != null) {
            builder.append("timestamp=").append(this.timestamp).append(", ");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            builder.append("properties=").append(this.properties);
        }
        builder.append(']');
        return builder.toString();
    }

    public static final class Builder {
        protected String imageId;
        protected String accountId;
        protected String folder;
        protected String id;
        protected String timestamp;
        protected String optImageHost;
        protected String registrationName;

        public Builder() {
            this.imageId = null;
        }

        public Builder(String imageId) {
            this.imageId = imageId;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder folder(Object folder) {
            this.folder = folder.toString();
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder id(Object id) {
            this.id = id.toString();
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder optImageHost(String optImageHost) {
            this.optImageHost = optImageHost;
            return this;
        }

        public Builder registrationName(String registrationName) {
            this.registrationName = registrationName;
            return this;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }

        public ImageLocation build() {
            return new ImageLocation(this);
        }
    }
}

