/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.image;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.image.ImageActionFactory;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DispatcherNotes(defaultFormat="file", allowPublicSession=true, publicSessionAuth=true)
public class ImageGetAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(ImageGetAction.class);

    public ImageGetAction(ServiceLookup services) {
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        String serlvetRequestURI = requestData.getSerlvetRequestURI();
        if (null == serlvetRequestURI) {
            LOG.debug("Missing path information in image URL.");
            throw AjaxExceptionCodes.BAD_REQUEST.create("Unknown image location.");
        }
        ConcurrentMap<String, String> alias2regname = ImageActionFactory.alias2regName;
        String registrationName = (String)alias2regname.get(serlvetRequestURI);
        if (null == registrationName) {
            for (Map.Entry entry : alias2regname.entrySet()) {
                String alias = (String)entry.getKey();
                if (!serlvetRequestURI.contains(alias)) continue;
                registrationName = (String)entry.getValue();
                break;
            }
        }
        if (registrationName == null) {
            LOG.debug("Request URI cannot be resolved to an image location: {}", (Object)serlvetRequestURI);
            throw AjaxExceptionCodes.BAD_REQUEST.create("Unknown image location.");
        }
        ImageDataSource dataSource = null;
        try {
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class, true);
            dataSource = (ImageDataSource)conversionService.getDataSource(registrationName);
        }
        catch (OXException e) {
            LOG.debug("Missing ConversionService reference.", (Throwable)e);
            throw AjaxExceptionCodes.BAD_REQUEST.create();
        }
        if (dataSource == null) {
            LOG.debug("Data source cannot be found for: {}", (Object)registrationName);
            throw AjaxExceptionCodes.BAD_REQUEST.create("Invalid image location.");
        }
        try {
            ImageLocation imageLocation = dataSource.parseRequest(requestData);
            AJAXRequestResult requestResult = new AJAXRequestResult();
            String dataETag = dataSource.getETag(imageLocation, session);
            String clientETag = requestData.getHeader("If-None-Match");
            if (null != clientETag && clientETag.equals(dataETag)) {
                requestResult.setType(AJAXRequestResult.ResultType.ETAG);
                requestResult.setFormat("file");
                return requestResult;
            }
            requestResult = new AJAXRequestResult();
            ImageGetAction.obtainImageData(dataSource, imageLocation, session, requestResult);
            if (null != dataETag) {
                requestResult.setHeader("ETag", dataETag);
                requestResult.setExpires(Tools.getDefaultImageExpiry());
            }
            return requestResult;
        }
        catch (OXException e) {
            LOG.warn("Retrieving image failed.", (Throwable)e);
            if (ContactExceptionCodes.CONTACT_NOT_FOUND.equals(e)) {
                throw AjaxExceptionCodes.HTTP_ERROR.create(e, 404, e.getSoleMessage());
            }
            throw AjaxExceptionCodes.BAD_REQUEST.create(e, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Retrieving image failed.", (Throwable)e);
            throw AjaxExceptionCodes.BAD_REQUEST.create(e, new Object[0]);
        }
    }

    private static void obtainImageData(ImageDataSource dataSource, ImageLocation imageLocation, Session session, AJAXRequestResult requestResult) throws OXException {
        Data data = dataSource.getData(InputStream.class, dataSource.generateDataArgumentsFrom(imageLocation), session);
        DataProperties dataProperties = data.getDataProperties();
        String ct = dataProperties.get("com.openexchange.conversion.content-type");
        String fileName = dataProperties.get("com.openexchange.conversion.name");
        InputStream in = (InputStream)data.getData();
        FileHolder fileHolder = new FileHolder(in, -1L, ct, fileName);
        fileHolder.setDelivery("view");
        requestResult.setResultObject(fileHolder, "file");
    }
}

