/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.Locale;
import java.util.TimeZone;

public class FormatLocalizedStringReplacement
implements TemplateReplacement {
    private final TemplateToken token;
    private String format;
    private String replacement;
    private Locale locale;
    private boolean changed;
    private StringHelper stringHelper;

    public FormatLocalizedStringReplacement(TemplateToken token, String format, String replacement) {
        this.token = token;
        this.replacement = replacement;
        this.format = format;
    }

    @Override
    public TemplateReplacement setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        this.stringHelper = null;
        return this;
    }

    protected StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = this.locale == null ? StringHelper.valueOf(Locale.ENGLISH) : StringHelper.valueOf(this.locale);
        }
        return this.stringHelper;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return this.changed();
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public String getReplacement() {
        if (this.format == null) {
            return this.replacement;
        }
        String result = String.format(this.getStringHelper().getString(this.format), this.getStringHelper().getString(this.replacement));
        if (this.changed) {
            return new StringBuilder(result.length() + "* ".length()).append("* ").append(result).toString();
        }
        return result;
    }

    protected final String getSoleReplacement() {
        return this.replacement;
    }

    @Override
    public TemplateToken getToken() {
        return this.token;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        FormatLocalizedStringReplacement clone = (FormatLocalizedStringReplacement)super.clone();
        clone.locale = (Locale)this.locale.clone();
        return clone;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!FormatLocalizedStringReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        FormatLocalizedStringReplacement o = (FormatLocalizedStringReplacement)other;
        this.replacement = o.replacement;
        this.format = o.format;
        this.changed = true;
        return true;
    }
}

