/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateReplacement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractDateReplacement
implements TemplateReplacement {
    private static final String PAT_ZONE = ", z";
    private static final String PAT_DAY_OF_WEEK = "EEEE, ";
    protected final boolean withTime;
    protected Date date;
    protected boolean changed;
    protected DateFormat dateFormat;
    protected Locale locale;
    protected TimeZone timeZone;

    protected AbstractDateReplacement(Date date, boolean withTime) {
        this(date, withTime, null, null);
    }

    protected AbstractDateReplacement(Date date, boolean withTime, Locale locale, TimeZone timeZone) {
        this.withTime = withTime;
        this.date = date;
        this.dateFormat = AbstractDateReplacement.getDateFormat(withTime, locale, timeZone);
        this.timeZone = !withTime ? TimeZone.getTimeZone("UTC") : timeZone;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDateReplacement clone = (AbstractDateReplacement)super.clone();
        clone.date = (Date)(this.date == null ? null : this.date.clone());
        clone.dateFormat = (DateFormat)(this.dateFormat == null ? null : this.dateFormat.clone());
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        clone.timeZone = (TimeZone)(this.timeZone == null ? null : this.timeZone.clone());
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public final boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return this.changed();
    }

    @Override
    public final TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public String getReplacement() {
        return this.date == null ? "" : this.dateFormat.format(this.date);
    }

    @Override
    public final TemplateReplacement setTimeZone(TimeZone timeZone) {
        this.applyTimeZone(timeZone);
        return this;
    }

    @Override
    public final TemplateReplacement setLocale(Locale locale) {
        this.applyLocale(locale);
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!AbstractDateReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        AbstractDateReplacement o = (AbstractDateReplacement)other;
        this.date = null == o.date ? null : new Date(o.date.getTime());
        this.changed = true;
        return true;
    }

    private void applyLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.dateFormat = AbstractDateReplacement.getDateFormat(this.withTime, locale, this.timeZone);
    }

    private void applyTimeZone(TimeZone timeZone) {
        if (timeZone == null || timeZone.equals(this.timeZone) || !this.withTime) {
            return;
        }
        if (this.withTime && this.timeZone == null && this.dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormat;
            String pattern = simpleDateFormat.toPattern();
            simpleDateFormat.applyPattern(new StringBuilder(pattern.length() + 3).append(pattern).append(PAT_ZONE).toString());
        }
        this.timeZone = timeZone;
        this.dateFormat.setTimeZone(timeZone);
    }

    private static DateFormat getDateFormat(boolean withTime, Locale locale, TimeZone timeZone) {
        Locale l;
        Locale locale2 = l = locale == null ? Locale.ENGLISH : locale;
        if (withTime) {
            SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, l);
            String pattern = sdf.toPattern();
            StringBuilder builder = new StringBuilder(pattern.length() + 9).append(PAT_DAY_OF_WEEK).append(pattern);
            if (null != timeZone) {
                builder.append(PAT_ZONE);
                sdf.applyPattern(builder.toString());
                sdf.setTimeZone(timeZone);
            } else {
                sdf.applyPattern(builder.toString());
            }
            return sdf;
        }
        DateFormat format = DateFormat.getDateInstance(2, l);
        format.setTimeZone(timeZone);
        return format;
    }
}

